/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdfpatch.filelog;

import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import org.apache.jena.rdfpatch.filelog.FilePolicy;
import org.apache.jena.rdfpatch.filelog.rotate.ManagedOutput;
import org.apache.jena.rdfpatch.filelog.rotate.OutputFixed;
import org.apache.jena.rdfpatch.filelog.rotate.OutputManagedFile;

public class OutputMgr {
    public static ManagedOutput create(String directoryName, String baseFilename, FilePolicy strategy) {
        Objects.requireNonNull(directoryName);
        Objects.requireNonNull(baseFilename);
        Objects.requireNonNull(strategy);
        return new OutputManagedFile(Paths.get(directoryName, new String[0]), baseFilename, strategy);
    }

    public static ManagedOutput create(Path directory, String baseFilename, FilePolicy strategy) {
        Objects.requireNonNull(directory);
        Objects.requireNonNull(baseFilename);
        Objects.requireNonNull(strategy);
        return new OutputManagedFile(directory, baseFilename, strategy);
    }

    public static ManagedOutput create(String pathName, FilePolicy strategy) {
        Objects.requireNonNull(pathName);
        Objects.requireNonNull(strategy);
        if (pathName.equals("-")) {
            return new OutputFixed(System.out);
        }
        Path p = Paths.get(pathName, new String[0]).toAbsolutePath();
        return new OutputManagedFile(p.getParent(), p.getFileName().toString(), strategy);
    }

    public static ManagedOutput create(OutputStream outputStream) {
        return new OutputFixed(outputStream);
    }
}

