/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.dboe.trans.bplustree;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.dboe.base.record.Record;
import org.apache.jena.dboe.trans.bplustree.AccessPath;
import org.apache.jena.dboe.trans.bplustree.BPTreeNode;
import org.apache.jena.dboe.trans.bplustree.BPTreePage;
import org.apache.jena.dboe.trans.bplustree.BPTreeRecords;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BPTreeDistinctKeyPrefixIterator
implements Iterator<Record> {
    static Logger log = LoggerFactory.getLogger(BPTreeDistinctKeyPrefixIterator.class);
    private final Deque<Iterator<BPTreePage>> stack = new ArrayDeque<Iterator<BPTreePage>>();
    private Iterator<Record> current;
    private Record slot = null;
    private Record minRecord;
    private Record maxRecord;
    private byte[] lastPrefix = null;
    private boolean finished = false;
    private final int keyPrefixLength;

    public static Iterator<Record> create(BPTreeNode node, int keyPrefixLength) {
        if (keyPrefixLength < 1) {
            throw new IllegalArgumentException("keyPrefixLength must be >= 1");
        }
        if (keyPrefixLength > node.params.recordFactory.keyLength()) {
            throw new IllegalArgumentException("Maximum keyPrefixLength for this B+Tree is " + node.params.recordFactory.keyLength());
        }
        Record minRecord = node.minRecord();
        Record maxRecord = node.maxRecord();
        if (minRecord == null) {
            return Iter.nullIter();
        }
        if (Arrays.compare(minRecord.getKey(), 0, keyPrefixLength, maxRecord.getKey(), 0, keyPrefixLength) == 0) {
            return Iter.singletonIterator(minRecord);
        }
        return new BPTreeDistinctKeyPrefixIterator(node, keyPrefixLength, minRecord, maxRecord);
    }

    BPTreeDistinctKeyPrefixIterator(BPTreeNode node, int keyPrefixLength, Record minRecord, Record maxRecord) {
        this.keyPrefixLength = keyPrefixLength;
        this.minRecord = minRecord;
        this.maxRecord = maxRecord;
        BPTreeRecords r = this.loadStack(node);
        this.current = this.getRecordsIterator(r);
    }

    @Override
    public boolean hasNext() {
        if (this.finished) {
            return false;
        }
        if (this.slot != null) {
            return true;
        }
        while (true) {
            if (this.current == null) {
                this.end();
                return false;
            }
            if (this.current.hasNext()) {
                Record next = this.current.next();
                if (this.lastPrefix == null) {
                    return this.populateSlot(next);
                }
                if (Arrays.compare(this.lastPrefix, 0, this.keyPrefixLength, next.getKey(), 0, this.keyPrefixLength) == 0) continue;
                return this.populateSlot(next);
            }
            this.current = this.moveOnCurrent();
        }
    }

    private boolean populateSlot(Record next) {
        this.slot = next;
        this.lastPrefix = next.getKey();
        return true;
    }

    private Iterator<Record> moveOnCurrent() {
        BPTreeRecords r;
        Iterator<BPTreePage> iter = null;
        while (!this.stack.isEmpty() && !(iter = this.stack.peek()).hasNext()) {
            this.stack.pop();
        }
        if (iter == null || !iter.hasNext()) {
            return null;
        }
        BPTreePage p = iter.next();
        if (p instanceof BPTreeNode) {
            Record subtreeMax;
            BPTreeNode n = (BPTreeNode)p;
            Record subtreeMin = n.minRecord();
            if (this.haveSamePrefix(subtreeMin, subtreeMax = n.maxRecord())) {
                return Iter.singletonIterator(subtreeMin);
            }
            r = this.loadStack(n);
        } else {
            r = (BPTreeRecords)p;
        }
        return this.getRecordsIterator(r);
    }

    protected final boolean haveSamePrefix(Record a, Record b) {
        return Arrays.compare(a.getKey(), 0, this.keyPrefixLength, b.getKey(), 0, this.keyPrefixLength) == 0;
    }

    protected Iterator<Record> getRecordsIterator(BPTreeRecords records) {
        Record lowRecord;
        records.bpTree.startReadBlkMgr();
        Iterator<Record> iter = !records.hasAnyKeys() ? Iter.nullIterator() : (this.haveSamePrefix(lowRecord = records.getLowRecord(), records.getHighRecord()) ? Iter.singletonIterator(lowRecord) : records.getRecordBuffer().iterator());
        records.bpTree.finishReadBlkMgr();
        return iter;
    }

    private BPTreeRecords loadStack(BPTreeNode node) {
        AccessPath path = new AccessPath(null);
        node.bpTree.startReadBlkMgr();
        node.internalMinRecord(path);
        List<AccessPath.AccessStep> steps = path.getPath();
        for (AccessPath.AccessStep step : steps) {
            BPTreeNode n = step.node;
            Iterator<BPTreePage> it = n.iterator(this.minRecord, this.maxRecord);
            if (it == null || !it.hasNext()) continue;
            it.next();
            this.stack.push(it);
        }
        BPTreePage p = steps.get((int)(steps.size() - 1)).page;
        if (!(p instanceof BPTreeRecords)) {
            throw new InternalErrorException("Last path step not to a records block");
        }
        node.bpTree.finishReadBlkMgr();
        return (BPTreeRecords)p;
    }

    private void end() {
        this.finished = true;
        this.current = null;
    }

    public void close() {
        if (!this.finished) {
            this.end();
        }
    }

    @Override
    public Record next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Record r = this.slot;
        if (r == null) {
            throw new InternalErrorException("Null slot after hasNext is true");
        }
        this.slot = null;
        return r;
    }
}

