/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene90;

import java.io.IOException;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.codecs.lucene90.IndexedDISI;
import org.apache.lucene.codecs.lucene90.Lucene90DocValuesFormat;
import org.apache.lucene.index.BaseTermsEnum;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.DocValuesSkipIndexType;
import org.apache.lucene.index.DocValuesSkipper;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.ImpactsEnum;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.internal.hppc.IntObjectHashMap;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.FileTypeHint;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.RandomAccessInput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.LongValues;
import org.apache.lucene.util.compress.LZ4;
import org.apache.lucene.util.packed.DirectMonotonicReader;
import org.apache.lucene.util.packed.DirectReader;

final class Lucene90DocValuesProducer
extends DocValuesProducer {
    private final IntObjectHashMap<NumericEntry> numerics;
    private final IntObjectHashMap<BinaryEntry> binaries;
    private final IntObjectHashMap<SortedEntry> sorted;
    private final IntObjectHashMap<SortedSetEntry> sortedSets;
    private final IntObjectHashMap<SortedNumericEntry> sortedNumerics;
    private final IntObjectHashMap<DocValuesSkipperEntry> skippers;
    private final IndexInput data;
    private final int maxDoc;
    private int version;
    private final boolean merging;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Lucene90DocValuesProducer(SegmentReadState state, String dataCodec, String dataExtension, String metaCodec, String metaExtension) throws IOException {
        block14: {
            this.version = -1;
            String metaName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, metaExtension);
            this.maxDoc = state.segmentInfo.maxDoc();
            this.numerics = new IntObjectHashMap();
            this.binaries = new IntObjectHashMap();
            this.sorted = new IntObjectHashMap();
            this.sortedSets = new IntObjectHashMap();
            this.sortedNumerics = new IntObjectHashMap();
            this.skippers = new IntObjectHashMap();
            this.merging = false;
            try (ChecksumIndexInput in = state.directory.openChecksumInput(metaName);){
                Throwable priorE = null;
                try {
                    this.version = CodecUtil.checkIndexHeader(in, metaCodec, 0, 0, state.segmentInfo.getId(), state.segmentSuffix);
                    this.readFields(in, state.fieldInfos);
                }
                catch (Throwable exception) {
                    try {
                        priorE = exception;
                        break block14;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        CodecUtil.checkFooter(in, priorE);
                    }
                }
                CodecUtil.checkFooter(in, priorE);
            }
        }
        String dataName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, dataExtension);
        this.data = state.directory.openInput(dataName, state.context.withHints(FileTypeHint.DATA));
        boolean success = false;
        try {
            int version2 = CodecUtil.checkIndexHeader(this.data, dataCodec, 0, 0, state.segmentInfo.getId(), state.segmentSuffix);
            if (this.version != version2) {
                throw new CorruptIndexException("Format versions mismatch: meta=" + this.version + ", data=" + version2, this.data);
            }
            CodecUtil.retrieveChecksum(this.data);
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException(this.data);
            throw throwable;
        }
    }

    private Lucene90DocValuesProducer(IntObjectHashMap<NumericEntry> numerics, IntObjectHashMap<BinaryEntry> binaries, IntObjectHashMap<SortedEntry> sorted, IntObjectHashMap<SortedSetEntry> sortedSets, IntObjectHashMap<SortedNumericEntry> sortedNumerics, IntObjectHashMap<DocValuesSkipperEntry> skippers, IndexInput data, int maxDoc, int version2, boolean merging) {
        this.version = -1;
        this.numerics = numerics;
        this.binaries = binaries;
        this.sorted = sorted;
        this.sortedSets = sortedSets;
        this.sortedNumerics = sortedNumerics;
        this.skippers = skippers;
        this.data = data.clone();
        this.maxDoc = maxDoc;
        this.version = version2;
        this.merging = merging;
    }

    @Override
    public DocValuesProducer getMergeInstance() {
        return new Lucene90DocValuesProducer(this.numerics, this.binaries, this.sorted, this.sortedSets, this.sortedNumerics, this.skippers, this.data, this.maxDoc, this.version, true);
    }

    private void readFields(IndexInput meta, FieldInfos infos) throws IOException {
        int fieldNumber = meta.readInt();
        while (fieldNumber != -1) {
            FieldInfo info = infos.fieldInfo(fieldNumber);
            if (info == null) {
                throw new CorruptIndexException("Invalid field number: " + fieldNumber, meta);
            }
            byte type = meta.readByte();
            if (info.docValuesSkipIndexType() != DocValuesSkipIndexType.NONE) {
                this.skippers.put(info.number, this.readDocValueSkipperMeta(meta));
            }
            if (type == 0) {
                this.numerics.put(info.number, this.readNumeric(meta));
            } else if (type == 1) {
                this.binaries.put(info.number, this.readBinary(meta));
            } else if (type == 2) {
                this.sorted.put(info.number, this.readSorted(meta));
            } else if (type == 3) {
                this.sortedSets.put(info.number, this.readSortedSet(meta));
            } else if (type == 4) {
                this.sortedNumerics.put(info.number, this.readSortedNumeric(meta));
            } else {
                throw new CorruptIndexException("invalid type: " + type, meta);
            }
            fieldNumber = meta.readInt();
        }
    }

    private NumericEntry readNumeric(IndexInput meta) throws IOException {
        NumericEntry entry = new NumericEntry();
        this.readNumeric(meta, entry);
        return entry;
    }

    private DocValuesSkipperEntry readDocValueSkipperMeta(IndexInput meta) throws IOException {
        long offset = meta.readLong();
        long length = meta.readLong();
        long maxValue = meta.readLong();
        long minValue = meta.readLong();
        int docCount = meta.readInt();
        int maxDocID = meta.readInt();
        return new DocValuesSkipperEntry(offset, length, minValue, maxValue, docCount, maxDocID);
    }

    private void readNumeric(IndexInput meta, NumericEntry entry) throws IOException {
        entry.docsWithFieldOffset = meta.readLong();
        entry.docsWithFieldLength = meta.readLong();
        entry.jumpTableEntryCount = meta.readShort();
        entry.denseRankPower = meta.readByte();
        entry.numValues = meta.readLong();
        int tableSize = meta.readInt();
        if (tableSize > 256) {
            throw new CorruptIndexException("invalid table size: " + tableSize, meta);
        }
        if (tableSize >= 0) {
            entry.table = new long[tableSize];
            for (int i = 0; i < tableSize; ++i) {
                entry.table[i] = meta.readLong();
            }
        }
        entry.blockShift = tableSize < -1 ? -2 - tableSize : -1;
        entry.bitsPerValue = meta.readByte();
        entry.minValue = meta.readLong();
        entry.gcd = meta.readLong();
        entry.valuesOffset = meta.readLong();
        entry.valuesLength = meta.readLong();
        entry.valueJumpTableOffset = meta.readLong();
    }

    private BinaryEntry readBinary(IndexInput meta) throws IOException {
        BinaryEntry entry = new BinaryEntry();
        entry.dataOffset = meta.readLong();
        entry.dataLength = meta.readLong();
        entry.docsWithFieldOffset = meta.readLong();
        entry.docsWithFieldLength = meta.readLong();
        entry.jumpTableEntryCount = meta.readShort();
        entry.denseRankPower = meta.readByte();
        entry.numDocsWithField = meta.readInt();
        entry.minLength = meta.readInt();
        entry.maxLength = meta.readInt();
        if (entry.minLength < entry.maxLength) {
            entry.addressesOffset = meta.readLong();
            long numAddresses = (long)entry.numDocsWithField + 1L;
            int blockShift = meta.readVInt();
            entry.addressesMeta = DirectMonotonicReader.loadMeta(meta, numAddresses, blockShift);
            entry.addressesLength = meta.readLong();
        }
        return entry;
    }

    private SortedEntry readSorted(IndexInput meta) throws IOException {
        SortedEntry entry = new SortedEntry();
        entry.ordsEntry = new NumericEntry();
        this.readNumeric(meta, entry.ordsEntry);
        entry.termsDictEntry = new TermsDictEntry();
        Lucene90DocValuesProducer.readTermDict(meta, entry.termsDictEntry);
        return entry;
    }

    private SortedSetEntry readSortedSet(IndexInput meta) throws IOException {
        SortedSetEntry entry = new SortedSetEntry();
        byte multiValued = meta.readByte();
        switch (multiValued) {
            case 0: {
                entry.singleValueEntry = this.readSorted(meta);
                return entry;
            }
            case 1: {
                break;
            }
            default: {
                throw new CorruptIndexException("Invalid multiValued flag: " + multiValued, meta);
            }
        }
        entry.ordsEntry = new SortedNumericEntry();
        this.readSortedNumeric(meta, entry.ordsEntry);
        entry.termsDictEntry = new TermsDictEntry();
        Lucene90DocValuesProducer.readTermDict(meta, entry.termsDictEntry);
        return entry;
    }

    private static void readTermDict(IndexInput meta, TermsDictEntry entry) throws IOException {
        entry.termsDictSize = meta.readVLong();
        int blockShift = meta.readInt();
        long addressesSize = entry.termsDictSize + 64L - 1L >>> 6;
        entry.termsAddressesMeta = DirectMonotonicReader.loadMeta(meta, addressesSize, blockShift);
        entry.maxTermLength = meta.readInt();
        entry.maxBlockLength = meta.readInt();
        entry.termsDataOffset = meta.readLong();
        entry.termsDataLength = meta.readLong();
        entry.termsAddressesOffset = meta.readLong();
        entry.termsAddressesLength = meta.readLong();
        entry.termsDictIndexShift = meta.readInt();
        long indexSize = entry.termsDictSize + (1L << entry.termsDictIndexShift) - 1L >>> entry.termsDictIndexShift;
        entry.termsIndexAddressesMeta = DirectMonotonicReader.loadMeta(meta, 1L + indexSize, blockShift);
        entry.termsIndexOffset = meta.readLong();
        entry.termsIndexLength = meta.readLong();
        entry.termsIndexAddressesOffset = meta.readLong();
        entry.termsIndexAddressesLength = meta.readLong();
    }

    private SortedNumericEntry readSortedNumeric(IndexInput meta) throws IOException {
        SortedNumericEntry entry = new SortedNumericEntry();
        this.readSortedNumeric(meta, entry);
        return entry;
    }

    private SortedNumericEntry readSortedNumeric(IndexInput meta, SortedNumericEntry entry) throws IOException {
        this.readNumeric(meta, entry);
        entry.numDocsWithField = meta.readInt();
        if ((long)entry.numDocsWithField != entry.numValues) {
            entry.addressesOffset = meta.readLong();
            int blockShift = meta.readVInt();
            entry.addressesMeta = DirectMonotonicReader.loadMeta(meta, entry.numDocsWithField + 1, blockShift);
            entry.addressesLength = meta.readLong();
        }
        return entry;
    }

    @Override
    public void close() throws IOException {
        this.data.close();
    }

    @Override
    public NumericDocValues getNumeric(FieldInfo field) throws IOException {
        NumericEntry entry = this.numerics.get(field.number);
        return this.getNumeric(entry);
    }

    private LongValues getDirectReaderInstance(RandomAccessInput slice, int bitsPerValue, long offset, long numValues) {
        if (this.merging) {
            return DirectReader.getMergeInstance(slice, bitsPerValue, offset, numValues);
        }
        return DirectReader.getInstance(slice, bitsPerValue, offset);
    }

    private NumericDocValues getNumeric(final NumericEntry entry) throws IOException {
        if (entry.docsWithFieldOffset == -2L) {
            return DocValues.emptyNumeric();
        }
        if (entry.docsWithFieldOffset == -1L) {
            if (entry.bitsPerValue == 0) {
                return new DenseNumericDocValues(this, this.maxDoc){

                    @Override
                    public long longValue() throws IOException {
                        return entry.minValue;
                    }
                };
            }
            final RandomAccessInput slice = this.data.randomAccessSlice(entry.valuesOffset, entry.valuesLength);
            if (slice.length() > 0L) {
                slice.prefetch(0L, 1L);
            }
            if (entry.blockShift >= 0) {
                return new DenseNumericDocValues(this.maxDoc){
                    final VaryingBPVReader vBPVReader;
                    {
                        super(maxDoc);
                        this.vBPVReader = new VaryingBPVReader(entry, slice);
                    }

                    @Override
                    public long longValue() throws IOException {
                        return this.vBPVReader.getLongValue(this.doc);
                    }
                };
            }
            final LongValues values = this.getDirectReaderInstance(slice, entry.bitsPerValue, 0L, entry.numValues);
            if (entry.table != null) {
                final long[] table = entry.table;
                return new DenseNumericDocValues(this, this.maxDoc){

                    @Override
                    public long longValue() throws IOException {
                        return table[(int)values.get(this.doc)];
                    }
                };
            }
            if (entry.gcd == 1L && entry.minValue == 0L) {
                return new DenseNumericDocValues(this, this.maxDoc){

                    @Override
                    public long longValue() throws IOException {
                        return values.get(this.doc);
                    }
                };
            }
            final long mul = entry.gcd;
            final long delta = entry.minValue;
            return new DenseNumericDocValues(this, this.maxDoc){

                @Override
                public long longValue() throws IOException {
                    return mul * values.get(this.doc) + delta;
                }
            };
        }
        IndexedDISI disi = new IndexedDISI(this.data, entry.docsWithFieldOffset, entry.docsWithFieldLength, entry.jumpTableEntryCount, entry.denseRankPower, entry.numValues);
        if (entry.bitsPerValue == 0) {
            return new SparseNumericDocValues(this, disi){

                @Override
                public long longValue() throws IOException {
                    return entry.minValue;
                }
            };
        }
        final RandomAccessInput slice = this.data.randomAccessSlice(entry.valuesOffset, entry.valuesLength);
        if (slice.length() > 0L) {
            slice.prefetch(0L, 1L);
        }
        if (entry.blockShift >= 0) {
            return new SparseNumericDocValues(disi){
                final VaryingBPVReader vBPVReader;
                {
                    super(disi);
                    this.vBPVReader = new VaryingBPVReader(entry, slice);
                }

                @Override
                public long longValue() throws IOException {
                    int index = this.disi.index();
                    return this.vBPVReader.getLongValue(index);
                }
            };
        }
        final LongValues values = this.getDirectReaderInstance(slice, entry.bitsPerValue, 0L, entry.numValues);
        if (entry.table != null) {
            final long[] table = entry.table;
            return new SparseNumericDocValues(this, disi){

                @Override
                public long longValue() throws IOException {
                    return table[(int)values.get(this.disi.index())];
                }
            };
        }
        if (entry.gcd == 1L && entry.minValue == 0L) {
            return new SparseNumericDocValues(this, disi){

                @Override
                public long longValue() throws IOException {
                    return values.get(this.disi.index());
                }
            };
        }
        final long mul = entry.gcd;
        final long delta = entry.minValue;
        return new SparseNumericDocValues(this, disi){

            @Override
            public long longValue() throws IOException {
                return mul * values.get(this.disi.index()) + delta;
            }
        };
    }

    private LongValues getNumericValues(final NumericEntry entry) throws IOException {
        if (entry.bitsPerValue == 0) {
            return new LongValues(this){

                @Override
                public long get(long index) {
                    return entry.minValue;
                }
            };
        }
        final RandomAccessInput slice = this.data.randomAccessSlice(entry.valuesOffset, entry.valuesLength);
        if (slice.length() > 0L) {
            slice.prefetch(0L, 1L);
        }
        if (entry.blockShift >= 0) {
            return new LongValues(){
                final VaryingBPVReader vBPVReader;
                {
                    this.vBPVReader = new VaryingBPVReader(entry, slice);
                }

                @Override
                public long get(long index) {
                    try {
                        return this.vBPVReader.getLongValue(index);
                    }
                    catch (IOException e2) {
                        throw new RuntimeException(e2);
                    }
                }
            };
        }
        final LongValues values = this.getDirectReaderInstance(slice, entry.bitsPerValue, 0L, entry.numValues);
        if (entry.table != null) {
            final long[] table = entry.table;
            return new LongValues(this){

                @Override
                public long get(long index) {
                    return table[(int)values.get(index)];
                }
            };
        }
        if (entry.gcd != 1L) {
            final long gcd = entry.gcd;
            final long minValue = entry.minValue;
            return new LongValues(this){

                @Override
                public long get(long index) {
                    return values.get(index) * gcd + minValue;
                }
            };
        }
        if (entry.minValue != 0L) {
            final long minValue = entry.minValue;
            return new LongValues(this){

                @Override
                public long get(long index) {
                    return values.get(index) + minValue;
                }
            };
        }
        return values;
    }

    @Override
    public BinaryDocValues getBinary(FieldInfo field) throws IOException {
        final BinaryEntry entry = this.binaries.get(field.number);
        if (entry.docsWithFieldOffset == -2L) {
            return DocValues.emptyBinary();
        }
        final RandomAccessInput bytesSlice = this.data.randomAccessSlice(entry.dataOffset, entry.dataLength);
        if (bytesSlice.length() > 0L) {
            bytesSlice.prefetch(0L, 1L);
        }
        if (entry.docsWithFieldOffset == -1L) {
            if (entry.minLength == entry.maxLength) {
                final int length = entry.maxLength;
                return new DenseBinaryDocValues(this, this.maxDoc){
                    final BytesRef bytes;
                    {
                        super(maxDoc);
                        this.bytes = new BytesRef(new byte[length], 0, length);
                    }

                    @Override
                    public BytesRef binaryValue() throws IOException {
                        bytesSlice.readBytes((long)this.doc * (long)length, this.bytes.bytes, 0, length);
                        return this.bytes;
                    }
                };
            }
            RandomAccessInput addressesData = this.data.randomAccessSlice(entry.addressesOffset, entry.addressesLength);
            if (addressesData.length() > 0L) {
                addressesData.prefetch(0L, 1L);
            }
            final DirectMonotonicReader addresses = DirectMonotonicReader.getInstance(entry.addressesMeta, addressesData, this.merging);
            return new DenseBinaryDocValues(this, this.maxDoc){
                final BytesRef bytes;
                {
                    super(maxDoc);
                    this.bytes = new BytesRef(new byte[entry.maxLength], 0, entry.maxLength);
                }

                @Override
                public BytesRef binaryValue() throws IOException {
                    long startOffset = addresses.get(this.doc);
                    this.bytes.length = (int)(addresses.get((long)this.doc + 1L) - startOffset);
                    bytesSlice.readBytes(startOffset, this.bytes.bytes, 0, this.bytes.length);
                    return this.bytes;
                }
            };
        }
        IndexedDISI disi = new IndexedDISI(this.data, entry.docsWithFieldOffset, entry.docsWithFieldLength, entry.jumpTableEntryCount, entry.denseRankPower, entry.numDocsWithField);
        if (entry.minLength == entry.maxLength) {
            final int length = entry.maxLength;
            return new SparseBinaryDocValues(this, disi){
                final BytesRef bytes;
                {
                    super(disi);
                    this.bytes = new BytesRef(new byte[length], 0, length);
                }

                @Override
                public BytesRef binaryValue() throws IOException {
                    bytesSlice.readBytes((long)this.disi.index() * (long)length, this.bytes.bytes, 0, length);
                    return this.bytes;
                }
            };
        }
        RandomAccessInput addressesData = this.data.randomAccessSlice(entry.addressesOffset, entry.addressesLength);
        if (addressesData.length() > 0L) {
            addressesData.prefetch(0L, 1L);
        }
        final DirectMonotonicReader addresses = DirectMonotonicReader.getInstance(entry.addressesMeta, addressesData);
        return new SparseBinaryDocValues(this, disi){
            final BytesRef bytes;
            {
                super(disi);
                this.bytes = new BytesRef(new byte[entry.maxLength], 0, entry.maxLength);
            }

            @Override
            public BytesRef binaryValue() throws IOException {
                int index = this.disi.index();
                long startOffset = addresses.get(index);
                this.bytes.length = (int)(addresses.get((long)index + 1L) - startOffset);
                bytesSlice.readBytes(startOffset, this.bytes.bytes, 0, this.bytes.length);
                return this.bytes;
            }
        };
    }

    @Override
    public SortedDocValues getSorted(FieldInfo field) throws IOException {
        SortedEntry entry = this.sorted.get(field.number);
        return this.getSorted(entry);
    }

    private SortedDocValues getSorted(SortedEntry entry) throws IOException {
        NumericEntry ordsEntry = entry.ordsEntry;
        if (ordsEntry.blockShift < 0 && ordsEntry.bitsPerValue > 0) {
            if (ordsEntry.gcd != 1L || ordsEntry.minValue != 0L || ordsEntry.table != null) {
                throw new IllegalStateException("Ordinals shouldn't use GCD, offset or table compression");
            }
            RandomAccessInput slice = this.data.randomAccessSlice(ordsEntry.valuesOffset, ordsEntry.valuesLength);
            if (slice.length() > 0L) {
                slice.prefetch(0L, 1L);
            }
            final LongValues values = this.getDirectReaderInstance(slice, ordsEntry.bitsPerValue, 0L, ordsEntry.numValues);
            if (ordsEntry.docsWithFieldOffset == -1L) {
                return new BaseSortedDocValues(entry){
                    private final int maxDoc;
                    private int doc;
                    {
                        super(entry);
                        this.maxDoc = Lucene90DocValuesProducer.this.maxDoc;
                        this.doc = -1;
                    }

                    @Override
                    public int ordValue() throws IOException {
                        return (int)values.get(this.doc);
                    }

                    @Override
                    public boolean advanceExact(int target) throws IOException {
                        this.doc = target;
                        return true;
                    }

                    @Override
                    public int docID() {
                        return this.doc;
                    }

                    @Override
                    public int nextDoc() throws IOException {
                        return this.advance(this.doc + 1);
                    }

                    @Override
                    public int advance(int target) throws IOException {
                        if (target >= this.maxDoc) {
                            this.doc = Integer.MAX_VALUE;
                            return Integer.MAX_VALUE;
                        }
                        this.doc = target;
                        return this.doc;
                    }

                    @Override
                    public long cost() {
                        return this.maxDoc;
                    }

                    @Override
                    public int docIDRunEnd() throws IOException {
                        return this.maxDoc;
                    }
                };
            }
            if (ordsEntry.docsWithFieldOffset >= 0L) {
                final IndexedDISI disi = new IndexedDISI(this.data, ordsEntry.docsWithFieldOffset, ordsEntry.docsWithFieldLength, ordsEntry.jumpTableEntryCount, ordsEntry.denseRankPower, ordsEntry.numValues);
                return new BaseSortedDocValues(this, entry){

                    @Override
                    public int ordValue() throws IOException {
                        return (int)values.get(disi.index());
                    }

                    @Override
                    public boolean advanceExact(int target) throws IOException {
                        return disi.advanceExact(target);
                    }

                    @Override
                    public int docID() {
                        return disi.docID();
                    }

                    @Override
                    public int nextDoc() throws IOException {
                        return disi.nextDoc();
                    }

                    @Override
                    public int advance(int target) throws IOException {
                        return disi.advance(target);
                    }

                    @Override
                    public void intoBitSet(int upTo, FixedBitSet bitSet, int offset) throws IOException {
                        disi.intoBitSet(upTo, bitSet, offset);
                    }

                    @Override
                    public long cost() {
                        return disi.cost();
                    }

                    @Override
                    public int docIDRunEnd() throws IOException {
                        return disi.docIDRunEnd();
                    }
                };
            }
        }
        final NumericDocValues ords = this.getNumeric(entry.ordsEntry);
        return new BaseSortedDocValues(this, entry){

            @Override
            public int ordValue() throws IOException {
                return (int)ords.longValue();
            }

            @Override
            public boolean advanceExact(int target) throws IOException {
                return ords.advanceExact(target);
            }

            @Override
            public int docID() {
                return ords.docID();
            }

            @Override
            public int nextDoc() throws IOException {
                return ords.nextDoc();
            }

            @Override
            public int advance(int target) throws IOException {
                return ords.advance(target);
            }

            @Override
            public long cost() {
                return ords.cost();
            }

            @Override
            public int docIDRunEnd() throws IOException {
                return ords.docIDRunEnd();
            }
        };
    }

    @Override
    public SortedNumericDocValues getSortedNumeric(FieldInfo field) throws IOException {
        SortedNumericEntry entry = this.sortedNumerics.get(field.number);
        return this.getSortedNumeric(entry);
    }

    private SortedNumericDocValues getSortedNumeric(SortedNumericEntry entry) throws IOException {
        if (entry.numValues == (long)entry.numDocsWithField) {
            return DocValues.singleton(this.getNumeric(entry));
        }
        RandomAccessInput addressesInput = this.data.randomAccessSlice(entry.addressesOffset, entry.addressesLength);
        if (addressesInput.length() > 0L) {
            addressesInput.prefetch(0L, 1L);
        }
        final DirectMonotonicReader addresses = DirectMonotonicReader.getInstance(entry.addressesMeta, addressesInput, this.merging);
        final LongValues values = this.getNumericValues(entry);
        if (entry.docsWithFieldOffset == -1L) {
            return new SortedNumericDocValues(){
                int doc = -1;
                long start;
                long end;
                int count;

                @Override
                public int nextDoc() throws IOException {
                    return this.advance(this.doc + 1);
                }

                @Override
                public int docID() {
                    return this.doc;
                }

                @Override
                public long cost() {
                    return Lucene90DocValuesProducer.this.maxDoc;
                }

                @Override
                public int advance(int target) throws IOException {
                    if (target >= Lucene90DocValuesProducer.this.maxDoc) {
                        this.doc = Integer.MAX_VALUE;
                        return Integer.MAX_VALUE;
                    }
                    this.start = addresses.get(target);
                    this.end = addresses.get((long)target + 1L);
                    this.count = (int)(this.end - this.start);
                    this.doc = target;
                    return this.doc;
                }

                @Override
                public boolean advanceExact(int target) throws IOException {
                    this.start = addresses.get(target);
                    this.end = addresses.get((long)target + 1L);
                    this.count = (int)(this.end - this.start);
                    this.doc = target;
                    return true;
                }

                @Override
                public long nextValue() throws IOException {
                    return values.get(this.start++);
                }

                @Override
                public int docValueCount() {
                    return this.count;
                }

                @Override
                public int docIDRunEnd() throws IOException {
                    return Lucene90DocValuesProducer.this.maxDoc;
                }
            };
        }
        final IndexedDISI disi = new IndexedDISI(this.data, entry.docsWithFieldOffset, entry.docsWithFieldLength, entry.jumpTableEntryCount, entry.denseRankPower, entry.numDocsWithField);
        return new SortedNumericDocValues(this){
            boolean set;
            long start;
            long end;
            int count;

            @Override
            public int nextDoc() throws IOException {
                this.set = false;
                return disi.nextDoc();
            }

            @Override
            public int docID() {
                return disi.docID();
            }

            @Override
            public long cost() {
                return disi.cost();
            }

            @Override
            public int advance(int target) throws IOException {
                this.set = false;
                return disi.advance(target);
            }

            @Override
            public boolean advanceExact(int target) throws IOException {
                this.set = false;
                return disi.advanceExact(target);
            }

            @Override
            public long nextValue() throws IOException {
                this.set();
                return values.get(this.start++);
            }

            @Override
            public int docValueCount() {
                this.set();
                return this.count;
            }

            @Override
            public void intoBitSet(int upTo, FixedBitSet bitSet, int offset) throws IOException {
                this.set = false;
                disi.intoBitSet(upTo, bitSet, offset);
            }

            private void set() {
                if (!this.set) {
                    int index = disi.index();
                    this.start = addresses.get(index);
                    this.end = addresses.get((long)index + 1L);
                    this.count = (int)(this.end - this.start);
                    this.set = true;
                }
            }

            @Override
            public int docIDRunEnd() throws IOException {
                return disi.docIDRunEnd();
            }
        };
    }

    @Override
    public SortedSetDocValues getSortedSet(FieldInfo field) throws IOException {
        SortedSetEntry entry = this.sortedSets.get(field.number);
        if (entry.singleValueEntry != null) {
            return DocValues.singleton(this.getSorted(entry.singleValueEntry));
        }
        SortedNumericEntry ordsEntry = entry.ordsEntry;
        if (ordsEntry.blockShift < 0 && ordsEntry.bitsPerValue > 0) {
            if (ordsEntry.gcd != 1L || ordsEntry.minValue != 0L || ordsEntry.table != null) {
                throw new IllegalStateException("Ordinals shouldn't use GCD, offset or table compression");
            }
            RandomAccessInput addressesInput = this.data.randomAccessSlice(ordsEntry.addressesOffset, ordsEntry.addressesLength);
            if (addressesInput.length() > 0L) {
                addressesInput.prefetch(0L, 1L);
            }
            final DirectMonotonicReader addresses = DirectMonotonicReader.getInstance(ordsEntry.addressesMeta, addressesInput);
            RandomAccessInput slice = this.data.randomAccessSlice(ordsEntry.valuesOffset, ordsEntry.valuesLength);
            if (slice.length() > 0L) {
                slice.prefetch(0L, 1L);
            }
            final LongValues values = DirectReader.getInstance(slice, ordsEntry.bitsPerValue);
            if (ordsEntry.docsWithFieldOffset == -1L) {
                return new BaseSortedSetDocValues(entry, this.data){
                    private final int maxDoc;
                    private int doc;
                    private long curr;
                    private int count;
                    {
                        super(entry, data);
                        this.maxDoc = Lucene90DocValuesProducer.this.maxDoc;
                        this.doc = -1;
                    }

                    @Override
                    public long nextOrd() throws IOException {
                        return values.get(this.curr++);
                    }

                    @Override
                    public boolean advanceExact(int target) throws IOException {
                        this.curr = addresses.get(target);
                        long end = addresses.get((long)target + 1L);
                        this.count = (int)(end - this.curr);
                        this.doc = target;
                        return true;
                    }

                    @Override
                    public int docValueCount() {
                        return this.count;
                    }

                    @Override
                    public int docID() {
                        return this.doc;
                    }

                    @Override
                    public int nextDoc() throws IOException {
                        return this.advance(this.doc + 1);
                    }

                    @Override
                    public int advance(int target) throws IOException {
                        if (target >= this.maxDoc) {
                            this.doc = Integer.MAX_VALUE;
                            return Integer.MAX_VALUE;
                        }
                        this.curr = addresses.get(target);
                        long end = addresses.get((long)target + 1L);
                        this.count = (int)(end - this.curr);
                        this.doc = target;
                        return this.doc;
                    }

                    @Override
                    public long cost() {
                        return this.maxDoc;
                    }

                    @Override
                    public int docIDRunEnd() throws IOException {
                        return this.maxDoc;
                    }
                };
            }
            if (ordsEntry.docsWithFieldOffset >= 0L) {
                final IndexedDISI disi = new IndexedDISI(this.data, ordsEntry.docsWithFieldOffset, ordsEntry.docsWithFieldLength, ordsEntry.jumpTableEntryCount, ordsEntry.denseRankPower, ordsEntry.numValues);
                return new BaseSortedSetDocValues(this, entry, this.data){
                    boolean set;
                    long curr;
                    int count;

                    @Override
                    public long nextOrd() throws IOException {
                        this.set();
                        return values.get(this.curr++);
                    }

                    @Override
                    public boolean advanceExact(int target) throws IOException {
                        this.set = false;
                        return disi.advanceExact(target);
                    }

                    @Override
                    public int docValueCount() {
                        this.set();
                        return this.count;
                    }

                    @Override
                    public int docID() {
                        return disi.docID();
                    }

                    @Override
                    public int nextDoc() throws IOException {
                        this.set = false;
                        return disi.nextDoc();
                    }

                    @Override
                    public int advance(int target) throws IOException {
                        this.set = false;
                        return disi.advance(target);
                    }

                    @Override
                    public void intoBitSet(int upTo, FixedBitSet bitSet, int offset) throws IOException {
                        this.set = false;
                        disi.intoBitSet(upTo, bitSet, offset);
                    }

                    @Override
                    public long cost() {
                        return disi.cost();
                    }

                    private void set() {
                        if (!this.set) {
                            int index = disi.index();
                            this.curr = addresses.get(index);
                            long end = addresses.get((long)index + 1L);
                            this.count = (int)(end - this.curr);
                            this.set = true;
                        }
                    }

                    @Override
                    public int docIDRunEnd() throws IOException {
                        return disi.docIDRunEnd();
                    }
                };
            }
        }
        final SortedNumericDocValues ords = this.getSortedNumeric(ordsEntry);
        return new BaseSortedSetDocValues(this, entry, this.data){

            @Override
            public long nextOrd() throws IOException {
                return ords.nextValue();
            }

            @Override
            public int docValueCount() {
                return ords.docValueCount();
            }

            @Override
            public boolean advanceExact(int target) throws IOException {
                return ords.advanceExact(target);
            }

            @Override
            public int docID() {
                return ords.docID();
            }

            @Override
            public int nextDoc() throws IOException {
                return ords.nextDoc();
            }

            @Override
            public int advance(int target) throws IOException {
                return ords.advance(target);
            }

            @Override
            public long cost() {
                return ords.cost();
            }

            @Override
            public int docIDRunEnd() throws IOException {
                return ords.docIDRunEnd();
            }
        };
    }

    @Override
    public void checkIntegrity() throws IOException {
        CodecUtil.checksumEntireFile(this.data);
    }

    @Override
    public DocValuesSkipper getSkipper(FieldInfo field) throws IOException {
        final DocValuesSkipperEntry entry = this.skippers.get(field.number);
        final IndexInput input = this.data.slice("doc value skipper", entry.offset, entry.length);
        if (input.length() > 0L) {
            input.prefetch(0L, 1L);
        }
        return new DocValuesSkipper(this){
            final int[] minDocID = new int[4];
            final int[] maxDocID = new int[4];
            final long[] minValue;
            final long[] maxValue;
            final int[] docCount;
            int levels;
            {
                for (int i = 0; i < 4; ++i) {
                    this.maxDocID[i] = -1;
                    this.minDocID[i] = -1;
                }
                this.minValue = new long[4];
                this.maxValue = new long[4];
                this.docCount = new int[4];
                this.levels = 1;
            }

            @Override
            public void advance(int target) throws IOException {
                if (target > entry.maxDocId) {
                    for (int i = 0; i < 4; ++i) {
                        this.maxDocID[i] = Integer.MAX_VALUE;
                        this.minDocID[i] = Integer.MAX_VALUE;
                    }
                } else {
                    boolean valid;
                    assert (target > this.maxDocID[0]) : "target must be bigger that current interval";
                    block1: do {
                        this.levels = input.readByte();
                        assert (this.levels <= 4 && this.levels > 0) : "level out of range [" + this.levels + "]";
                        valid = true;
                        for (int level = this.levels - 1; level >= 0; --level) {
                            this.maxDocID[level] = input.readInt();
                            if (this.maxDocID[level] < target) {
                                input.skipBytes(Lucene90DocValuesFormat.SKIP_INDEX_JUMP_LENGTH_PER_LEVEL[level]);
                                valid = false;
                                continue block1;
                            }
                            this.minDocID[level] = input.readInt();
                            this.maxValue[level] = input.readLong();
                            this.minValue[level] = input.readLong();
                            this.docCount[level] = input.readInt();
                        }
                    } while (!valid);
                    while (this.levels < 4 && this.maxDocID[this.levels] >= target) {
                        ++this.levels;
                    }
                }
            }

            @Override
            public int numLevels() {
                return this.levels;
            }

            @Override
            public int minDocID(int level) {
                return this.minDocID[level];
            }

            @Override
            public int maxDocID(int level) {
                return this.maxDocID[level];
            }

            @Override
            public long minValue(int level) {
                return this.minValue[level];
            }

            @Override
            public long maxValue(int level) {
                return this.maxValue[level];
            }

            @Override
            public int docCount(int level) {
                return this.docCount[level];
            }

            @Override
            public long minValue() {
                return entry.minValue;
            }

            @Override
            public long maxValue() {
                return entry.maxValue;
            }

            @Override
            public int docCount() {
                return entry.docCount;
            }
        };
    }

    private record DocValuesSkipperEntry(long offset, long length, long minValue, long maxValue, int docCount, int maxDocId) {
    }

    private static class NumericEntry {
        long[] table;
        int blockShift;
        byte bitsPerValue;
        long docsWithFieldOffset;
        long docsWithFieldLength;
        short jumpTableEntryCount;
        byte denseRankPower;
        long numValues;
        long minValue;
        long gcd;
        long valuesOffset;
        long valuesLength;
        long valueJumpTableOffset;

        private NumericEntry() {
        }
    }

    private static class BinaryEntry {
        long dataOffset;
        long dataLength;
        long docsWithFieldOffset;
        long docsWithFieldLength;
        short jumpTableEntryCount;
        byte denseRankPower;
        int numDocsWithField;
        int minLength;
        int maxLength;
        long addressesOffset;
        long addressesLength;
        DirectMonotonicReader.Meta addressesMeta;

        private BinaryEntry() {
        }
    }

    private static class SortedEntry {
        NumericEntry ordsEntry;
        TermsDictEntry termsDictEntry;

        private SortedEntry() {
        }
    }

    private static class SortedSetEntry {
        SortedEntry singleValueEntry;
        SortedNumericEntry ordsEntry;
        TermsDictEntry termsDictEntry;

        private SortedSetEntry() {
        }
    }

    private static class SortedNumericEntry
    extends NumericEntry {
        int numDocsWithField;
        DirectMonotonicReader.Meta addressesMeta;
        long addressesOffset;
        long addressesLength;

        private SortedNumericEntry() {
        }
    }

    private static class TermsDictEntry {
        long termsDictSize;
        DirectMonotonicReader.Meta termsAddressesMeta;
        int maxTermLength;
        long termsDataOffset;
        long termsDataLength;
        long termsAddressesOffset;
        long termsAddressesLength;
        int termsDictIndexShift;
        DirectMonotonicReader.Meta termsIndexAddressesMeta;
        long termsIndexOffset;
        long termsIndexLength;
        long termsIndexAddressesOffset;
        long termsIndexAddressesLength;
        int maxBlockLength;

        private TermsDictEntry() {
        }
    }

    private class VaryingBPVReader {
        final RandomAccessInput slice;
        final RandomAccessInput rankSlice;
        final NumericEntry entry;
        final int shift;
        final long mul;
        final int mask;
        long block = -1L;
        long delta;
        long offset;
        long blockEndOffset;
        LongValues values;

        VaryingBPVReader(NumericEntry entry, RandomAccessInput slice) throws IOException {
            this.entry = entry;
            this.slice = slice;
            RandomAccessInput randomAccessInput = this.rankSlice = entry.valueJumpTableOffset == -1L ? null : Lucene90DocValuesProducer.this.data.randomAccessSlice(entry.valueJumpTableOffset, Lucene90DocValuesProducer.this.data.length() - entry.valueJumpTableOffset);
            if (this.rankSlice != null && this.rankSlice.length() > 0L) {
                this.rankSlice.prefetch(0L, 1L);
            }
            this.shift = entry.blockShift;
            this.mul = entry.gcd;
            this.mask = (1 << this.shift) - 1;
        }

        long getLongValue(long index) throws IOException {
            long block = index >>> this.shift;
            if (this.block != block) {
                byte bitsPerValue;
                do {
                    if (this.rankSlice != null && block != this.block + 1L) {
                        this.blockEndOffset = this.rankSlice.readLong(block * 8L) - this.entry.valuesOffset;
                        this.block = block - 1L;
                    }
                    this.offset = this.blockEndOffset;
                    bitsPerValue = this.slice.readByte(this.offset++);
                    this.delta = this.slice.readLong(this.offset);
                    this.offset += 8L;
                    if (bitsPerValue == 0) {
                        this.blockEndOffset = this.offset;
                    } else {
                        int length = this.slice.readInt(this.offset);
                        this.offset += 4L;
                        this.blockEndOffset = this.offset + (long)length;
                    }
                    ++this.block;
                } while (this.block != block);
                int numValues = Math.toIntExact(Math.min((long)(1 << this.shift), this.entry.numValues - (block << this.shift)));
                this.values = bitsPerValue == 0 ? LongValues.ZEROES : Lucene90DocValuesProducer.this.getDirectReaderInstance(this.slice, bitsPerValue, this.offset, numValues);
            }
            return this.mul * this.values.get(index & (long)this.mask) + this.delta;
        }
    }

    private class TermsDict
    extends BaseTermsEnum {
        static final int LZ4_DECOMPRESSOR_PADDING = 7;
        final TermsDictEntry entry;
        final LongValues blockAddresses;
        final IndexInput bytes;
        final long blockMask;
        final LongValues indexAddresses;
        final RandomAccessInput indexBytes;
        final BytesRef term;
        final BytesRef blockBuffer;
        final ByteArrayDataInput blockInput;
        long ord = -1L;
        long currentCompressedBlockStart = -1L;
        long currentCompressedBlockEnd = -1L;

        TermsDict(Lucene90DocValuesProducer lucene90DocValuesProducer, TermsDictEntry entry, IndexInput data) throws IOException {
            this.entry = entry;
            RandomAccessInput addressesSlice = data.randomAccessSlice(entry.termsAddressesOffset, entry.termsAddressesLength);
            this.blockAddresses = DirectMonotonicReader.getInstance(entry.termsAddressesMeta, addressesSlice, lucene90DocValuesProducer.merging);
            this.bytes = data.slice("terms", entry.termsDataOffset, entry.termsDataLength);
            this.blockMask = 63L;
            RandomAccessInput indexAddressesSlice = data.randomAccessSlice(entry.termsIndexAddressesOffset, entry.termsIndexAddressesLength);
            this.indexAddresses = DirectMonotonicReader.getInstance(entry.termsIndexAddressesMeta, indexAddressesSlice, lucene90DocValuesProducer.merging);
            this.indexBytes = data.randomAccessSlice(entry.termsIndexOffset, entry.termsIndexLength);
            this.term = new BytesRef(entry.maxTermLength);
            int bufferSize = entry.maxBlockLength + entry.maxTermLength + 7;
            this.blockBuffer = new BytesRef(new byte[bufferSize], 0, bufferSize);
            this.blockInput = new ByteArrayDataInput();
        }

        @Override
        public BytesRef next() throws IOException {
            if (++this.ord >= this.entry.termsDictSize) {
                return null;
            }
            if ((this.ord & this.blockMask) == 0L) {
                this.decompressBlock();
            } else {
                ByteArrayDataInput input = this.blockInput;
                int token = Byte.toUnsignedInt(((DataInput)input).readByte());
                int prefixLength = token & 0xF;
                int suffixLength = 1 + (token >>> 4);
                if (prefixLength == 15) {
                    prefixLength += ((DataInput)input).readVInt();
                }
                if (suffixLength == 16) {
                    suffixLength += ((DataInput)input).readVInt();
                }
                this.term.length = prefixLength + suffixLength;
                ((DataInput)input).readBytes(this.term.bytes, prefixLength, suffixLength);
            }
            return this.term;
        }

        @Override
        public void seekExact(long ord) throws IOException {
            if (ord < 0L || ord >= this.entry.termsDictSize) {
                throw new IndexOutOfBoundsException();
            }
            long currentBlockIndex = this.ord >> 6;
            long blockIndex = ord >> 6;
            if (ord < this.ord || blockIndex != currentBlockIndex) {
                long blockAddress = this.blockAddresses.get(blockIndex);
                this.bytes.seek(blockAddress);
                this.ord = (blockIndex << 6) - 1L;
            }
            while (this.ord < ord) {
                this.next();
            }
        }

        private BytesRef getTermFromIndex(long index) throws IOException {
            assert (index >= 0L && index <= this.entry.termsDictSize - 1L >>> this.entry.termsDictIndexShift);
            long start = this.indexAddresses.get(index);
            this.term.length = (int)(this.indexAddresses.get(index + 1L) - start);
            this.indexBytes.readBytes(start, this.term.bytes, 0, this.term.length);
            return this.term;
        }

        private long seekTermsIndex(BytesRef text) throws IOException {
            long lo = 0L;
            long hi = this.entry.termsDictSize - 1L >> this.entry.termsDictIndexShift;
            while (lo <= hi) {
                long mid = lo + hi >>> 1;
                this.getTermFromIndex(mid);
                int cmp = this.term.compareTo(text);
                if (cmp <= 0) {
                    lo = mid + 1L;
                    continue;
                }
                hi = mid - 1L;
            }
            assert (hi < 0L || this.getTermFromIndex(hi).compareTo(text) <= 0);
            assert (hi == this.entry.termsDictSize - 1L >> this.entry.termsDictIndexShift || this.getTermFromIndex(hi + 1L).compareTo(text) > 0);
            assert (hi < 0L ^ this.entry.termsDictSize > 0L);
            return hi;
        }

        private BytesRef getFirstTermFromBlock(long block) throws IOException {
            assert (block >= 0L && block <= this.entry.termsDictSize - 1L >>> 6);
            long blockAddress = this.blockAddresses.get(block);
            this.bytes.seek(blockAddress);
            this.term.length = this.bytes.readVInt();
            this.bytes.readBytes(this.term.bytes, 0, this.term.length);
            return this.term;
        }

        private long seekBlock(BytesRef text) throws IOException {
            long index = this.seekTermsIndex(text);
            if (index == -1L) {
                this.ord = 0L;
                return -2L;
            }
            long ordLo = index << this.entry.termsDictIndexShift;
            long ordHi = Math.min(this.entry.termsDictSize, ordLo + (1L << this.entry.termsDictIndexShift)) - 1L;
            long blockLo = ordLo >>> 6;
            long blockHi = ordHi >>> 6;
            while (blockLo <= blockHi) {
                long blockMid = blockLo + blockHi >>> 1;
                this.getFirstTermFromBlock(blockMid);
                int cmp = this.term.compareTo(text);
                if (cmp <= 0) {
                    blockLo = blockMid + 1L;
                    continue;
                }
                blockHi = blockMid - 1L;
            }
            assert (blockHi < 0L || this.getFirstTermFromBlock(blockHi).compareTo(text) <= 0);
            assert (blockHi == this.entry.termsDictSize - 1L >>> 6 || this.getFirstTermFromBlock(blockHi + 1L).compareTo(text) > 0);
            assert (this.entry.termsDictSize > 0L);
            long block = Math.max(blockHi, 0L);
            long blockAddress = this.blockAddresses.get(block);
            this.ord = block << 6;
            this.bytes.seek(blockAddress);
            this.decompressBlock();
            return blockHi;
        }

        @Override
        public TermsEnum.SeekStatus seekCeil(BytesRef text) throws IOException {
            long block = this.seekBlock(text);
            if (block == -2L) {
                assert (this.entry.termsDictSize == 0L);
                return TermsEnum.SeekStatus.END;
            }
            if (block == -1L) {
                return TermsEnum.SeekStatus.NOT_FOUND;
            }
            do {
                int cmp;
                if ((cmp = this.term.compareTo(text)) == 0) {
                    return TermsEnum.SeekStatus.FOUND;
                }
                if (cmp <= 0) continue;
                return TermsEnum.SeekStatus.NOT_FOUND;
            } while (this.next() != null);
            return TermsEnum.SeekStatus.END;
        }

        private void decompressBlock() throws IOException {
            this.term.length = this.bytes.readVInt();
            this.bytes.readBytes(this.term.bytes, 0, this.term.length);
            long offset = this.bytes.getFilePointer();
            if (offset < this.entry.termsDataLength - 1L) {
                if (this.currentCompressedBlockStart != offset) {
                    this.blockBuffer.offset = this.term.length;
                    this.blockBuffer.length = this.bytes.readVInt();
                    System.arraycopy(this.term.bytes, 0, this.blockBuffer.bytes, 0, this.blockBuffer.offset);
                    LZ4.decompress(this.bytes, this.blockBuffer.length, this.blockBuffer.bytes, this.blockBuffer.offset);
                    this.currentCompressedBlockStart = offset;
                    this.currentCompressedBlockEnd = this.bytes.getFilePointer();
                } else {
                    this.bytes.seek(this.currentCompressedBlockEnd);
                }
                this.blockInput.reset(this.blockBuffer.bytes, this.blockBuffer.offset, this.blockBuffer.length);
            }
        }

        @Override
        public BytesRef term() throws IOException {
            return this.term;
        }

        @Override
        public long ord() throws IOException {
            return this.ord;
        }

        @Override
        public long totalTermFreq() throws IOException {
            return -1L;
        }

        @Override
        public PostingsEnum postings(PostingsEnum reuse, int flags) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public ImpactsEnum impacts(int flags) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int docFreq() throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    private abstract class BaseSortedSetDocValues
    extends SortedSetDocValues {
        final SortedSetEntry entry;
        final IndexInput data;
        final TermsEnum termsEnum;

        BaseSortedSetDocValues(SortedSetEntry entry, IndexInput data) throws IOException {
            this.entry = entry;
            this.data = data;
            this.termsEnum = this.termsEnum();
        }

        @Override
        public long getValueCount() {
            return this.entry.termsDictEntry.termsDictSize;
        }

        @Override
        public BytesRef lookupOrd(long ord) throws IOException {
            this.termsEnum.seekExact(ord);
            return this.termsEnum.term();
        }

        @Override
        public long lookupTerm(BytesRef key) throws IOException {
            TermsEnum.SeekStatus status = this.termsEnum.seekCeil(key);
            switch (status) {
                case FOUND: {
                    return this.termsEnum.ord();
                }
            }
            return -1L - this.termsEnum.ord();
        }

        @Override
        public TermsEnum termsEnum() throws IOException {
            return new TermsDict(Lucene90DocValuesProducer.this, this.entry.termsDictEntry, this.data);
        }
    }

    private abstract class BaseSortedDocValues
    extends SortedDocValues {
        final SortedEntry entry;
        final TermsEnum termsEnum;

        BaseSortedDocValues(SortedEntry entry) throws IOException {
            this.entry = entry;
            this.termsEnum = this.termsEnum();
        }

        @Override
        public int getValueCount() {
            return Math.toIntExact(this.entry.termsDictEntry.termsDictSize);
        }

        @Override
        public BytesRef lookupOrd(int ord) throws IOException {
            this.termsEnum.seekExact(ord);
            return this.termsEnum.term();
        }

        @Override
        public int lookupTerm(BytesRef key) throws IOException {
            TermsEnum.SeekStatus status = this.termsEnum.seekCeil(key);
            switch (status) {
                case FOUND: {
                    return Math.toIntExact(this.termsEnum.ord());
                }
            }
            return Math.toIntExact(-1L - this.termsEnum.ord());
        }

        @Override
        public TermsEnum termsEnum() throws IOException {
            return new TermsDict(Lucene90DocValuesProducer.this, this.entry.termsDictEntry, Lucene90DocValuesProducer.this.data);
        }
    }

    private static abstract class SparseBinaryDocValues
    extends BinaryDocValues {
        final IndexedDISI disi;

        SparseBinaryDocValues(IndexedDISI disi) {
            this.disi = disi;
        }

        @Override
        public int nextDoc() throws IOException {
            return this.disi.nextDoc();
        }

        @Override
        public int docID() {
            return this.disi.docID();
        }

        @Override
        public long cost() {
            return this.disi.cost();
        }

        @Override
        public int advance(int target) throws IOException {
            return this.disi.advance(target);
        }

        @Override
        public boolean advanceExact(int target) throws IOException {
            return this.disi.advanceExact(target);
        }

        @Override
        public void intoBitSet(int upTo, FixedBitSet bitSet, int offset) throws IOException {
            this.disi.intoBitSet(upTo, bitSet, offset);
        }

        @Override
        public int docIDRunEnd() throws IOException {
            return this.disi.docIDRunEnd();
        }
    }

    private static abstract class DenseBinaryDocValues
    extends BinaryDocValues {
        final int maxDoc;
        int doc = -1;

        DenseBinaryDocValues(int maxDoc) {
            this.maxDoc = maxDoc;
        }

        @Override
        public int nextDoc() throws IOException {
            return this.advance(this.doc + 1);
        }

        @Override
        public int docID() {
            return this.doc;
        }

        @Override
        public long cost() {
            return this.maxDoc;
        }

        @Override
        public int advance(int target) throws IOException {
            if (target >= this.maxDoc) {
                this.doc = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }
            this.doc = target;
            return this.doc;
        }

        @Override
        public boolean advanceExact(int target) throws IOException {
            this.doc = target;
            return true;
        }

        @Override
        public int docIDRunEnd() throws IOException {
            return this.maxDoc;
        }
    }

    private static abstract class SparseNumericDocValues
    extends NumericDocValues {
        final IndexedDISI disi;

        SparseNumericDocValues(IndexedDISI disi) {
            this.disi = disi;
        }

        @Override
        public int advance(int target) throws IOException {
            return this.disi.advance(target);
        }

        @Override
        public boolean advanceExact(int target) throws IOException {
            return this.disi.advanceExact(target);
        }

        @Override
        public int nextDoc() throws IOException {
            return this.disi.nextDoc();
        }

        @Override
        public int docID() {
            return this.disi.docID();
        }

        @Override
        public void intoBitSet(int upTo, FixedBitSet bitSet, int offset) throws IOException {
            this.disi.intoBitSet(upTo, bitSet, offset);
        }

        @Override
        public long cost() {
            return this.disi.cost();
        }

        @Override
        public int docIDRunEnd() throws IOException {
            return this.disi.docIDRunEnd();
        }
    }

    private static abstract class DenseNumericDocValues
    extends NumericDocValues {
        final int maxDoc;
        int doc = -1;

        DenseNumericDocValues(int maxDoc) {
            this.maxDoc = maxDoc;
        }

        @Override
        public int docID() {
            return this.doc;
        }

        @Override
        public int nextDoc() throws IOException {
            return this.advance(this.doc + 1);
        }

        @Override
        public int advance(int target) throws IOException {
            if (target >= this.maxDoc) {
                this.doc = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }
            this.doc = target;
            return this.doc;
        }

        @Override
        public boolean advanceExact(int target) {
            this.doc = target;
            return true;
        }

        @Override
        public long cost() {
            return this.maxDoc;
        }

        @Override
        public int docIDRunEnd() throws IOException {
            return this.maxDoc;
        }
    }
}

