/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdfs.engine;

import java.util.stream.Stream;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdfs.engine.Match;
import org.apache.jena.rdfs.engine.MatchAdapter;
import org.apache.jena.sparql.graph.GraphWrapper;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.WrappedIterator;

public class GraphMatch
extends GraphWrapper {
    private final Match<Node, Triple> source;

    public GraphMatch(Graph graph, Match<Node, Triple> match) {
        super(graph);
        this.source = match;
    }

    public static <X, T> Graph adapt(Graph baseGraph, Match<X, T> match) {
        return new GraphMatch(baseGraph, new MatchAdapter<X, T>(match, match.getMapper()));
    }

    public Match<Node, Triple> getMatch() {
        return this.source;
    }

    @Override
    public ExtendedIterator<Triple> find(Triple m) {
        return this.find(m.getSubject(), m.getPredicate(), m.getObject());
    }

    @Override
    public ExtendedIterator<Triple> find(Node s, Node p, Node o) {
        Stream<Triple> stream = this.source.match(s, p, o);
        WrappedIterator iter = WrappedIterator.ofStream(stream);
        return iter;
    }

    public Stream<Triple> stream(Node s, Node p, Node o) {
        return this.source.match(s, p, o);
    }

    @Override
    public boolean contains(Node s, Node p, Node o) {
        return this.source.contains(s, p, o);
    }

    @Override
    public boolean contains(Triple t) {
        return this.contains(t.getSubject(), t.getPredicate(), t.getObject());
    }

    @Override
    public int size() {
        return super.size();
    }
}

