/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.dht;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.apache.cassandra.dht.BootstrapEvent;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.diag.DiagnosticEventService;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.locator.TokenMetadata;

final class BootstrapDiagnostics {
    private static final DiagnosticEventService service = DiagnosticEventService.instance();

    private BootstrapDiagnostics() {
    }

    static void useSpecifiedTokens(InetAddressAndPort address, String allocationKeyspace, Collection<Token> initialTokens, int numTokens) {
        if (BootstrapDiagnostics.isEnabled(BootstrapEvent.BootstrapEventType.BOOTSTRAP_USING_SPECIFIED_TOKENS)) {
            service.publish(new BootstrapEvent(BootstrapEvent.BootstrapEventType.BOOTSTRAP_USING_SPECIFIED_TOKENS, address, null, allocationKeyspace, null, numTokens, (ImmutableCollection<Token>)ImmutableList.copyOf(initialTokens)));
        }
    }

    static void useRandomTokens(InetAddressAndPort address, TokenMetadata metadata, int numTokens, Collection<Token> tokens) {
        if (BootstrapDiagnostics.isEnabled(BootstrapEvent.BootstrapEventType.BOOTSTRAP_USING_RANDOM_TOKENS)) {
            service.publish(new BootstrapEvent(BootstrapEvent.BootstrapEventType.BOOTSTRAP_USING_RANDOM_TOKENS, address, metadata.cloneOnlyTokenMap(), null, null, numTokens, (ImmutableCollection<Token>)ImmutableList.copyOf(tokens)));
        }
    }

    static void tokensAllocated(InetAddressAndPort address, TokenMetadata metadata, String allocationKeyspace, int numTokens, Collection<Token> tokens) {
        if (BootstrapDiagnostics.isEnabled(BootstrapEvent.BootstrapEventType.TOKENS_ALLOCATED)) {
            service.publish(new BootstrapEvent(BootstrapEvent.BootstrapEventType.TOKENS_ALLOCATED, address, metadata.cloneOnlyTokenMap(), allocationKeyspace, null, numTokens, (ImmutableCollection<Token>)ImmutableList.copyOf(tokens)));
        }
    }

    static void tokensAllocated(InetAddressAndPort address, TokenMetadata metadata, int rf, int numTokens, Collection<Token> tokens) {
        if (BootstrapDiagnostics.isEnabled(BootstrapEvent.BootstrapEventType.TOKENS_ALLOCATED)) {
            service.publish(new BootstrapEvent(BootstrapEvent.BootstrapEventType.TOKENS_ALLOCATED, address, metadata.cloneOnlyTokenMap(), null, rf, numTokens, (ImmutableCollection<Token>)ImmutableList.copyOf(tokens)));
        }
    }

    private static boolean isEnabled(BootstrapEvent.BootstrapEventType type) {
        return service.isEnabled(BootstrapEvent.class, type);
    }
}

