/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.streaming;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.db.streaming.ComponentManifest;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentContext
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(ComponentContext.class);
    private static final Set<Component> MUTABLE_COMPONENTS = ImmutableSet.of((Object)Component.STATS, (Object)Component.SUMMARY);
    private final Map<Component, File> hardLinks;
    private final ComponentManifest manifest;

    private ComponentContext(Map<Component, File> hardLinks, ComponentManifest manifest) {
        this.hardLinks = hardLinks;
        this.manifest = manifest;
    }

    public static ComponentContext create(Descriptor descriptor) {
        HashMap<Component, File> hardLinks = new HashMap<Component, File>(1);
        for (Component component : MUTABLE_COMPONENTS) {
            File file = new File(descriptor.filenameFor(component));
            if (!file.exists()) continue;
            File hardlink = new File(descriptor.tmpFilenameForStreaming(component));
            FileUtils.createHardLink(file, hardlink);
            hardLinks.put(component, hardlink);
        }
        return new ComponentContext(hardLinks, ComponentManifest.create(descriptor));
    }

    public ComponentManifest manifest() {
        return this.manifest;
    }

    public FileChannel channel(Descriptor descriptor, Component component, long size) throws IOException {
        String toTransfer = this.hardLinks.containsKey(component) ? this.hardLinks.get(component).getPath() : descriptor.filenameFor(component);
        FileChannel channel = new RandomAccessFile(toTransfer, "r").getChannel();
        assert (size == channel.size()) : String.format("Entire sstable streaming expects %s file size to be %s but got %s.", component, size, channel.size());
        return channel;
    }

    @Override
    public void close() {
        Throwable accumulate = null;
        for (File file : this.hardLinks.values()) {
            accumulate = FileUtils.deleteWithConfirm(file, accumulate);
        }
        this.hardLinks.clear();
        if (accumulate != null) {
            logger.warn("Failed to remove hard link files", accumulate);
        }
    }
}

