/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import org.apache.cassandra.db.DataRange;
import org.apache.cassandra.db.PartitionRangeReadQuery;
import org.apache.cassandra.db.VirtualTableReadQuery;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.filter.DataLimits;
import org.apache.cassandra.db.filter.RowFilter;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterator;
import org.apache.cassandra.db.virtual.VirtualKeyspaceRegistry;
import org.apache.cassandra.db.virtual.VirtualTable;
import org.apache.cassandra.schema.TableMetadata;

public class VirtualTablePartitionRangeReadQuery
extends VirtualTableReadQuery
implements PartitionRangeReadQuery {
    private final DataRange dataRange;

    public static VirtualTablePartitionRangeReadQuery create(TableMetadata metadata, int nowInSec, ColumnFilter columnFilter, RowFilter rowFilter, DataLimits limits, DataRange dataRange) {
        return new VirtualTablePartitionRangeReadQuery(metadata, nowInSec, columnFilter, rowFilter, limits, dataRange);
    }

    private VirtualTablePartitionRangeReadQuery(TableMetadata metadata, int nowInSec, ColumnFilter columnFilter, RowFilter rowFilter, DataLimits limits, DataRange dataRange) {
        super(metadata, nowInSec, columnFilter, rowFilter, limits);
        this.dataRange = dataRange;
    }

    @Override
    public DataRange dataRange() {
        return this.dataRange;
    }

    @Override
    public PartitionRangeReadQuery withUpdatedLimit(DataLimits newLimits) {
        return new VirtualTablePartitionRangeReadQuery(this.metadata(), this.nowInSec(), this.columnFilter(), this.rowFilter(), newLimits, this.dataRange());
    }

    @Override
    public PartitionRangeReadQuery withUpdatedLimitsAndDataRange(DataLimits newLimits, DataRange newDataRange) {
        return new VirtualTablePartitionRangeReadQuery(this.metadata(), this.nowInSec(), this.columnFilter(), this.rowFilter(), newLimits, newDataRange);
    }

    @Override
    protected UnfilteredPartitionIterator queryVirtualTable() {
        VirtualTable view = VirtualKeyspaceRegistry.instance.getTableNullable(this.metadata().id);
        return view.select(this.dataRange, this.columnFilter());
    }

    @Override
    protected void appendCQLWhereClause(StringBuilder sb) {
        if (this.dataRange.isUnrestricted() && this.rowFilter().isEmpty()) {
            return;
        }
        sb.append(" WHERE ");
        if (!this.rowFilter().isEmpty()) {
            sb.append(this.rowFilter());
            if (!this.dataRange.isUnrestricted()) {
                sb.append(" AND ");
            }
        }
        if (!this.dataRange.isUnrestricted()) {
            sb.append(this.dataRange.toCQLString(this.metadata()));
        }
    }
}

