/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.execsqlrow;

import org.apache.hop.core.Const;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transforms.execsqlrow.ExecSqlRowMeta;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.widget.MetaSelectionLine;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ExecSqlRowDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static final Class<?> PKG = ExecSqlRowMeta.class;
    private boolean gotPreviousFields = false;
    private MetaSelectionLine<DatabaseMeta> wConnection;
    private Text wInsertField;
    private Text wUpdateField;
    private Text wDeleteField;
    private Text wReadField;
    private CCombo wSqlFieldName;
    private Text wCommit;
    private final ExecSqlRowMeta input;
    private Button wSqlFromFile;
    private Button wSendOneStatement;

    public ExecSqlRowDialog(Shell parent, IVariables variables, Object in, PipelineMeta pipelineMeta, String sname) {
        super(parent, variables, (BaseTransformMeta)in, pipelineMeta, sname);
        this.input = (ExecSqlRowMeta)((Object)in);
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        ModifyListener lsMod = e -> this.input.setChanged();
        SelectionAdapter lsSelection = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExecSqlRowDialog.this.input.setChanged();
            }
        };
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"ExecSqlRowDialog.Shell.Label", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        ExecSqlRowDialog execSqlRowDialog = this;
        int margin = execSqlRowDialog.props.getMargin();
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"ExecSqlRowDialog.TransformName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        DatabaseMeta databaseMeta = this.pipelineMeta.findDatabase(this.input.getConnection(), this.variables);
        this.wConnection = this.addConnectionLine((Composite)this.shell, (Control)this.wTransformName, databaseMeta, lsMod);
        this.wConnection.addSelectionListener((SelectionListener)lsSelection);
        Label wlCommit = new Label((Composite)this.shell, 131072);
        wlCommit.setText(BaseMessages.getString(PKG, (String)"ExecSqlRowDialog.Commit.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlCommit);
        FormData fdlCommit = new FormData();
        fdlCommit.left = new FormAttachment(0, 0);
        fdlCommit.top = new FormAttachment(this.wConnection, margin);
        fdlCommit.right = new FormAttachment(middle, -margin);
        wlCommit.setLayoutData((Object)fdlCommit);
        this.wCommit = new Text((Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wCommit);
        this.wCommit.addModifyListener(lsMod);
        FormData fdCommit = new FormData();
        fdCommit.left = new FormAttachment(middle, 0);
        fdCommit.top = new FormAttachment(this.wConnection, margin);
        fdCommit.right = new FormAttachment(100, 0);
        this.wCommit.setLayoutData((Object)fdCommit);
        Label wlSendOneStatement = new Label((Composite)this.shell, 131072);
        wlSendOneStatement.setText(BaseMessages.getString(PKG, (String)"ExecSqlRowDialog.SendOneStatement.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlSendOneStatement);
        FormData fdlSendOneStatement = new FormData();
        fdlSendOneStatement.left = new FormAttachment(0, 0);
        fdlSendOneStatement.top = new FormAttachment((Control)this.wCommit, margin);
        fdlSendOneStatement.right = new FormAttachment(middle, -margin);
        wlSendOneStatement.setLayoutData((Object)fdlSendOneStatement);
        this.wSendOneStatement = new Button((Composite)this.shell, 32);
        this.wSendOneStatement.setToolTipText(BaseMessages.getString(PKG, (String)"ExecSqlRowDialog.SendOneStatement.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wSendOneStatement);
        FormData fdSendOneStatement = new FormData();
        fdSendOneStatement.left = new FormAttachment(middle, 0);
        fdSendOneStatement.top = new FormAttachment((Control)wlSendOneStatement, 0, 0x1000000);
        fdSendOneStatement.right = new FormAttachment(100, 0);
        this.wSendOneStatement.setLayoutData((Object)fdSendOneStatement);
        this.wSendOneStatement.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExecSqlRowDialog.this.input.setChanged();
            }
        });
        Label wlSqlFieldName = new Label((Composite)this.shell, 131072);
        wlSqlFieldName.setText(BaseMessages.getString(PKG, (String)"ExecSqlRowDialog.SQLFieldName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlSqlFieldName);
        FormData fdlSqlFieldName = new FormData();
        fdlSqlFieldName.left = new FormAttachment(0, 0);
        fdlSqlFieldName.right = new FormAttachment(middle, -margin);
        fdlSqlFieldName.top = new FormAttachment((Control)this.wSendOneStatement, 2 * margin);
        wlSqlFieldName.setLayoutData((Object)fdlSqlFieldName);
        this.wSqlFieldName = new CCombo((Composite)this.shell, 2056);
        this.wSqlFieldName.setEditable(true);
        PropsUi.setLook((Widget)this.wSqlFieldName);
        this.wSqlFieldName.addModifyListener(lsMod);
        FormData fdSqlFieldName = new FormData();
        fdSqlFieldName.left = new FormAttachment(middle, 0);
        fdSqlFieldName.top = new FormAttachment((Control)this.wSendOneStatement, 2 * margin);
        fdSqlFieldName.right = new FormAttachment(100, -margin);
        this.wSqlFieldName.setLayoutData((Object)fdSqlFieldName);
        this.wSqlFieldName.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                Cursor busy = new Cursor((Device)ExecSqlRowDialog.this.shell.getDisplay(), 1);
                ExecSqlRowDialog.this.shell.setCursor(busy);
                ExecSqlRowDialog.this.get();
                ExecSqlRowDialog.this.shell.setCursor(null);
                busy.dispose();
            }
        });
        Label wlSqlFromFile = new Label((Composite)this.shell, 131072);
        wlSqlFromFile.setText(BaseMessages.getString(PKG, (String)"ExecSqlRowDialog.SQLFromFile.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlSqlFromFile);
        FormData fdlSqlFromFile = new FormData();
        fdlSqlFromFile.left = new FormAttachment(0, 0);
        fdlSqlFromFile.top = new FormAttachment((Control)this.wSqlFieldName, margin);
        fdlSqlFromFile.right = new FormAttachment(middle, -margin);
        wlSqlFromFile.setLayoutData((Object)fdlSqlFromFile);
        this.wSqlFromFile = new Button((Composite)this.shell, 32);
        this.wSqlFromFile.setToolTipText(BaseMessages.getString(PKG, (String)"ExecSqlRowDialog.SQLFromFile.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wSqlFromFile);
        FormData fdSqlFromFile = new FormData();
        fdSqlFromFile.left = new FormAttachment(middle, 0);
        fdSqlFromFile.top = new FormAttachment((Control)wlSqlFromFile, 0, 0x1000000);
        fdSqlFromFile.right = new FormAttachment(100, 0);
        this.wSqlFromFile.setLayoutData((Object)fdSqlFromFile);
        this.wSqlFromFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExecSqlRowDialog.this.input.setChanged();
            }
        });
        Group wAdditionalFields = new Group((Composite)this.shell, 32);
        PropsUi.setLook((Widget)wAdditionalFields);
        wAdditionalFields.setText(BaseMessages.getString(PKG, (String)"ExecSqlRowDialog.wAdditionalFields.Label", (String[])new String[0]));
        FormLayout additionalFieldsgroupLayout = new FormLayout();
        additionalFieldsgroupLayout.marginWidth = 10;
        additionalFieldsgroupLayout.marginHeight = 10;
        wAdditionalFields.setLayout((Layout)additionalFieldsgroupLayout);
        Label wlInsertField = new Label((Composite)wAdditionalFields, 131072);
        wlInsertField.setText(BaseMessages.getString(PKG, (String)"ExecSqlRowDialog.InsertField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlInsertField);
        FormData fdlInsertField = new FormData();
        fdlInsertField.left = new FormAttachment(0, margin);
        fdlInsertField.right = new FormAttachment(middle, -margin);
        fdlInsertField.top = new FormAttachment((Control)this.wSqlFromFile, margin);
        wlInsertField.setLayoutData((Object)fdlInsertField);
        this.wInsertField = new Text((Composite)wAdditionalFields, 18436);
        PropsUi.setLook((Widget)this.wInsertField);
        this.wInsertField.addModifyListener(lsMod);
        FormData fdInsertField = new FormData();
        fdInsertField.left = new FormAttachment(middle, 0);
        fdInsertField.top = new FormAttachment((Control)this.wSqlFromFile, margin);
        fdInsertField.right = new FormAttachment(100, 0);
        this.wInsertField.setLayoutData((Object)fdInsertField);
        Label wlUpdateField = new Label((Composite)wAdditionalFields, 131072);
        wlUpdateField.setText(BaseMessages.getString(PKG, (String)"ExecSqlRowDialog.UpdateField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlUpdateField);
        FormData fdlUpdateField = new FormData();
        fdlUpdateField.left = new FormAttachment(0, margin);
        fdlUpdateField.right = new FormAttachment(middle, -margin);
        fdlUpdateField.top = new FormAttachment((Control)this.wInsertField, margin);
        wlUpdateField.setLayoutData((Object)fdlUpdateField);
        this.wUpdateField = new Text((Composite)wAdditionalFields, 18436);
        PropsUi.setLook((Widget)this.wUpdateField);
        this.wUpdateField.addModifyListener(lsMod);
        FormData fdUpdateField = new FormData();
        fdUpdateField.left = new FormAttachment(middle, 0);
        fdUpdateField.top = new FormAttachment((Control)this.wInsertField, margin);
        fdUpdateField.right = new FormAttachment(100, 0);
        this.wUpdateField.setLayoutData((Object)fdUpdateField);
        Label wlDeleteField = new Label((Composite)wAdditionalFields, 131072);
        wlDeleteField.setText(BaseMessages.getString(PKG, (String)"ExecSqlRowDialog.DeleteField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlDeleteField);
        FormData fdlDeleteField = new FormData();
        fdlDeleteField.left = new FormAttachment(0, margin);
        fdlDeleteField.right = new FormAttachment(middle, -margin);
        fdlDeleteField.top = new FormAttachment((Control)this.wUpdateField, margin);
        wlDeleteField.setLayoutData((Object)fdlDeleteField);
        this.wDeleteField = new Text((Composite)wAdditionalFields, 18436);
        PropsUi.setLook((Widget)this.wDeleteField);
        this.wDeleteField.addModifyListener(lsMod);
        FormData fdDeleteField = new FormData();
        fdDeleteField.left = new FormAttachment(middle, 0);
        fdDeleteField.top = new FormAttachment((Control)this.wUpdateField, margin);
        fdDeleteField.right = new FormAttachment(100, 0);
        this.wDeleteField.setLayoutData((Object)fdDeleteField);
        Label wlReadField = new Label((Composite)wAdditionalFields, 131072);
        wlReadField.setText(BaseMessages.getString(PKG, (String)"ExecSqlRowDialog.ReadField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlReadField);
        FormData fdlReadField = new FormData();
        fdlReadField.left = new FormAttachment(0, 0);
        fdlReadField.right = new FormAttachment(middle, -margin);
        fdlReadField.top = new FormAttachment((Control)this.wDeleteField, margin);
        wlReadField.setLayoutData((Object)fdlReadField);
        this.wReadField = new Text((Composite)wAdditionalFields, 18436);
        PropsUi.setLook((Widget)this.wReadField);
        this.wReadField.addModifyListener(lsMod);
        FormData fdReadField = new FormData();
        fdReadField.left = new FormAttachment(middle, 0);
        fdReadField.top = new FormAttachment((Control)this.wDeleteField, margin);
        fdReadField.right = new FormAttachment(100, 0);
        this.wReadField.setLayoutData((Object)fdReadField);
        FormData fdAdditionalFields = new FormData();
        fdAdditionalFields.left = new FormAttachment(0, margin);
        fdAdditionalFields.top = new FormAttachment((Control)this.wSqlFromFile, 2 * margin);
        fdAdditionalFields.right = new FormAttachment(100, -margin);
        wAdditionalFields.setLayoutData((Object)fdAdditionalFields);
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOk, this.wCancel}, margin, (Control)wAdditionalFields);
        this.wCancel.addListener(13, e -> this.cancel());
        this.wOk.addListener(13, e -> this.ok());
        this.getData();
        this.input.setChanged(this.changed);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    public void getData() {
        this.wCommit.setText("" + this.input.getCommitSize());
        if (this.input.getSqlFieldName() != null) {
            this.wSqlFieldName.setText(this.input.getSqlFieldName());
        }
        if (this.input.getConnection() != null) {
            this.wConnection.setText(this.input.getConnection());
        }
        if (this.input.getUpdateField() != null) {
            this.wUpdateField.setText(this.input.getUpdateField());
        }
        if (this.input.getInsertField() != null) {
            this.wInsertField.setText(this.input.getInsertField());
        }
        if (this.input.getDeleteField() != null) {
            this.wDeleteField.setText(this.input.getDeleteField());
        }
        if (this.input.getReadField() != null) {
            this.wReadField.setText(this.input.getReadField());
        }
        this.wSqlFromFile.setSelection(this.input.isSqlFromfile());
        this.wSendOneStatement.setSelection(this.input.isSendOneStatement());
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.input.setCommitSize(Const.toInt((String)this.wCommit.getText(), (int)0));
        this.transformName = this.wTransformName.getText();
        this.input.setSqlFieldName(this.wSqlFieldName.getText());
        this.input.setConnection(this.wConnection.getText());
        this.input.setInsertField(this.wInsertField.getText());
        this.input.setUpdateField(this.wUpdateField.getText());
        this.input.setDeleteField(this.wDeleteField.getText());
        this.input.setReadField(this.wReadField.getText());
        this.input.setSqlFromfile(this.wSqlFromFile.getSelection());
        this.input.setSendOneStatement(this.wSendOneStatement.getSelection());
        DatabaseMeta databaseMeta = this.pipelineMeta.findDatabase(this.input.getConnection(), this.variables);
        if (databaseMeta == null) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"ExecSqlRowDialog.InvalidConnection.DialogMessage", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"ExecSqlRowDialog.InvalidConnection.DialogTitle", (String[])new String[0]));
            mb.open();
            return;
        }
        this.dispose();
    }

    private void get() {
        if (!this.gotPreviousFields) {
            this.gotPreviousFields = true;
            try {
                String sqlfield = this.wSqlFieldName.getText();
                this.wSqlFieldName.removeAll();
                IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
                if (r != null) {
                    this.wSqlFieldName.removeAll();
                    this.wSqlFieldName.setItems(r.getFieldNames());
                }
                if (sqlfield != null) {
                    this.wSqlFieldName.setText(sqlfield);
                }
            }
            catch (HopException ke) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"ExecSqlRowDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExecSqlRowDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
            }
        }
    }
}

