/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.joinrows;

import java.io.File;
import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Condition;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.injection.Injection;
import org.apache.hop.core.injection.InjectionSupported;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.joinrows.JoinRows;
import org.apache.hop.pipeline.transforms.joinrows.JoinRowsData;
import org.w3c.dom.Node;

@InjectionSupported(localizationPrefix="JoinRows.Injection.")
@Transform(id="JoinRows", image="joinrows.svg", name="i18n::BaseTransform.TypeLongDesc.JoinRows", description="i18n::BaseTransform.TypeTooltipDesc.JoinRows", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Joins", keywords={"i18n::JoinRowsMeta.keyword"}, documentationUrl="/pipeline/transforms/joinrows.html")
public class JoinRowsMeta
extends BaseTransformMeta<JoinRows, JoinRowsData> {
    private static final Class<?> PKG = JoinRowsMeta.class;
    @Injection(name="TEMP_DIR")
    private String directory;
    @Injection(name="TEMP_FILE_PREFIX")
    private String prefix;
    @Injection(name="MAX_CACHE_SIZE")
    private int cacheSize;
    private TransformMeta mainTransform;
    @Injection(name="MAIN_TRANSFORM")
    private String mainTransformName;
    private Condition condition = new Condition();

    public TransformMeta getMainTransform() {
        return this.mainTransform;
    }

    public void setMainTransform(TransformMeta lookupFromTransform) {
        this.mainTransform = lookupFromTransform;
    }

    public String getMainTransformName() {
        return this.mainTransformName;
    }

    public void setMainTransformName(String lookupFromTransformName) {
        this.mainTransformName = lookupFromTransformName;
    }

    public void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public Condition getCondition() {
        return this.condition;
    }

    public void setCondition(Condition condition) {
        this.condition = condition;
    }

    @Injection(name="CONDITION")
    public void setCondition(String conditionXML) throws Exception {
        this.condition = new Condition(conditionXML);
    }

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        this.readData(transformNode);
    }

    public Object clone() {
        JoinRowsMeta retval = (JoinRowsMeta)((Object)super.clone());
        return retval;
    }

    private void readData(Node transformNode) throws HopXmlException {
        try {
            this.directory = XmlHandler.getTagValue((Node)transformNode, (String)"directory");
            this.prefix = XmlHandler.getTagValue((Node)transformNode, (String)"prefix");
            this.cacheSize = Const.toInt((String)XmlHandler.getTagValue((Node)transformNode, (String)"cache_size"), (int)-1);
            this.mainTransformName = XmlHandler.getTagValue((Node)transformNode, (String)"main");
            Node compare = XmlHandler.getSubNode((Node)transformNode, (String)"compare");
            Node condnode = XmlHandler.getSubNode((Node)compare, (String)"condition");
            this.condition = condnode != null ? new Condition(condnode) : new Condition();
        }
        catch (Exception e) {
            throw new HopXmlException(BaseMessages.getString(PKG, (String)"JoinRowsMeta.Exception.UnableToReadTransformMetaFromXML", (String[])new String[0]), (Throwable)e);
        }
    }

    public void setDefault() {
        this.directory = "%%java.io.tmpdir%%";
        this.prefix = "out";
        this.cacheSize = 500;
        this.mainTransformName = null;
    }

    public String getXml() throws HopException {
        StringBuilder xml = new StringBuilder(300);
        xml.append("      ").append(XmlHandler.addTagValue((String)"directory", (String)this.directory));
        xml.append("      ").append(XmlHandler.addTagValue((String)"prefix", (String)this.prefix));
        xml.append("      ").append(XmlHandler.addTagValue((String)"cache_size", (int)this.cacheSize));
        if (this.mainTransformName == null) {
            this.mainTransformName = this.getLookupTransformName();
        }
        xml.append("      ").append(XmlHandler.addTagValue((String)"main", (String)this.mainTransformName));
        xml.append("    <compare>").append(Const.CR);
        if (this.condition != null) {
            xml.append(this.condition.getXml());
        }
        xml.append("    </compare>").append(Const.CR);
        return xml.toString();
    }

    public void getFields(IRowMeta rowMeta, String origin, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        if (variables instanceof PipelineMeta) {
            PipelineMeta pipelineMeta = (PipelineMeta)variables;
            TransformMeta[] transforms = pipelineMeta.getPrevTransforms(pipelineMeta.findTransform(origin));
            TransformMeta mainTransform = pipelineMeta.findTransform(this.getMainTransformName());
            rowMeta.clear();
            if (mainTransform != null) {
                rowMeta.addRowMeta(pipelineMeta.getTransformFields(variables, mainTransform));
            }
            for (TransformMeta transform : transforms) {
                if (mainTransform != null && transform.equals((Object)mainTransform)) continue;
                rowMeta.addRowMeta(pipelineMeta.getTransformFields(variables, transform));
            }
        }
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        if (prev != null && prev.size() > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"JoinRowsMeta.CheckResult.TransformReceivingDatas", (String[])new String[]{"" + prev.size()}), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
            String realDirectory = variables.resolve(this.directory);
            File f = new File(realDirectory);
            if (f.exists()) {
                if (f.isDirectory()) {
                    cr = new CheckResult(1, "[" + realDirectory + BaseMessages.getString(PKG, (String)"JoinRowsMeta.CheckResult.DirectoryExists", (String[])new String[0]), (ICheckResultSource)transformMeta);
                    remarks.add((ICheckResult)cr);
                } else {
                    cr = new CheckResult(4, "[" + realDirectory + BaseMessages.getString(PKG, (String)"JoinRowsMeta.CheckResult.DirectoryExistsButNotValid", (String[])new String[0]), (ICheckResultSource)transformMeta);
                    remarks.add((ICheckResult)cr);
                }
            } else {
                cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"JoinRowsMeta.CheckResult.DirectoryDoesNotExist", (String[])new String[]{realDirectory}), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"JoinRowsMeta.CheckResult.CouldNotFindFieldsFromPreviousTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"JoinRowsMeta.CheckResult.TransformReceivingInfoFromOtherTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"JoinRowsMeta.CheckResult.NoInputReceived", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public String getLookupTransformName() {
        if (this.mainTransform != null && this.mainTransform.getName() != null && this.mainTransform.getName().length() > 0) {
            return this.mainTransform.getName();
        }
        return null;
    }

    public void searchInfoAndTargetTransforms(List<TransformMeta> transforms) {
        this.mainTransform = TransformMeta.findTransform(transforms, (String)this.mainTransformName);
    }

    public boolean excludeFromRowLayoutVerification() {
        return true;
    }

    public boolean cleanAfterHopToRemove(TransformMeta fromTransform) {
        boolean hasChanged = false;
        if (null != fromTransform && fromTransform.equals((Object)this.getMainTransform())) {
            this.setMainTransform(null);
            this.setMainTransformName(null);
            hasChanged = true;
        }
        return hasChanged;
    }
}

