/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.SystemPool;
import com.ibm.as400.access.Trace;
import com.ibm.as400.vaccess.ChangeEventSupport;
import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.ResourceLoader;
import com.ibm.as400.vaccess.VObjectEventSupport;
import com.ibm.as400.vaccess.VObjectListener;
import com.ibm.as400.vaccess.VPropertiesPane;
import com.ibm.as400.vaccess.VSystemPool;
import com.ibm.as400.vaccess.VUtilities;
import com.ibm.as400.vaccess.WorkingEventSupport;
import com.ibm.as400.vaccess.WorkingListener;
import java.awt.Component;
import java.awt.GridBagLayout;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeListener;

class SystemPoolPropertiesPane
implements VPropertiesPane {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private static final String otherTabText_ = ResourceLoader.getText("TAB_OTHER");
    private static final String generalTabText_ = ResourceLoader.getText("TAB_GENERAL");
    private static final String maximumActiveThreadsText_ = ResourceLoader.getText("SYSTEM_POOL_MAXIMUM_ACTIVE_THREADS") + ":   ";
    private static final String databaseFaultsText_ = ResourceLoader.getText("SYSTEM_POOL_DATABASE_FAULTS") + ": ";
    private static final String databasePagesText_ = ResourceLoader.getText("SYSTEM_POOL_DATABASE_PAGES") + ": ";
    private static final String nondatabaseFaultsText_ = ResourceLoader.getText("SYSTEM_POOL_NONDATABASE_FAULTS") + ": ";
    private static final String nondatabasePagesText_ = ResourceLoader.getText("SYSTEM_POOL_NONDATABASE_PAGES") + ": ";
    private static final String activeToWaitText_ = ResourceLoader.getText("SYSTEM_POOL_ACTIVE_TO_WAIT") + ": ";
    private static final String waitToIneligibleText_ = ResourceLoader.getText("SYSTEM_POOL_WAIT_TO_INELIGIBLE") + ": ";
    private static final String activeToIneligibleText_ = ResourceLoader.getText("SYSTEM_POOL_ACTIVE_TO_INELIGIBLE") + ": ";
    private static final String poolNameText_ = ResourceLoader.getText("SYSTEM_POOL_POOL_NAME") + ":   ";
    private static final String subsystemNameText_ = ResourceLoader.getText("SYSTEM_POOL_SUBSYSTEM_NAME") + ":   ";
    private static final String subsystemLibraryNameText_ = ResourceLoader.getText("SYSTEM_POOL_SUBSYSTEM__LIBRARY_NAME") + ": ";
    private static final String pagingOptionText_ = ResourceLoader.getText("SYSTEM_POOL_PAGING_OPTION") + ":   ";
    private String[] names_;
    private Object[] values_;
    private VSystemPool object_;
    private SystemPool systemPool_;
    private ChangeEventSupport changeEventSupport_ = new ChangeEventSupport(this);
    private ErrorEventSupport errorEventSupport_ = new ErrorEventSupport(this);
    private VObjectEventSupport objectEventSupport_ = new VObjectEventSupport(this);
    private WorkingEventSupport workingEventSupport_ = new WorkingEventSupport(this);

    public SystemPoolPropertiesPane(VSystemPool vSystemPool, SystemPool systemPool) {
        this.object_ = vSystemPool;
        this.systemPool_ = systemPool;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeEventSupport_.addChangeListener(changeListener);
    }

    public void addErrorListener(ErrorListener errorListener) {
        this.errorEventSupport_.addErrorListener(errorListener);
    }

    public void addVObjectListener(VObjectListener vObjectListener) {
        this.objectEventSupport_.addVObjectListener(vObjectListener);
    }

    public void addWorkingListener(WorkingListener workingListener) {
        this.workingEventSupport_.addWorkingListener(workingListener);
    }

    public void applyChanges() throws Exception {
    }

    private Component getGeneralTab() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        int n = 0;
        try {
            VUtilities.constrain(poolNameText_, this.systemPool_.getPoolName(), jPanel, gridBagLayout, n++);
            VUtilities.constrain(maximumActiveThreadsText_, Integer.toString(this.systemPool_.getMaximumActiveThreads()), jPanel, gridBagLayout, n++);
            VUtilities.constrain(subsystemNameText_, this.systemPool_.getSubsystemName(), jPanel, gridBagLayout, n++);
            VUtilities.constrain(pagingOptionText_, this.systemPool_.getPagingOption(), jPanel, gridBagLayout, n++);
        }
        catch (Exception exception) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "Unable to properly create general tab for system pool properties pane.", (Throwable)exception);
            }
            this.errorEventSupport_.fireError(exception);
        }
        return jPanel;
    }

    private Component getOtherTab() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        int n = 0;
        try {
            VUtilities.constrain(databaseFaultsText_, Float.toString(this.systemPool_.getDatabaseFaults()), jPanel, gridBagLayout, n++);
            VUtilities.constrain(databasePagesText_, Float.toString(this.systemPool_.getDatabasePages()), jPanel, gridBagLayout, n++);
            VUtilities.constrain(nondatabaseFaultsText_, Float.toString(this.systemPool_.getNonDatabaseFaults()), jPanel, gridBagLayout, n++);
            VUtilities.constrain(nondatabasePagesText_, Float.toString(this.systemPool_.getNonDatabasePages()), jPanel, gridBagLayout, n++);
            VUtilities.constrain(activeToWaitText_, Float.toString(this.systemPool_.getActiveToWait()), jPanel, gridBagLayout, n++);
            VUtilities.constrain(waitToIneligibleText_, Float.toString(this.systemPool_.getWaitToIneligible()), jPanel, gridBagLayout, n++);
            VUtilities.constrain(activeToIneligibleText_, Float.toString(this.systemPool_.getActiveToIneligible()), jPanel, gridBagLayout, n++);
        }
        catch (Exception exception) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(2, "Unable to properly create other tab for system pool properties pane.", (Throwable)exception);
            }
            this.errorEventSupport_.fireError(exception);
        }
        return jPanel;
    }

    public Component getComponent() {
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.addTab(generalTabText_, null, this.getGeneralTab());
        jTabbedPane.addTab(otherTabText_, null, this.getOtherTab());
        jTabbedPane.setSelectedIndex(0);
        return jTabbedPane;
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeEventSupport_.removeChangeListener(changeListener);
    }

    public void removeErrorListener(ErrorListener errorListener) {
        this.errorEventSupport_.removeErrorListener(errorListener);
    }

    public void removeVObjectListener(VObjectListener vObjectListener) {
        this.objectEventSupport_.removeVObjectListener(vObjectListener);
    }

    public void removeWorkingListener(WorkingListener workingListener) {
        this.workingEventSupport_.removeWorkingListener(workingListener);
    }
}

