/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.resource.ResourceList;
import com.ibm.as400.resource.ResourceListEvent;
import com.ibm.as400.resource.ResourceListListener;
import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.ListDataEventSupport;
import com.ibm.as400.vaccess.PropertyChangeSupport;
import com.ibm.as400.vaccess.WorkingEventSupport;
import com.ibm.as400.vaccess.WorkingListener;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import javax.swing.ListModel;
import javax.swing.event.ListDataListener;

public class ResourceListModel
implements ListModel,
Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private boolean exceptionOccured_ = false;
    private transient boolean loaded_ = false;
    private ResourceList resourceList_ = null;
    private transient ErrorEventSupport errorEventSupport_;
    transient ListDataEventSupport listDataEventSupport_;
    private transient PropertyChangeSupport propertyChangeSupport_;
    private transient ResourceListListener resourceListListener_;
    private transient WorkingEventSupport workingEventSupport_;

    public ResourceListModel() {
        this.initializeTransient();
    }

    public ResourceListModel(ResourceList resourceList) {
        if (resourceList == null) {
            throw new NullPointerException("resourceList");
        }
        this.resourceList_ = resourceList;
        this.initializeTransient();
    }

    public void addErrorListener(ErrorListener errorListener) {
        this.errorEventSupport_.addErrorListener(errorListener);
    }

    public void addListDataListener(ListDataListener listDataListener) {
        this.listDataEventSupport_.addListDataListener(listDataListener);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport_.addPropertyChangeListener(propertyChangeListener);
    }

    public void addWorkingListener(WorkingListener workingListener) {
        this.workingEventSupport_.addWorkingListener(workingListener);
    }

    public Object getElementAt(int n) {
        if (this.resourceList_ == null || !this.loaded_ || this.exceptionOccured_) {
            return null;
        }
        try {
            if (n < 0 || this.resourceList_.isComplete() && (long)n > this.resourceList_.getListLength()) {
                return null;
            }
            return this.resourceList_.resourceAt(n);
        }
        catch (Exception exception) {
            this.errorEventSupport_.fireError(exception);
            this.exceptionOccured_ = true;
            return null;
        }
    }

    public ResourceList getResourceList() {
        return this.resourceList_;
    }

    public int getSize() {
        if (this.resourceList_ == null || !this.loaded_ || this.exceptionOccured_) {
            return 0;
        }
        try {
            if (!this.resourceList_.isComplete()) {
                this.resourceList_.refreshStatus();
            }
            long l = this.resourceList_.getListLength();
            return (int)l;
        }
        catch (Exception exception) {
            this.errorEventSupport_.fireError(exception);
            this.exceptionOccured_ = true;
            return 0;
        }
    }

    private void initializeTransient() {
        this.errorEventSupport_ = new ErrorEventSupport(this);
        this.listDataEventSupport_ = new ListDataEventSupport(this);
        this.propertyChangeSupport_ = new PropertyChangeSupport(this);
        this.resourceListListener_ = new ResourceListListener_();
        this.workingEventSupport_ = new WorkingEventSupport(this);
        if (this.resourceList_ != null) {
            this.resourceList_.addActiveStatusListener(this.workingEventSupport_);
            this.resourceList_.addResourceListListener(this.resourceListListener_);
        }
    }

    public void load() {
        int n = this.getSize();
        if (this.loaded_ && this.resourceList_ != null && !this.exceptionOccured_) {
            try {
                this.resourceList_.refreshContents();
            }
            catch (Exception exception) {
                this.errorEventSupport_.fireError(exception);
                this.exceptionOccured_ = true;
            }
        } else {
            this.loaded_ = true;
        }
        this.listDataEventSupport_.fireContentsChanged(0, n);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.initializeTransient();
    }

    public void removeErrorListener(ErrorListener errorListener) {
        this.errorEventSupport_.removeErrorListener(errorListener);
    }

    public void removeListDataListener(ListDataListener listDataListener) {
        this.listDataEventSupport_.removeListDataListener(listDataListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport_.removePropertyChangeListener(propertyChangeListener);
    }

    public void removeWorkingListener(WorkingListener workingListener) {
        this.workingEventSupport_.removeWorkingListener(workingListener);
    }

    public void setResourceList(ResourceList resourceList) {
        if (resourceList == null) {
            throw new NullPointerException("resourceList");
        }
        ResourceList resourceList2 = this.resourceList_;
        if (resourceList2 != resourceList) {
            int n = this.getSize();
            if (resourceList2 != null) {
                resourceList2.removeActiveStatusListener(this.workingEventSupport_);
                resourceList2.removeResourceListListener(this.resourceListListener_);
            }
            resourceList.addActiveStatusListener(this.workingEventSupport_);
            resourceList.addResourceListListener(this.resourceListListener_);
            this.resourceList_ = resourceList;
            this.exceptionOccured_ = false;
            this.listDataEventSupport_.fireContentsChanged(0, n);
        }
        this.propertyChangeSupport_.firePropertyChange("resourceList", resourceList2, this.resourceList_);
    }

    private class ResourceListListener_
    implements ResourceListListener {
        private long length_ = 0L;

        private ResourceListListener_() {
        }

        public void lengthChanged(ResourceListEvent resourceListEvent) {
            long l = resourceListEvent.getLength();
            ResourceListModel.this.listDataEventSupport_.fireIntervalAdded((int)this.length_, (int)l);
            this.length_ = l;
        }

        public void listClosed(ResourceListEvent resourceListEvent) {
        }

        public void listCompleted(ResourceListEvent resourceListEvent) {
        }

        public void listInError(ResourceListEvent resourceListEvent) {
        }

        public void listOpened(ResourceListEvent resourceListEvent) {
        }

        public void resourceAdded(ResourceListEvent resourceListEvent) {
        }
    }
}

