/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.resource;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400BidiTransform;
import com.ibm.as400.access.Trace;
import com.ibm.as400.data.PcmlException;
import com.ibm.as400.data.ProgramCallDocument;
import com.ibm.as400.resource.ProgramMap;
import com.ibm.as400.resource.ProgramMapEntry;
import com.ibm.as400.resource.ResourceException;
import java.io.Serializable;
import java.util.Vector;

public class ProgramAttributeGetter
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    private ProgramMap attributeMap_ = null;
    private ProgramCallDocument document_ = null;
    private Vector programsCalled_ = new Vector();
    private AS400 system_ = null;

    public ProgramAttributeGetter(AS400 aS400, ProgramCallDocument programCallDocument, ProgramMap programMap) {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        if (programCallDocument == null) {
            throw new NullPointerException("document");
        }
        if (programMap == null) {
            throw new NullPointerException("attributeMap");
        }
        this.system_ = aS400;
        this.document_ = programCallDocument;
        this.attributeMap_ = programMap;
    }

    public void clearBuffer() {
        this.programsCalled_.removeAllElements();
    }

    public Object getValue(Object object) throws ResourceException {
        return this.getValue(object, AS400BidiTransform.getStringType((char)this.system_.getCcsid()));
    }

    public Object getValue(Object object, int n) throws ResourceException {
        if (object == null) {
            throw new NullPointerException("attributeID");
        }
        ProgramAttributeGetter programAttributeGetter = this;
        synchronized (programAttributeGetter) {
            int n2;
            ProgramMapEntry[] programMapEntryArray = this.attributeMap_.getEntries(object);
            int n3 = -1;
            String string = null;
            for (n2 = 0; n2 < programMapEntryArray.length; ++n2) {
                string = programMapEntryArray[n2].getProgramName();
                if (!this.programsCalled_.contains(string)) continue;
                n3 = n2;
                if (!Trace.isTraceOn()) break;
                Trace.log(3, "Getting attribute value " + object + " using PCML document " + this.document_ + ", program " + string + " (which has already been called).");
                break;
            }
            if (n3 < 0) {
                n3 = 0;
                string = programMapEntryArray[0].getProgramName();
                if (Trace.isTraceOn()) {
                    Trace.log(3, "Getting attribute value " + object + " using PCML document " + this.document_ + ", program " + string + " (which is about to be called).");
                }
                n2 = 0;
                try {
                    n2 = this.document_.callProgram(string) ? 1 : 0;
                    if (n2 == 0) {
                        throw new ResourceException(this.document_.getMessageList(string));
                    }
                    this.programsCalled_.addElement(string);
                }
                catch (ResourceException resourceException) {
                    throw resourceException;
                }
                catch (Exception exception) {
                    throw new ResourceException(1, (Throwable)exception);
                }
            }
            try {
                return programMapEntryArray[n3].getValue(this.system_, this.document_, null, null, n);
            }
            catch (PcmlException pcmlException) {
                throw new ResourceException(1, (Throwable)pcmlException);
            }
        }
    }
}

