/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.hdfs;

import java.net.URI;
import java.util.Objects;
import org.apache.beam.sdk.io.fs.ResolveOptions;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.hadoop.fs.Path;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

class HadoopResourceId
implements ResourceId {
    private final @UnknownKeyFor @NonNull @Initialized URI uri;

    HadoopResourceId(@UnknownKeyFor @NonNull @Initialized URI uri) {
        this.uri = uri;
    }

    public @UnknownKeyFor @NonNull @Initialized ResourceId resolve(@UnknownKeyFor @NonNull @Initialized String other, @UnknownKeyFor @NonNull @Initialized ResolveOptions resolveOptions) {
        Preconditions.checkState((boolean)this.isDirectory(), (Object)String.format("Expected this resource is a directory, but had [%s].", this.uri));
        if (resolveOptions == ResolveOptions.StandardResolveOptions.RESOLVE_DIRECTORY) {
            if (!other.endsWith("/")) {
                other = other + "/";
            }
            return new HadoopResourceId(this.uri.resolve(other));
        }
        if (resolveOptions == ResolveOptions.StandardResolveOptions.RESOLVE_FILE) {
            Preconditions.checkArgument((!other.endsWith("/") ? 1 : 0) != 0, (String)"Resolving a file with a directory path: %s", (Object)other);
            return new HadoopResourceId(this.uri.resolve(other));
        }
        throw new UnsupportedOperationException(String.format("Unexpected StandardResolveOptions %s", resolveOptions));
    }

    public @UnknownKeyFor @NonNull @Initialized ResourceId getCurrentDirectory() {
        return new HadoopResourceId(this.uri.getPath().endsWith("/") ? this.uri : this.uri.resolve("."));
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isDirectory() {
        return this.uri.getPath().endsWith("/");
    }

    public @UnknownKeyFor @NonNull @Initialized String getFilename() {
        if (this.isDirectory()) {
            Path parentPath = new Path(this.uri).getParent();
            return parentPath == null ? null : parentPath.getName();
        }
        return new Path(this.uri).getName();
    }

    public @UnknownKeyFor @NonNull @Initialized String getScheme() {
        return this.uri.getScheme();
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return this.uri.toString();
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object obj) {
        if (!(obj instanceof HadoopResourceId)) {
            return false;
        }
        return Objects.equals(this.uri, ((HadoopResourceId)obj).uri);
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return Objects.hashCode(this.uri);
    }

    @UnknownKeyFor @NonNull @Initialized Path toPath() {
        return new Path(this.uri);
    }
}

