/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client;

import com.clickhouse.client.ClickHouseChecker;
import com.clickhouse.client.ClickHouseException;
import com.clickhouse.client.ClickHouseNode;
import com.clickhouse.client.ClickHouseRequest;
import com.clickhouse.client.ClickHouseTransaction;
import com.clickhouse.client.ClickHouseUtils;
import java.util.UUID;

public class ClickHouseRequestManager {
    public static ClickHouseRequestManager getInstance() {
        return InstanceHolder.instance;
    }

    public String createQueryId() {
        return UUID.randomUUID().toString();
    }

    public String createSessionId() {
        return UUID.randomUUID().toString();
    }

    public ClickHouseTransaction createImplicitTransaction(ClickHouseRequest<?> request) throws ClickHouseException {
        return new ClickHouseTransaction(ClickHouseChecker.nonNull(request, "Request").getServer(), request.getConfig().getTransactionTimeout(), true);
    }

    public ClickHouseTransaction createTransaction(ClickHouseRequest<?> request) throws ClickHouseException {
        return this.createTransaction(request, 0);
    }

    public ClickHouseTransaction createTransaction(ClickHouseRequest<?> request, int timeout) throws ClickHouseException {
        return this.createTransaction(ClickHouseChecker.nonNull(request, "Request").getServer(), request.getConfig().getTransactionTimeout());
    }

    public ClickHouseTransaction createTransaction(ClickHouseNode server, int timeout) throws ClickHouseException {
        return new ClickHouseTransaction(ClickHouseChecker.nonNull(server, "Server"), this.createSessionId(), timeout > 0 ? timeout : server.config.getTransactionTimeout(), null);
    }

    public ClickHouseTransaction getOrStartTransaction(ClickHouseRequest<?> request) throws ClickHouseException {
        return this.getOrStartTransaction(request, 0);
    }

    public ClickHouseTransaction getOrStartTransaction(ClickHouseRequest<?> request, int timeout) throws ClickHouseException {
        ClickHouseTransaction tx;
        if (timeout < 1) {
            timeout = request.getConfig().getTransactionTimeout();
        }
        if ((tx = ClickHouseChecker.nonNull(request, "Request").getTransaction()) != null && tx.getTimeout() == timeout) {
            return tx;
        }
        tx = this.createTransaction(request.getServer(), timeout);
        tx.begin();
        request.transaction(tx);
        return tx;
    }

    static final class InstanceHolder {
        private static final ClickHouseRequestManager instance = ClickHouseUtils.getService(ClickHouseRequestManager.class, ClickHouseRequestManager::new);

        private InstanceHolder() {
        }
    }
}

