/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.mongo.wrapper.field;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.mongo.wrapper.field.MongoField;
import org.apache.hop.pipeline.transforms.mongodbinput.MongoDbInputData;

public class MongoArrayExpansion {
    protected static Class<?> PKG = MongoArrayExpansion.class;
    public String expansionPath;
    protected List<MongoField> subFields;
    private List<String> pathParts;
    private List<String> tempParts;
    public IRowMeta outputRowMeta;

    public MongoArrayExpansion(List<MongoField> subFields) {
        this.subFields = subFields;
    }

    public void init() throws HopException {
        if (StringUtils.isEmpty((String)this.expansionPath)) {
            throw new HopException(BaseMessages.getString(PKG, (String)"MongoDbInput.ErrorMessage.NoPathSet", (String[])new String[0]));
        }
        if (this.pathParts != null) {
            return;
        }
        String expansionPath = MongoDbInputData.cleansePath(this.expansionPath);
        String[] temp = expansionPath.split("\\.");
        this.pathParts = new ArrayList<String>();
        for (String part : temp) {
            this.pathParts.add(part);
        }
        if (this.pathParts.get(0).equals("$")) {
            this.pathParts.remove(0);
        } else if (this.pathParts.get(0).startsWith("$[")) {
            String r = this.pathParts.get(0).substring(1);
            this.pathParts.set(0, r);
        }
        this.tempParts = new ArrayList<String>();
        if (this.subFields != null) {
            for (MongoField f : this.subFields) {
                int outputIndex = this.outputRowMeta.indexOfValue(f.fieldName);
                f.init(outputIndex);
            }
        }
    }

    public void reset(IVariables variables) {
        this.tempParts.clear();
        for (String part : this.pathParts) {
            this.tempParts.add(variables.resolve(part));
        }
        for (MongoField f : this.subFields) {
            f.reset(variables);
        }
    }

    protected Object[][] nullResult() {
        Object[][] result = new Object[1][this.outputRowMeta.size() + RowDataUtil.OVER_ALLOCATE_SIZE];
        return result;
    }

    public Object[][] convertToHopValue(BasicDBObject mongoObject, IVariables variables) throws HopException {
        Object fieldValue;
        if (mongoObject == null) {
            return this.nullResult();
        }
        if (this.tempParts.size() == 0) {
            throw new HopException(BaseMessages.getString(PKG, (String)"MongoDbInput.ErrorMessage.MalformedPathRecord", (String[])new String[0]));
        }
        String part = this.tempParts.remove(0);
        if (part.charAt(0) == '[') {
            return this.nullResult();
        }
        if (part.indexOf(91) > 0) {
            String arrayPart = part.substring(part.indexOf(91));
            part = part.substring(0, part.indexOf(91));
            this.tempParts.add(0, arrayPart);
        }
        if ((fieldValue = mongoObject.get(part)) == null) {
            return this.nullResult();
        }
        if (fieldValue instanceof BasicDBObject) {
            return this.convertToHopValue((BasicDBObject)fieldValue, variables);
        }
        if (fieldValue instanceof BasicDBList) {
            return this.convertToHopValue((BasicDBList)fieldValue, variables);
        }
        return this.nullResult();
    }

    public Object[][] convertToHopValue(BasicDBList mongoList, IVariables variables) throws HopException {
        if (mongoList == null) {
            return this.nullResult();
        }
        if (this.tempParts.size() == 0) {
            throw new HopException(BaseMessages.getString(PKG, (String)"MongoDbInput.ErrorMessage.MalformedPathArray", (String[])new String[0]));
        }
        String part = this.tempParts.remove(0);
        if (part.charAt(0) != '[') {
            return this.nullResult();
        }
        String index = part.substring(1, part.indexOf(93));
        if (part.indexOf(93) < part.length() - 1) {
            part = part.substring(part.indexOf(93) + 1, part.length());
            this.tempParts.add(0, part);
        }
        if (index.equals("*")) {
            Object[][] result = new Object[mongoList.size()][this.outputRowMeta.size() + RowDataUtil.OVER_ALLOCATE_SIZE];
            for (int i = 0; i < mongoList.size(); ++i) {
                Object element = mongoList.get(i);
                for (int j = 0; j < this.subFields.size(); ++j) {
                    MongoField sf = this.subFields.get(j);
                    sf.reset(variables);
                    result[i][sf.outputIndex] = element instanceof BasicDBObject ? sf.convertToHopValue((BasicDBObject)element) : (element instanceof BasicDBList ? sf.convertToHopValue((BasicDBList)element) : sf.getHopValue(element));
                }
            }
            return result;
        }
        int arrayI = 0;
        try {
            arrayI = Integer.parseInt(index.trim());
        }
        catch (NumberFormatException e) {
            throw new HopException(BaseMessages.getString(PKG, (String)"MongoDbInput.ErrorMessage.UnableToParseArrayIndex", (String[])new String[]{index}));
        }
        if (arrayI >= mongoList.size() || arrayI < 0) {
            return this.nullResult();
        }
        Object element = mongoList.get(arrayI);
        if (element == null) {
            return this.nullResult();
        }
        if (element instanceof BasicDBObject) {
            return this.convertToHopValue((BasicDBObject)element, variables);
        }
        if (element instanceof BasicDBList) {
            return this.convertToHopValue((BasicDBList)element, variables);
        }
        return this.nullResult();
    }
}

