/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Joiner;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@Internal
public class NameUtils {
    private static final @UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] STANDARD_NAME_SUFFIXES = new String[]{"DoFn", "CombineFn", "Fn"};
    private static final @UnknownKeyFor @NonNull @Initialized Pattern NAMED_INNER_CLASS = Pattern.compile(".+\\$(?<INNER>[^0-9].*)");
    private static final @UnknownKeyFor @NonNull @Initialized String ANONYMOUS_CLASS_REGEX = "\\$[0-9]+\\$";

    private static @UnknownKeyFor @NonNull @Initialized String approximateSimpleName(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> clazz, @UnknownKeyFor @NonNull @Initialized boolean dropOuterClassNames) {
        Preconditions.checkArgument((!clazz.isAnonymousClass() ? 1 : 0) != 0, (Object)"Attempted to get simple name of anonymous class");
        return NameUtils.approximateSimpleName(clazz.getName(), dropOuterClassNames);
    }

    @VisibleForTesting
    static @UnknownKeyFor @NonNull @Initialized String approximateSimpleName(@UnknownKeyFor @NonNull @Initialized String fullName, @UnknownKeyFor @NonNull @Initialized boolean dropOuterClassNames) {
        String shortName = fullName.substring(fullName.lastIndexOf(46) + 1);
        Object[] names = shortName.split("\\$");
        for (int i = 0; i < names.length; ++i) {
            names[i] = NameUtils.simplifyNameComponent((String)names[i]);
        }
        shortName = Joiner.on((char)'$').join(names);
        if (dropOuterClassNames) {
            Matcher m = NAMED_INNER_CLASS.matcher(shortName);
            if (m.matches()) {
                shortName = m.group("INNER");
            }
        } else {
            shortName = shortName.replaceAll(ANONYMOUS_CLASS_REGEX, ".");
            shortName = shortName.replaceAll("\\$", ".");
        }
        return shortName;
    }

    private static @UnknownKeyFor @NonNull @Initialized String simplifyNameComponent(@UnknownKeyFor @NonNull @Initialized String name) {
        for (String suffix : STANDARD_NAME_SUFFIXES) {
            if (!name.endsWith(suffix) || name.length() <= suffix.length()) continue;
            return name.substring(0, name.length() - suffix.length());
        }
        return name;
    }

    public static @UnknownKeyFor @NonNull @Initialized String approximateSimpleName(@UnknownKeyFor @NonNull @Initialized Object object) {
        return NameUtils.approximateSimpleName(object, "Anonymous");
    }

    public static @UnknownKeyFor @NonNull @Initialized String approximateSimpleName(@UnknownKeyFor @NonNull @Initialized Object object, @UnknownKeyFor @NonNull @Initialized String anonymousValue) {
        if (object instanceof NameOverride) {
            return ((NameOverride)object).getNameOverride();
        }
        Class<?> clazz = object instanceof Class ? (Class<?>)object : object.getClass();
        if (clazz.isAnonymousClass()) {
            return anonymousValue;
        }
        return NameUtils.approximateSimpleName(clazz, true);
    }

    public static @UnknownKeyFor @NonNull @Initialized String approximatePTransformName(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> clazz) {
        Preconditions.checkArgument((boolean)PTransform.class.isAssignableFrom(clazz));
        if (clazz.getSimpleName().startsWith("AutoValue_")) {
            return NameUtils.approximatePTransformName(clazz.getSuperclass());
        }
        return NameUtils.approximateSimpleName(clazz, false).replaceFirst("\\.Bound$", "");
    }

    public static interface NameOverride {
        public @UnknownKeyFor @NonNull @Initialized String getNameOverride();
    }
}

