/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms.display;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.auto.value.AutoValue;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.display.AutoValue_DisplayData_Identifier;
import org.apache.beam.sdk.transforms.display.AutoValue_DisplayData_Item;
import org.apache.beam.sdk.transforms.display.AutoValue_DisplayData_ItemSpec;
import org.apache.beam.sdk.transforms.display.HasDisplayData;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Joiner;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Maps;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Sets;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class DisplayData
implements Serializable {
    private static final @UnknownKeyFor @NonNull @Initialized DisplayData EMPTY = new DisplayData(Maps.newHashMap());
    private static final @UnknownKeyFor @NonNull @Initialized DateTimeFormatter TIMESTAMP_FORMATTER = ISODateTimeFormat.dateTime();
    private final @UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized Identifier, @UnknownKeyFor @NonNull @Initialized Item> entries;

    private DisplayData(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Identifier, @UnknownKeyFor @NonNull @Initialized Item> entries) {
        this.entries = ImmutableMap.copyOf(entries);
    }

    public static @UnknownKeyFor @NonNull @Initialized DisplayData none() {
        return EMPTY;
    }

    public static @UnknownKeyFor @NonNull @Initialized DisplayData from(@UnknownKeyFor @NonNull @Initialized HasDisplayData component) {
        Preconditions.checkNotNull((Object)component, (Object)"component argument cannot be null");
        InternalBuilder builder = new InternalBuilder();
        builder.include(Path.root(), component);
        return builder.build();
    }

    public static @Nullable @UnknownKeyFor @Initialized Type inferType(@Nullable @UnknownKeyFor @Initialized Object value) {
        return Type.tryInferFrom(value);
    }

    @JsonValue
    public @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized Item> items() {
        return this.entries.values();
    }

    public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Identifier, @UnknownKeyFor @NonNull @Initialized Item> asMap() {
        return this.entries;
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return this.entries.hashCode();
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object obj) {
        if (obj instanceof DisplayData) {
            DisplayData that = (DisplayData)obj;
            return Objects.equals(this.entries, that.entries);
        }
        return false;
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        StringBuilder builder = new StringBuilder();
        boolean isFirstLine = true;
        for (Item entry : this.entries.values()) {
            if (isFirstLine) {
                isFirstLine = false;
            } else {
                builder.append("\n");
            }
            builder.append(entry);
        }
        return builder.toString();
    }

    public static @UnknownKeyFor @NonNull @Initialized ItemSpec<@UnknownKeyFor @NonNull @Initialized String> item(@UnknownKeyFor @NonNull @Initialized String key, @Nullable @UnknownKeyFor @Initialized String value) {
        return DisplayData.item(key, Type.STRING, value);
    }

    public static /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized ItemSpec<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> item(@UnknownKeyFor @NonNull @Initialized String key, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> value) {
        if (value == null) {
            return DisplayData.item(key, Type.STRING, null);
        }
        if (value.isAccessible()) {
            Object got = value.get();
            if (got == null) {
                return DisplayData.item(key, Type.STRING, null);
            }
            Type type = DisplayData.inferType(got);
            if (type != null) {
                return DisplayData.item(key, type, got);
            }
        }
        return DisplayData.item(key, Type.STRING, String.valueOf(value));
    }

    public static @UnknownKeyFor @NonNull @Initialized ItemSpec<@UnknownKeyFor @NonNull @Initialized Integer> item(@UnknownKeyFor @NonNull @Initialized String key, @Nullable @UnknownKeyFor @Initialized Integer value) {
        return DisplayData.item(key, Type.INTEGER, value);
    }

    public static @UnknownKeyFor @NonNull @Initialized ItemSpec<@UnknownKeyFor @NonNull @Initialized Long> item(@UnknownKeyFor @NonNull @Initialized String key, @Nullable @UnknownKeyFor @Initialized Long value) {
        return DisplayData.item(key, Type.INTEGER, value);
    }

    public static @UnknownKeyFor @NonNull @Initialized ItemSpec<@UnknownKeyFor @NonNull @Initialized Float> item(@UnknownKeyFor @NonNull @Initialized String key, @Nullable @UnknownKeyFor @Initialized Float value) {
        return DisplayData.item(key, Type.FLOAT, value);
    }

    public static @UnknownKeyFor @NonNull @Initialized ItemSpec<@UnknownKeyFor @NonNull @Initialized Double> item(@UnknownKeyFor @NonNull @Initialized String key, @Nullable @UnknownKeyFor @Initialized Double value) {
        return DisplayData.item(key, Type.FLOAT, value);
    }

    public static @UnknownKeyFor @NonNull @Initialized ItemSpec<@UnknownKeyFor @NonNull @Initialized Boolean> item(@UnknownKeyFor @NonNull @Initialized String key, @Nullable @UnknownKeyFor @Initialized Boolean value) {
        return DisplayData.item(key, Type.BOOLEAN, value);
    }

    public static @UnknownKeyFor @NonNull @Initialized ItemSpec<@UnknownKeyFor @NonNull @Initialized Instant> item(@UnknownKeyFor @NonNull @Initialized String key, @Nullable @UnknownKeyFor @Initialized Instant value) {
        return DisplayData.item(key, Type.TIMESTAMP, value);
    }

    public static @UnknownKeyFor @NonNull @Initialized ItemSpec<@UnknownKeyFor @NonNull @Initialized Duration> item(@UnknownKeyFor @NonNull @Initialized String key, @Nullable @UnknownKeyFor @Initialized Duration value) {
        return DisplayData.item(key, Type.DURATION, value);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized ItemSpec<@UnknownKeyFor @NonNull @Initialized Class<T>> item(@UnknownKeyFor @NonNull @Initialized String key, @Nullable @UnknownKeyFor @Initialized Class<T> value) {
        return DisplayData.item(key, Type.JAVA_CLASS, value);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized ItemSpec<T> item(@UnknownKeyFor @NonNull @Initialized String key, @UnknownKeyFor @NonNull @Initialized Type type, @Nullable T value) {
        Preconditions.checkNotNull((Object)key, (Object)"key argument cannot be null");
        Preconditions.checkNotNull((Object)((Object)type), (Object)"type argument cannot be null");
        return ItemSpec.create(key, type, value);
    }

    private static class InternalBuilder
    implements Builder {
        private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Identifier, @UnknownKeyFor @NonNull @Initialized Item> entries = Maps.newHashMap();
        private final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized HasDisplayData> visitedComponents = Sets.newIdentityHashSet();
        private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Path, @UnknownKeyFor @NonNull @Initialized HasDisplayData> visitedPathMap = Maps.newHashMap();
        private @Nullable @UnknownKeyFor @Initialized Path latestPath;
        private /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @Nullable @UnknownKeyFor @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> latestNs;

        private InternalBuilder() {
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Builder include(@UnknownKeyFor @NonNull @Initialized String path, @UnknownKeyFor @NonNull @Initialized HasDisplayData subComponent) {
            Preconditions.checkNotNull((Object)subComponent, (Object)"subComponent argument cannot be null");
            Preconditions.checkNotNull((Object)path, (Object)"path argument cannot be null");
            Path absolutePath = this.latestPath.extend(path);
            HasDisplayData existingComponent = this.visitedPathMap.get(absolutePath);
            if (existingComponent != null) {
                throw new IllegalArgumentException(String.format("Specified path '%s' already used for subcomponent %s. Subcomponents must be included using unique paths.", path, existingComponent));
            }
            return this.include(absolutePath, subComponent);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Builder delegate(@UnknownKeyFor @NonNull @Initialized HasDisplayData component) {
            Preconditions.checkNotNull((Object)component);
            return this.include(this.latestPath, component);
        }

        private @UnknownKeyFor @NonNull @Initialized Builder include(@UnknownKeyFor @NonNull @Initialized Path path, @UnknownKeyFor @NonNull @Initialized HasDisplayData subComponent) {
            if (this.visitedComponents.contains(subComponent)) {
                return this;
            }
            this.visitedComponents.add(subComponent);
            this.visitedPathMap.put(path, subComponent);
            Class<?> namespace = subComponent.getClass();
            if (namespace.getSimpleName().startsWith("AutoValue_")) {
                namespace = namespace.getSuperclass();
            }
            if (namespace.isSynthetic() && namespace.getSimpleName().contains("$$Lambda")) {
                try {
                    String className = namespace.getCanonicalName();
                    if (className == null) {
                        className = namespace.getName();
                    }
                    namespace = Class.forName(className.replaceFirst("\\$\\$Lambda.*", ""));
                }
                catch (Exception e) {
                    throw new PopulateDisplayDataException("Failed to get the enclosing class of lambda " + subComponent, e);
                }
            }
            Path prevPath = this.latestPath;
            Class<?> prevNs = this.latestNs;
            this.latestPath = path;
            this.latestNs = namespace;
            try {
                subComponent.populateDisplayData(this);
            }
            catch (PopulateDisplayDataException e) {
                throw e;
            }
            catch (Throwable e) {
                String msg = String.format("Error while populating display data for component '%s': %s", namespace.getName(), e.getMessage());
                throw new PopulateDisplayDataException(msg, e);
            }
            this.latestPath = prevPath;
            this.latestNs = prevNs;
            return this;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Builder add(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized ItemSpec<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> item) {
            Preconditions.checkNotNull(item, (Object)"Input display item cannot be null");
            return this.addItemIf(true, item);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Builder addIfNotNull(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized ItemSpec<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> item) {
            Preconditions.checkNotNull(item, (Object)"Input display item cannot be null");
            return this.addItemIf(item.getValue() != null, item);
        }

        @Override
        public <T> @UnknownKeyFor @NonNull @Initialized Builder addIfNotDefault(@UnknownKeyFor @NonNull @Initialized ItemSpec<T> item, @Nullable T defaultValue) {
            Preconditions.checkNotNull(item, (Object)"Input display item cannot be null");
            ItemSpec defaultItem = ((ItemSpec)item).withValue(defaultValue);
            return this.addItemIf(!Objects.equals(item, defaultItem), item);
        }

        private @UnknownKeyFor @NonNull @Initialized Builder addItemIf(@UnknownKeyFor @NonNull @Initialized boolean condition, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized ItemSpec<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> spec) {
            Item item;
            Identifier id;
            if (!condition) {
                return this;
            }
            Preconditions.checkNotNull(spec, (Object)"Input display item cannot be null");
            Preconditions.checkNotNull((Object)spec.getValue(), (Object)"Input display value cannot be null");
            if (spec.getNamespace() == null) {
                spec = spec.withNamespace(this.latestNs);
            }
            Preconditions.checkArgument((!this.entries.containsKey(id = Identifier.of((item = Item.create(spec, this.latestPath)).getPath(), item.getNamespace(), item.getKey())) ? 1 : 0) != 0, (String)"Display data key (%s) is not unique within the specified path and namespace: %s%s.", (Object)item.getKey(), (Object)item.getPath(), item.getNamespace());
            this.entries.put(id, item);
            return this;
        }

        private @UnknownKeyFor @NonNull @Initialized DisplayData build() {
            return new DisplayData(this.entries);
        }

        private static class PopulateDisplayDataException
        extends RuntimeException {
            PopulateDisplayDataException(@UnknownKeyFor @NonNull @Initialized String message, @UnknownKeyFor @NonNull @Initialized Throwable cause) {
                super(message, cause);
            }
        }
    }

    static class FormattedItemValue {
        private static final @UnknownKeyFor @NonNull @Initialized FormattedItemValue NULL_VALUES = new FormattedItemValue(null);
        private final @Nullable @UnknownKeyFor @Initialized Object shortValue;
        private final @Nullable @UnknownKeyFor @Initialized Object longValue;

        private FormattedItemValue(@Nullable @UnknownKeyFor @Initialized Object longValue) {
            this(longValue, (Object)null);
        }

        private FormattedItemValue(@Nullable @UnknownKeyFor @Initialized Object longValue, @Nullable @UnknownKeyFor @Initialized Object shortValue) {
            this.longValue = longValue;
            this.shortValue = shortValue;
        }

        @UnknownKeyFor @NonNull @Initialized Object getLongValue() {
            return this.longValue;
        }

        @UnknownKeyFor @NonNull @Initialized Object getShortValue() {
            return this.shortValue;
        }
    }

    public static enum Type {
        STRING{

            @Override
            @UnknownKeyFor @NonNull @Initialized FormattedItemValue format(@UnknownKeyFor @NonNull @Initialized Object value) {
                return new FormattedItemValue(Type.checkType(value, String.class, 1.STRING));
            }
        }
        ,
        INTEGER{

            @Override
            @UnknownKeyFor @NonNull @Initialized FormattedItemValue format(@UnknownKeyFor @NonNull @Initialized Object value) {
                if (value instanceof Integer) {
                    long l = ((Integer)value).longValue();
                    return this.format(l);
                }
                return new FormattedItemValue(Type.checkType(value, Long.class, 2.INTEGER));
            }
        }
        ,
        FLOAT{

            @Override
            @UnknownKeyFor @NonNull @Initialized FormattedItemValue format(@UnknownKeyFor @NonNull @Initialized Object value) {
                return new FormattedItemValue(Type.checkType(value, Number.class, 3.FLOAT));
            }
        }
        ,
        BOOLEAN{

            @Override
            @UnknownKeyFor @NonNull @Initialized FormattedItemValue format(@UnknownKeyFor @NonNull @Initialized Object value) {
                return new FormattedItemValue(Type.checkType(value, Boolean.class, 4.BOOLEAN));
            }
        }
        ,
        TIMESTAMP{

            @Override
            @UnknownKeyFor @NonNull @Initialized FormattedItemValue format(@UnknownKeyFor @NonNull @Initialized Object value) {
                Instant instant = (Instant)Type.checkType(value, Instant.class, 5.TIMESTAMP);
                return new FormattedItemValue((Object)TIMESTAMP_FORMATTER.print((ReadableInstant)instant));
            }
        }
        ,
        DURATION{

            @Override
            @UnknownKeyFor @NonNull @Initialized FormattedItemValue format(@UnknownKeyFor @NonNull @Initialized Object value) {
                Duration duration = (Duration)Type.checkType(value, Duration.class, 6.DURATION);
                return new FormattedItemValue((Object)duration.getMillis());
            }
        }
        ,
        JAVA_CLASS{

            @Override
            @UnknownKeyFor @NonNull @Initialized FormattedItemValue format(@UnknownKeyFor @NonNull @Initialized Object value) {
                Class clazz = (Class)Type.checkType(value, Class.class, 7.JAVA_CLASS);
                return new FormattedItemValue(clazz.getName(), clazz.getSimpleName());
            }
        };


        private static <T> T checkType(@UnknownKeyFor @NonNull @Initialized Object value, @UnknownKeyFor @NonNull @Initialized Class<T> clazz, @UnknownKeyFor @NonNull @Initialized Type expectedType) {
            if (!clazz.isAssignableFrom(value.getClass())) {
                throw new ClassCastException(String.format("Value is not valid for DisplayData type %s: %s", new Object[]{expectedType, value}));
            }
            Object typedValue = value;
            return (T)typedValue;
        }

        abstract @UnknownKeyFor @NonNull @Initialized FormattedItemValue format(@UnknownKeyFor @NonNull @Initialized Object var1);

        @UnknownKeyFor @NonNull @Initialized FormattedItemValue safeFormat(@Nullable @UnknownKeyFor @Initialized Object value) {
            if (value == null) {
                return FormattedItemValue.NULL_VALUES;
            }
            return this.format(value);
        }

        private static @Nullable @UnknownKeyFor @Initialized Type tryInferFrom(@Nullable @UnknownKeyFor @Initialized Object value) {
            if (value instanceof Integer || value instanceof Long) {
                return INTEGER;
            }
            if (value instanceof Double || value instanceof Float) {
                return FLOAT;
            }
            if (value instanceof Boolean) {
                return BOOLEAN;
            }
            if (value instanceof Instant) {
                return TIMESTAMP;
            }
            if (value instanceof Duration) {
                return DURATION;
            }
            if (value instanceof Class) {
                return JAVA_CLASS;
            }
            if (value instanceof String) {
                return STRING;
            }
            return null;
        }
    }

    public static class Path
    implements Serializable {
        private final @UnknownKeyFor @NonNull @Initialized ImmutableList<@UnknownKeyFor @NonNull @Initialized String> components;

        private Path(@UnknownKeyFor @NonNull @Initialized ImmutableList<@UnknownKeyFor @NonNull @Initialized String> components) {
            this.components = components;
        }

        public static @UnknownKeyFor @NonNull @Initialized Path root() {
            return new Path((ImmutableList<String>)ImmutableList.of());
        }

        public static @UnknownKeyFor @NonNull @Initialized Path absolute(@UnknownKeyFor @NonNull @Initialized String firstPath, String ... paths) {
            ImmutableList.Builder builder = ImmutableList.builder();
            Path.validatePathElement(firstPath);
            builder.add((Object)firstPath);
            for (String path : paths) {
                Path.validatePathElement(path);
                builder.add((Object)path);
            }
            return new Path((ImmutableList<String>)builder.build());
        }

        public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> getComponents() {
            return this.components;
        }

        public @UnknownKeyFor @NonNull @Initialized Path extend(@UnknownKeyFor @NonNull @Initialized String path) {
            Path.validatePathElement(path);
            return new Path((ImmutableList<String>)ImmutableList.builder().addAll((Iterator)this.components.iterator()).add((Object)path).build());
        }

        private static void validatePathElement(@UnknownKeyFor @NonNull @Initialized String path) {
            Preconditions.checkNotNull((Object)path);
            Preconditions.checkArgument((!"".equals(path) ? 1 : 0) != 0, (Object)"path cannot be empty");
        }

        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            StringBuilder b = new StringBuilder().append("[");
            Joiner.on((String)"/").appendTo(b, this.components);
            b.append("]");
            return b.toString();
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object obj) {
            return obj instanceof Path && Objects.equals(this.components, ((Path)obj).components);
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return this.components.hashCode();
        }
    }

    @AutoValue
    public static abstract class Identifier
    implements Serializable {
        public abstract @UnknownKeyFor @NonNull @Initialized Path getPath();

        public abstract /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> getNamespace();

        public abstract @UnknownKeyFor @NonNull @Initialized String getKey();

        public static @UnknownKeyFor @NonNull @Initialized Identifier of(@UnknownKeyFor @NonNull @Initialized Path path, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> namespace, @UnknownKeyFor @NonNull @Initialized String key) {
            return new AutoValue_DisplayData_Identifier(path, namespace, key);
        }

        @SideEffectFree
        public final @UnknownKeyFor @NonNull @Initialized String toString() {
            return String.format("%s%s:%s", this.getPath(), this.getNamespace(), this.getKey());
        }
    }

    @AutoValue
    public static abstract class ItemSpec<@UnknownKeyFor T>
    implements Serializable {
        public abstract /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @Nullable @UnknownKeyFor @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> getNamespace();

        public abstract @UnknownKeyFor @NonNull @Initialized String getKey();

        public abstract @UnknownKeyFor @NonNull @Initialized Type getType();

        public abstract @Nullable @UnknownKeyFor @Initialized Object getValue();

        public abstract @Nullable @UnknownKeyFor @Initialized Object getShortValue();

        public abstract @Nullable @UnknownKeyFor @Initialized String getLabel();

        public abstract @Nullable @UnknownKeyFor @Initialized String getLinkUrl();

        private static <T> @UnknownKeyFor @NonNull @Initialized ItemSpec<T> create(@UnknownKeyFor @NonNull @Initialized String key, @UnknownKeyFor @NonNull @Initialized Type type, @Nullable T value) {
            return ItemSpec.builder().setKey(key).setType(type).setRawValue(value).build();
        }

        public @UnknownKeyFor @NonNull @Initialized ItemSpec<T> withNamespace(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> namespace) {
            Preconditions.checkNotNull(namespace, (Object)"namespace argument cannot be null");
            return this.toBuilder().setNamespace(namespace).build();
        }

        public @UnknownKeyFor @NonNull @Initialized ItemSpec<T> withLabel(@Nullable @UnknownKeyFor @Initialized String label) {
            return this.toBuilder().setLabel(label).build();
        }

        public @UnknownKeyFor @NonNull @Initialized ItemSpec<T> withLinkUrl(@Nullable @UnknownKeyFor @Initialized String url) {
            return this.toBuilder().setLinkUrl(url).build();
        }

        private @UnknownKeyFor @NonNull @Initialized ItemSpec<T> withValue(T value) {
            return this.toBuilder().setRawValue(value).build();
        }

        @SideEffectFree
        public final @UnknownKeyFor @NonNull @Initialized String toString() {
            return String.format("%s:%s=%s", this.getNamespace(), this.getKey(), this.getValue());
        }

        static <T> @UnknownKeyFor @NonNull @Initialized Builder<T> builder() {
            return new AutoValue_DisplayData_ItemSpec.Builder();
        }

        abstract @UnknownKeyFor @NonNull @Initialized Builder<T> toBuilder();

        @AutoValue.Builder
        static abstract class Builder<@UnknownKeyFor T> {
            Builder() {
            }

            public abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setKey(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setNamespace(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            @Nullable @UnknownKeyFor @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setType(@UnknownKeyFor @NonNull @Initialized Type var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setValue(@Nullable @UnknownKeyFor @Initialized Object var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setShortValue(@Nullable @UnknownKeyFor @Initialized Object var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setLabel(@Nullable @UnknownKeyFor @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setLinkUrl(@Nullable @UnknownKeyFor @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized ItemSpec<T> build();

            abstract @UnknownKeyFor @NonNull @Initialized Type getType();

            @UnknownKeyFor @NonNull @Initialized Builder<T> setRawValue(@Nullable T value) {
                FormattedItemValue formatted = this.getType().safeFormat(value);
                return this.setValue(formatted.getLongValue()).setShortValue(formatted.getShortValue());
            }
        }
    }

    @AutoValue
    public static abstract class Item
    implements Serializable {
        @JsonIgnore
        public abstract @Nullable @UnknownKeyFor @Initialized Path getPath();

        @JsonGetter(value="namespace")
        public abstract /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @Nullable @UnknownKeyFor @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> getNamespace();

        @JsonGetter(value="key")
        public abstract @UnknownKeyFor @NonNull @Initialized String getKey();

        @JsonGetter(value="type")
        public abstract @UnknownKeyFor @NonNull @Initialized Type getType();

        @JsonGetter(value="value")
        public abstract @Nullable @UnknownKeyFor @Initialized Object getValue();

        @JsonGetter(value="shortValue")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public abstract @Nullable @UnknownKeyFor @Initialized Object getShortValue();

        @JsonGetter(value="label")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public abstract @Nullable @UnknownKeyFor @Initialized String getLabel();

        @JsonGetter(value="linkUrl")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public abstract @Nullable @UnknownKeyFor @Initialized String getLinkUrl();

        private static @UnknownKeyFor @NonNull @Initialized Item create(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized ItemSpec<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> spec, @UnknownKeyFor @NonNull @Initialized Path path) {
            Preconditions.checkNotNull(spec, (Object)"spec cannot be null");
            Preconditions.checkNotNull((Object)path, (Object)"path cannot be null");
            Class ns = (Class)Preconditions.checkNotNull(spec.getNamespace(), (Object)"namespace must be set");
            return new AutoValue_DisplayData_Item(path, ns, spec.getKey(), spec.getType(), spec.getValue(), spec.getShortValue(), spec.getLabel(), spec.getLinkUrl());
        }

        @SideEffectFree
        public final @UnknownKeyFor @NonNull @Initialized String toString() {
            return String.format("%s%s:%s=%s", this.getPath(), this.getNamespace().getName(), this.getKey(), this.getValue());
        }
    }

    public static interface Builder {
        public @UnknownKeyFor @NonNull @Initialized Builder include(@UnknownKeyFor @NonNull @Initialized String var1, @UnknownKeyFor @NonNull @Initialized HasDisplayData var2);

        public @UnknownKeyFor @NonNull @Initialized Builder delegate(@UnknownKeyFor @NonNull @Initialized HasDisplayData var1);

        public @UnknownKeyFor @NonNull @Initialized Builder add(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized ItemSpec<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> var1);

        public @UnknownKeyFor @NonNull @Initialized Builder addIfNotNull(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized ItemSpec<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> var1);

        public <T> @UnknownKeyFor @NonNull @Initialized Builder addIfNotDefault(@UnknownKeyFor @NonNull @Initialized ItemSpec<T> var1, @Nullable T var2);
    }
}

