/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.beam.runners.core.Concatenate;
import org.apache.beam.runners.core.construction.CreatePCollectionViewTranslation;
import org.apache.beam.runners.core.construction.PTransformTranslation;
import org.apache.beam.runners.core.construction.ParDoTranslation;
import org.apache.beam.runners.core.construction.ReadTranslation;
import org.apache.beam.runners.flink.FlinkBatchPipelineTranslator;
import org.apache.beam.runners.flink.FlinkBatchTranslationContext;
import org.apache.beam.runners.flink.FlinkPipelineOptions;
import org.apache.beam.runners.flink.translation.functions.FlinkAssignWindows;
import org.apache.beam.runners.flink.translation.functions.FlinkDoFnFunction;
import org.apache.beam.runners.flink.translation.functions.FlinkExplodeWindowsFunction;
import org.apache.beam.runners.flink.translation.functions.FlinkIdentityFunction;
import org.apache.beam.runners.flink.translation.functions.FlinkMergingNonShuffleReduceFunction;
import org.apache.beam.runners.flink.translation.functions.FlinkMultiOutputPruningFunction;
import org.apache.beam.runners.flink.translation.functions.FlinkNonMergingReduceFunction;
import org.apache.beam.runners.flink.translation.functions.FlinkPartialReduceFunction;
import org.apache.beam.runners.flink.translation.functions.FlinkReduceFunction;
import org.apache.beam.runners.flink.translation.functions.FlinkStatefulDoFnFunction;
import org.apache.beam.runners.flink.translation.types.CoderTypeInformation;
import org.apache.beam.runners.flink.translation.types.KvKeySelector;
import org.apache.beam.runners.flink.translation.types.WindowedKvKeySelector;
import org.apache.beam.runners.flink.translation.wrappers.ImpulseInputFormat;
import org.apache.beam.runners.flink.translation.wrappers.SourceInputFormat;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.IterableCoder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.VoidCoder;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.CombineFnBase;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.DoFnSchemaInformation;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.Reshuffle;
import org.apache.beam.sdk.transforms.join.RawUnionValue;
import org.apache.beam.sdk.transforms.join.UnionCoder;
import org.apache.beam.sdk.transforms.reflect.DoFnSignature;
import org.apache.beam.sdk.transforms.reflect.DoFnSignatures;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.transforms.windowing.TimestampCombiner;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Maps;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Multimap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.MultimapBuilder;
import org.apache.flink.api.common.functions.FilterFunction;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.api.common.operators.Order;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.operators.FlatMapOperator;
import org.apache.flink.api.java.operators.GroupCombineOperator;
import org.apache.flink.api.java.operators.GroupReduceOperator;
import org.apache.flink.api.java.operators.Grouping;
import org.apache.flink.api.java.operators.MapOperator;
import org.apache.flink.api.java.operators.SingleInputUdfOperator;
import org.apache.flink.api.java.operators.UnionOperator;
import org.apache.flink.api.java.operators.UnsortedGrouping;
import org.apache.flink.configuration.Configuration;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;

class FlinkBatchTransformTranslators {
    private static final @UnknownKeyFor @NonNull @Initialized Multimap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized FlinkBatchPipelineTranslator.BatchTransformTranslator> TRANSLATORS = MultimapBuilder.hashKeys().arrayListValues().build();

    FlinkBatchTransformTranslators() {
    }

    static /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized FlinkBatchPipelineTranslator.BatchTransformTranslator<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> getTranslator(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> transform, @UnknownKeyFor @NonNull @Initialized FlinkBatchTranslationContext context) {
        @Nullable String urn = PTransformTranslation.urnForTransformOrNull(transform);
        if (urn != null && TRANSLATORS.containsKey((Object)urn)) {
            for (FlinkBatchPipelineTranslator.BatchTransformTranslator translator : TRANSLATORS.get((Object)urn)) {
                if (!translator.canTranslate(transform, context)) continue;
                return translator;
            }
        }
        return null;
    }

    private static @UnknownKeyFor @NonNull @Initialized String getCurrentTransformName(@UnknownKeyFor @NonNull @Initialized FlinkBatchTranslationContext context) {
        return context.getCurrentTransform().getFullName();
    }

    private static void transformSideInputs(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> sideInputs, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized SingleInputUdfOperator<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> outputDataSet, @UnknownKeyFor @NonNull @Initialized FlinkBatchTranslationContext context) {
        for (PCollectionView<?> input : sideInputs) {
            DataSet broadcastSet = context.getSideInputDataSet(input);
            outputDataSet.withBroadcastSet(broadcastSet, input.getTagInternal().getId());
        }
    }

    static {
        TRANSLATORS.put((Object)"beam:transform:impulse:v1", (Object)new ImpulseTranslatorBatch());
        TRANSLATORS.put((Object)"beam:transform:create_view:v1", new CreatePCollectionViewTranslatorBatch());
        TRANSLATORS.put((Object)"beam:transform:combine_per_key:v1", new CombinePerKeyTranslatorBatch());
        TRANSLATORS.put((Object)"beam:transform:group_by_key:v1", new NonMergingGroupByKeyTranslatorBatch());
        TRANSLATORS.put((Object)"beam:transform:group_by_key:v1", new GroupByKeyTranslatorBatch());
        TRANSLATORS.put((Object)"beam:transform:reshuffle:v1", new ReshuffleTranslatorBatch());
        TRANSLATORS.put((Object)"beam:transform:flatten:v1", new FlattenPCollectionTranslatorBatch());
        TRANSLATORS.put((Object)"beam:transform:window_into:v1", new WindowAssignTranslatorBatch());
        TRANSLATORS.put((Object)"beam:transform:pardo:v1", new ParDoTranslatorBatch());
        TRANSLATORS.put((Object)"beam:transform:read:v1", new ReadSourceTranslatorBatch());
    }

    private static class CreatePCollectionViewTranslatorBatch<@UnknownKeyFor ElemT, @UnknownKeyFor ViewT>
    implements FlinkBatchPipelineTranslator.BatchTransformTranslator<PTransform<PCollection<ElemT>, PCollection<ElemT>>> {
        private CreatePCollectionViewTranslatorBatch() {
        }

        @Override
        public void translateNode(@UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<ElemT>, @UnknownKeyFor @NonNull @Initialized PCollection<ElemT>> transform, @UnknownKeyFor @NonNull @Initialized FlinkBatchTranslationContext context) {
            PCollectionView input;
            DataSet inputDataSet = context.getInputDataSet((PValue)context.getInput(transform));
            AppliedPTransform<?, ?, ?> application = context.getCurrentTransform();
            try {
                input = CreatePCollectionViewTranslation.getView(application);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            context.setSideInputDataSet(input, inputDataSet);
        }
    }

    private static class FlattenPCollectionTranslatorBatch<@UnknownKeyFor T>
    implements FlinkBatchPipelineTranslator.BatchTransformTranslator<PTransform<PCollectionList<T>, PCollection<T>>> {
        private FlattenPCollectionTranslatorBatch() {
        }

        @Override
        public void translateNode(@UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollectionList<T>, @UnknownKeyFor @NonNull @Initialized PCollection<T>> transform, @UnknownKeyFor @NonNull @Initialized FlinkBatchTranslationContext context) {
            Map<TupleTag<?>, PCollection<?>> allInputs = context.getInputs(transform);
            UnionOperator result = null;
            if (allInputs.isEmpty()) {
                DataSource dummySource = context.getExecutionEnvironment().fromElements((Object[])new String[]{"dummy"});
                result = dummySource.flatMap((FlatMapFunction & Serializable)(s, collector) -> {}).returns(new CoderTypeInformation(WindowedValue.getFullCoder((Coder)VoidCoder.of(), (Coder)GlobalWindow.Coder.INSTANCE), context.getPipelineOptions()));
            } else {
                for (PValue pValue : allInputs.values()) {
                    Preconditions.checkArgument((boolean)(pValue instanceof PCollection), (String)"Got non-PCollection input to flatten: %s of type %s", (Object)pValue, (Object)pValue.getClass().getSimpleName());
                    PCollection collection = (PCollection)pValue;
                    UnionOperator current = context.getInputDataSet((PValue)collection);
                    if (result == null) {
                        result = current;
                        continue;
                    }
                    result = result.union(current);
                }
            }
            result = result.filter((FilterFunction & Serializable)tWindowedValue -> true).name("UnionFixFilter");
            context.setOutputDataSet((PValue)context.getOutput(transform), result);
        }
    }

    private static class KeyWithValueTimestampSelector<@UnknownKeyFor K, @UnknownKeyFor V>
    implements KeySelector<WindowedValue<KV<K, V>>, Instant> {
        private KeyWithValueTimestampSelector() {
        }

        public @UnknownKeyFor @NonNull @Initialized Instant getKey(@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized KV<K, V>> in) throws @UnknownKeyFor @NonNull @Initialized Exception {
            return in.getTimestamp();
        }
    }

    private static class ParDoTranslatorBatch<@UnknownKeyFor InputT, @UnknownKeyFor OutputT>
    implements FlinkBatchPipelineTranslator.BatchTransformTranslator<PTransform<PCollection<InputT>, PCollectionTuple>> {
        private ParDoTranslatorBatch() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void translateNode(@UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<InputT>, @UnknownKeyFor @NonNull @Initialized PCollectionTuple> transform, @UnknownKeyFor @NonNull @Initialized FlinkBatchTranslationContext context) {
            FlatMapOperator outputDataSet;
            boolean usesStateOrTimers;
            List sideInputs;
            void var13_18;
            TupleTag mainOutputTag;
            DoFn doFn;
            try {
                doFn = ParDoTranslation.getDoFn(context.getCurrentTransform());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            DoFnSignature signature = DoFnSignatures.signatureForDoFn((DoFn)doFn);
            Preconditions.checkState((!signature.processElement().isSplittable() ? 1 : 0) != 0, (String)"Not expected to directly translate splittable DoFn, should have been overridden: %s", (Object)doFn);
            DataSet inputDataSet = context.getInputDataSet((PValue)context.getInput(transform));
            Map<TupleTag<?>, PCollection<?>> outputs = context.getOutputs(transform);
            try {
                mainOutputTag = ParDoTranslation.getMainOutputTag(context.getCurrentTransform());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            DoFnSchemaInformation doFnSchemaInformation = ParDoTranslation.getSchemaInformation(context.getCurrentTransform());
            Map sideInputMapping = ParDoTranslation.getSideInputMapping(context.getCurrentTransform());
            HashMap outputMap = Maps.newHashMap();
            outputMap.put(mainOutputTag, 0);
            int count = 1;
            for (TupleTag<?> tupleTag : outputs.keySet()) {
                if (outputMap.containsKey(tupleTag)) continue;
                outputMap.put(tupleTag, count++);
            }
            TreeMap indexMap = Maps.newTreeMap();
            for (Map.Entry entry : outputMap.entrySet()) {
                indexMap.put((Integer)entry.getValue(), (TupleTag)entry.getKey());
            }
            Object var13_17 = null;
            ArrayList arrayList = Lists.newArrayList();
            for (TupleTag tag : indexMap.values()) {
                PValue taggedValue = (PValue)outputs.get(tag);
                Preconditions.checkState((boolean)(taggedValue instanceof PCollection), (String)"Within ParDo, got a non-PCollection output %s of type %s", (Object)taggedValue, (Object)taggedValue.getClass().getSimpleName());
                PCollection coll = (PCollection)taggedValue;
                arrayList.add(coll.getCoder());
                WindowingStrategy windowingStrategy = coll.getWindowingStrategy();
            }
            if (var13_18 == null) {
                throw new IllegalStateException("No outputs defined.");
            }
            UnionCoder unionCoder = UnionCoder.of((List)arrayList);
            CoderTypeInformation typeInformation = new CoderTypeInformation(WindowedValue.getFullCoder((Coder)unionCoder, (Coder)var13_18.getWindowFn().windowCoder()), context.getPipelineOptions());
            try {
                sideInputs = ParDoTranslation.getSideInputs(context.getCurrentTransform());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            HashMap sideInputStrategies = new HashMap();
            for (PCollectionView sideInput : sideInputs) {
                sideInputStrategies.put(sideInput, sideInput.getWindowingStrategyInternal());
            }
            try {
                usesStateOrTimers = ParDoTranslation.usesStateOrTimers(context.getCurrentTransform());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            Map<TupleTag<?>, Coder<?>> outputCoderMap = context.getOutputCoders(transform);
            String fullName = FlinkBatchTransformTranslators.getCurrentTransformName(context);
            if (usesStateOrTimers) {
                KvCoder inputCoder = (KvCoder)context.getInput(transform).getCoder();
                FlinkStatefulDoFnFunction doFnWrapper = new FlinkStatefulDoFnFunction(doFn, fullName, (WindowingStrategy<?, ?>)var13_18, sideInputStrategies, context.getPipelineOptions(), outputMap, mainOutputTag, inputCoder, outputCoderMap, doFnSchemaInformation, sideInputMapping);
                Coder keyCoder = inputCoder.getKeyCoder();
                Object grouping = signature.processElement().requiresTimeSortedInput() ? inputDataSet.groupBy(new KvKeySelector(keyCoder)).sortGroup(new KeyWithValueTimestampSelector(), Order.ASCENDING) : inputDataSet.groupBy(new KvKeySelector(keyCoder));
                outputDataSet = new GroupReduceOperator((Grouping)grouping, typeInformation, doFnWrapper, fullName);
            } else {
                FlinkDoFnFunction doFnWrapper = new FlinkDoFnFunction(doFn, fullName, (WindowingStrategy<?, ?>)var13_18, sideInputStrategies, context.getPipelineOptions(), outputMap, mainOutputTag, context.getInput(transform).getCoder(), outputCoderMap, doFnSchemaInformation, sideInputMapping);
                outputDataSet = new FlatMapOperator(inputDataSet, typeInformation, doFnWrapper, fullName);
            }
            FlinkBatchTransformTranslators.transformSideInputs(sideInputs, (SingleInputUdfOperator)outputDataSet, context);
            for (Map.Entry<TupleTag<?>, PCollection<?>> output : outputs.entrySet()) {
                this.pruneOutput((DataSet<WindowedValue<RawUnionValue>>)outputDataSet, context, (Integer)outputMap.get(output.getKey()), output.getValue());
            }
        }

        private <T> void pruneOutput(@UnknownKeyFor @NonNull @Initialized DataSet<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized RawUnionValue>> taggedDataSet, @UnknownKeyFor @NonNull @Initialized FlinkBatchTranslationContext context, @UnknownKeyFor @NonNull @Initialized int integerTag, @UnknownKeyFor @NonNull @Initialized PCollection<T> collection) {
            TypeInformation<WindowedValue<T>> outputType = context.getTypeInfo(collection);
            FlinkMultiOutputPruningFunction pruningFunction = new FlinkMultiOutputPruningFunction(integerTag, context.getPipelineOptions());
            FlatMapOperator pruningOperator = new FlatMapOperator(taggedDataSet, outputType, pruningFunction, collection.getName());
            context.setOutputDataSet((PValue)collection, pruningOperator);
        }
    }

    private static class CombinePerKeyTranslatorBatch<@UnknownKeyFor K, @UnknownKeyFor InputT, @UnknownKeyFor AccumT, @UnknownKeyFor OutputT>
    implements FlinkBatchPipelineTranslator.BatchTransformTranslator<PTransform<PCollection<KV<K, InputT>>, PCollection<KV<K, OutputT>>>> {
        private CombinePerKeyTranslatorBatch() {
        }

        @Override
        public void translateNode(@UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, InputT>>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, OutputT>>> transform, @UnknownKeyFor @NonNull @Initialized FlinkBatchTranslationContext context) {
            Coder accumulatorCoder;
            DataSet inputDataSet = context.getInputDataSet((PValue)context.getInput(transform));
            Combine.PerKey combineTransform = (Combine.PerKey)transform;
            CombineFnBase.GlobalCombineFn combineFn = combineTransform.getFn();
            KvCoder inputCoder = (KvCoder)context.getInput(transform).getCoder();
            try {
                accumulatorCoder = combineFn.getAccumulatorCoder(context.getInput(transform).getPipeline().getCoderRegistry(), inputCoder.getValueCoder());
            }
            catch (CannotProvideCoderException e) {
                throw new RuntimeException(e);
            }
            WindowingStrategy windowingStrategy = context.getInput(transform).getWindowingStrategy();
            TypeInformation partialReduceTypeInfo = context.getTypeInfo(KvCoder.of((Coder)inputCoder.getKeyCoder(), (Coder)accumulatorCoder), (WindowingStrategy<?, ?>)windowingStrategy);
            boolean canGroupByWindow = windowingStrategy.getWindowFn().isNonMerging() && windowingStrategy.getWindowFn().windowCoder().consistentWithEquals();
            String fullName = FlinkBatchTransformTranslators.getCurrentTransformName(context);
            UnsortedGrouping inputGrouping = canGroupByWindow ? new FlatMapOperator(inputDataSet, inputDataSet.getType(), new FlinkExplodeWindowsFunction(), "ExplodeWindows: " + fullName).groupBy(new WindowedKvKeySelector(inputCoder.getKeyCoder(), (Coder<? extends BoundedWindow>)windowingStrategy.getWindowFn().windowCoder())) : inputDataSet.groupBy(new KvKeySelector(inputCoder.getKeyCoder()));
            HashMap sideInputStrategies = new HashMap();
            for (PCollectionView sideInput : combineTransform.getSideInputs()) {
                sideInputStrategies.put(sideInput, sideInput.getWindowingStrategyInternal());
            }
            if (!windowingStrategy.needsMerge()) {
                FlinkPartialReduceFunction partialReduceFunction = new FlinkPartialReduceFunction(combineFn, windowingStrategy, sideInputStrategies, context.getPipelineOptions(), canGroupByWindow);
                FlinkReduceFunction reduceFunction = new FlinkReduceFunction(combineFn, windowingStrategy, sideInputStrategies, context.getPipelineOptions(), canGroupByWindow);
                GroupCombineOperator groupCombine = new GroupCombineOperator((Grouping)inputGrouping, partialReduceTypeInfo, partialReduceFunction, "GroupCombine: " + fullName);
                FlinkBatchTransformTranslators.transformSideInputs(combineTransform.getSideInputs(), (SingleInputUdfOperator)groupCombine, context);
                TypeInformation<WindowedValue<KV<K, OutputT>>> reduceTypeInfo = context.getTypeInfo(context.getOutput(transform));
                UnsortedGrouping intermediateGrouping = canGroupByWindow ? groupCombine.groupBy(new WindowedKvKeySelector(inputCoder.getKeyCoder(), (Coder<? extends BoundedWindow>)windowingStrategy.getWindowFn().windowCoder())) : groupCombine.groupBy(new KvKeySelector(inputCoder.getKeyCoder()));
                GroupReduceOperator outputDataSet = new GroupReduceOperator((Grouping)intermediateGrouping, reduceTypeInfo, reduceFunction, fullName);
                FlinkBatchTransformTranslators.transformSideInputs(combineTransform.getSideInputs(), (SingleInputUdfOperator)outputDataSet, context);
                context.setOutputDataSet((PValue)context.getOutput(transform), outputDataSet);
            } else {
                FlinkMergingNonShuffleReduceFunction reduceFunction = new FlinkMergingNonShuffleReduceFunction(combineFn, windowingStrategy, sideInputStrategies, context.getPipelineOptions());
                TypeInformation<WindowedValue<KV<K, OutputT>>> reduceTypeInfo = context.getTypeInfo(context.getOutput(transform));
                UnsortedGrouping grouping = inputDataSet.groupBy(new KvKeySelector(inputCoder.getKeyCoder()));
                GroupReduceOperator outputDataSet = new GroupReduceOperator((Grouping)grouping, reduceTypeInfo, reduceFunction, fullName);
                FlinkBatchTransformTranslators.transformSideInputs(combineTransform.getSideInputs(), (SingleInputUdfOperator)outputDataSet, context);
                context.setOutputDataSet((PValue)context.getOutput(transform), outputDataSet);
            }
        }
    }

    private static class ReshuffleTranslatorBatch<@UnknownKeyFor K, @UnknownKeyFor InputT>
    implements FlinkBatchPipelineTranslator.BatchTransformTranslator<Reshuffle<K, InputT>> {
        private ReshuffleTranslatorBatch() {
        }

        @Override
        public void translateNode(@UnknownKeyFor @NonNull @Initialized Reshuffle<K, InputT> transform, @UnknownKeyFor @NonNull @Initialized FlinkBatchTranslationContext context) {
            DataSet inputDataSet = context.getInputDataSet((PValue)context.getInput(transform));
            CoderTypeInformation outputType = ((CoderTypeInformation)inputDataSet.getType()).withPipelineOptions(context.getPipelineOptions());
            MapOperator retypedDataSet = new MapOperator(inputDataSet, outputType, FlinkIdentityFunction.of(), FlinkBatchTransformTranslators.getCurrentTransformName(context));
            Configuration partitionOptions = new Configuration();
            partitionOptions.setString("INPUT_SHIP_STRATEGY", "SHIP_REPARTITION");
            context.setOutputDataSet((PValue)context.getOutput(transform), retypedDataSet.map(FlinkIdentityFunction.of()).withParameters(partitionOptions));
        }
    }

    private static class GroupByKeyTranslatorBatch<@UnknownKeyFor K, @UnknownKeyFor InputT>
    implements FlinkBatchPipelineTranslator.BatchTransformTranslator<PTransform<PCollection<KV<K, InputT>>, PCollection<KV<K, Iterable<InputT>>>>> {
        private GroupByKeyTranslatorBatch() {
        }

        @Override
        public void translateNode(@UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, InputT>>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized Iterable<InputT>>>> transform, @UnknownKeyFor @NonNull @Initialized FlinkBatchTranslationContext context) {
            Coder accumulatorCoder;
            DataSet inputDataSet = context.getInputDataSet((PValue)context.getInput(transform));
            Concatenate combineFn = new Concatenate();
            KvCoder inputCoder = (KvCoder)context.getInput(transform).getCoder();
            try {
                accumulatorCoder = combineFn.getAccumulatorCoder(context.getInput(transform).getPipeline().getCoderRegistry(), inputCoder.getValueCoder());
            }
            catch (CannotProvideCoderException e) {
                throw new RuntimeException(e);
            }
            WindowingStrategy windowingStrategy = context.getInput(transform).getWindowingStrategy();
            CoderTypeInformation partialReduceTypeInfo = new CoderTypeInformation(WindowedValue.getFullCoder((Coder)KvCoder.of((Coder)inputCoder.getKeyCoder(), (Coder)accumulatorCoder), (Coder)windowingStrategy.getWindowFn().windowCoder()), context.getPipelineOptions());
            UnsortedGrouping inputGrouping = inputDataSet.groupBy(new KvKeySelector(inputCoder.getKeyCoder()));
            WindowingStrategy boundedStrategy = windowingStrategy;
            FlinkPartialReduceFunction partialReduceFunction = new FlinkPartialReduceFunction(combineFn, boundedStrategy, Collections.emptyMap(), context.getPipelineOptions());
            FlinkReduceFunction reduceFunction = new FlinkReduceFunction(combineFn, boundedStrategy, Collections.emptyMap(), context.getPipelineOptions());
            String fullName = FlinkBatchTransformTranslators.getCurrentTransformName(context);
            GroupCombineOperator groupCombine = new GroupCombineOperator((Grouping)inputGrouping, partialReduceTypeInfo, partialReduceFunction, "GroupCombine: " + fullName);
            UnsortedGrouping intermediateGrouping = groupCombine.groupBy(new KvKeySelector(inputCoder.getKeyCoder()));
            GroupReduceOperator outputDataSet = new GroupReduceOperator((Grouping)intermediateGrouping, partialReduceTypeInfo, reduceFunction, fullName);
            context.setOutputDataSet((PValue)context.getOutput(transform), outputDataSet);
        }
    }

    private static class NonMergingGroupByKeyTranslatorBatch<@UnknownKeyFor K, @UnknownKeyFor InputT>
    implements FlinkBatchPipelineTranslator.BatchTransformTranslator<PTransform<PCollection<KV<K, InputT>>, PCollection<KV<K, Iterable<InputT>>>>> {
        private NonMergingGroupByKeyTranslatorBatch() {
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized boolean canTranslate(@UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, InputT>>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized Iterable<InputT>>>> transform, @UnknownKeyFor @NonNull @Initialized FlinkBatchTranslationContext context) {
            WindowingStrategy windowingStrategy = context.getInput(transform).getWindowingStrategy();
            return !windowingStrategy.needsMerge() && windowingStrategy.getTimestampCombiner() == TimestampCombiner.END_OF_WINDOW && windowingStrategy.getWindowFn().windowCoder().consistentWithEquals();
        }

        @Override
        public void translateNode(@UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, InputT>>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized Iterable<InputT>>>> transform, @UnknownKeyFor @NonNull @Initialized FlinkBatchTranslationContext context) {
            int numConsumers = context.getOutputs(transform).values().stream().mapToInt(context::getNumConsumers).sum();
            boolean multipleConsumers = numConsumers > 1;
            boolean reIterableResult = multipleConsumers || ((FlinkPipelineOptions)context.getPipelineOptions().as(FlinkPipelineOptions.class)).getReIterableGroupByKeyResult() != false;
            DataSet inputDataSet = context.getInputDataSet((PValue)context.getInput(transform));
            KvCoder inputCoder = (KvCoder)context.getInput(transform).getCoder();
            WindowingStrategy windowingStrategy = context.getInput(transform).getWindowingStrategy();
            String fullName = FlinkBatchTransformTranslators.getCurrentTransformName(context);
            UnsortedGrouping inputGrouping = new FlatMapOperator(inputDataSet, inputDataSet.getType(), new FlinkExplodeWindowsFunction(), "ExplodeWindows: " + fullName).groupBy(new WindowedKvKeySelector(inputCoder.getKeyCoder(), (Coder<? extends BoundedWindow>)windowingStrategy.getWindowFn().windowCoder()));
            CoderTypeInformation outputTypeInfo = new CoderTypeInformation(WindowedValue.getFullCoder((Coder)KvCoder.of((Coder)inputCoder.getKeyCoder(), (Coder)IterableCoder.of((Coder)inputCoder.getValueCoder())), (Coder)windowingStrategy.getWindowFn().windowCoder()), context.getPipelineOptions());
            SingleInputUdfOperator outputDataSet = new GroupReduceOperator((Grouping)inputGrouping, outputTypeInfo, new FlinkNonMergingReduceFunction(windowingStrategy, reIterableResult), fullName).returns(outputTypeInfo);
            context.setOutputDataSet((PValue)context.getOutput(transform), outputDataSet);
        }
    }

    private static class WindowAssignTranslatorBatch<@UnknownKeyFor T>
    implements FlinkBatchPipelineTranslator.BatchTransformTranslator<PTransform<PCollection<T>, PCollection<T>>> {
        private WindowAssignTranslatorBatch() {
        }

        @Override
        public void translateNode(@UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<T>, @UnknownKeyFor @NonNull @Initialized PCollection<T>> transform, @UnknownKeyFor @NonNull @Initialized FlinkBatchTranslationContext context) {
            PCollection<T> input = context.getInput(transform);
            TypeInformation<WindowedValue<T>> resultTypeInfo = context.getTypeInfo(context.getOutput(transform));
            DataSet inputDataSet = context.getInputDataSet((PValue)input);
            WindowingStrategy windowingStrategy = context.getOutput(transform).getWindowingStrategy();
            WindowFn windowFn = windowingStrategy.getWindowFn();
            FlinkAssignWindows assignWindowsFunction = new FlinkAssignWindows(windowFn);
            SingleInputUdfOperator resultDataSet = ((FlatMapOperator)inputDataSet.flatMap(assignWindowsFunction).name(context.getOutput(transform).getName())).returns(resultTypeInfo);
            context.setOutputDataSet((PValue)context.getOutput(transform), resultDataSet);
        }
    }

    private static class ReadSourceTranslatorBatch<@UnknownKeyFor T>
    implements FlinkBatchPipelineTranslator.BatchTransformTranslator<PTransform<PBegin, PCollection<T>>> {
        private ReadSourceTranslatorBatch() {
        }

        @Override
        public void translateNode(@UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PBegin, @UnknownKeyFor @NonNull @Initialized PCollection<T>> transform, @UnknownKeyFor @NonNull @Initialized FlinkBatchTranslationContext context) {
            BoundedSource source;
            AppliedPTransform<?, ?, ?> application = context.getCurrentTransform();
            try {
                source = ReadTranslation.boundedSourceFromTransform(application);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            PCollection<T> output = context.getOutput(transform);
            TypeInformation<WindowedValue<T>> typeInformation = context.getTypeInfo(output);
            String fullName = FlinkBatchTransformTranslators.getCurrentTransformName(context);
            DataSource dataSource = new DataSource(context.getExecutionEnvironment(), new SourceInputFormat(fullName, source, context.getPipelineOptions()), typeInformation, fullName);
            context.setOutputDataSet((PValue)output, dataSource);
        }
    }

    private static class ImpulseTranslatorBatch
    implements FlinkBatchPipelineTranslator.BatchTransformTranslator<PTransform<PBegin, PCollection<byte[]>>> {
        private ImpulseTranslatorBatch() {
        }

        @Override
        public void translateNode(@UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PBegin, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []>> transform, @UnknownKeyFor @NonNull @Initialized FlinkBatchTranslationContext context) {
            String name = transform.getName();
            PCollection<byte[]> output = context.getOutput(transform);
            TypeInformation<WindowedValue<byte[]>> typeInformation = context.getTypeInfo(output);
            DataSource dataSource = new DataSource(context.getExecutionEnvironment(), (InputFormat)new ImpulseInputFormat(), typeInformation, name);
            context.setOutputDataSet((PValue)output, dataSource);
        }
    }
}

