/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.core.data;

import com.datastax.oss.driver.api.core.data.AccessibleByName;
import com.datastax.oss.driver.api.core.data.CqlDuration;
import com.datastax.oss.driver.api.core.data.GettableByIndex;
import com.datastax.oss.driver.api.core.data.TupleValue;
import com.datastax.oss.driver.api.core.data.UdtValue;
import com.datastax.oss.driver.api.core.metadata.token.Token;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public interface GettableByName
extends GettableByIndex,
AccessibleByName {
    @Nullable
    default public ByteBuffer getBytesUnsafe(@NonNull String name) {
        return this.getBytesUnsafe(this.firstIndexOf(name));
    }

    default public boolean isNull(@NonNull String name) {
        return this.isNull(this.firstIndexOf(name));
    }

    @Nullable
    default public <ValueT> ValueT get(@NonNull String name, @NonNull TypeCodec<ValueT> codec) {
        return this.get(this.firstIndexOf(name), codec);
    }

    @Nullable
    default public <ValueT> ValueT get(@NonNull String name, @NonNull GenericType<ValueT> targetType) {
        return this.get(this.firstIndexOf(name), targetType);
    }

    @Nullable
    default public <ValueT> ValueT get(@NonNull String name, @NonNull Class<ValueT> targetClass) {
        return this.get(this.firstIndexOf(name), targetClass);
    }

    @Nullable
    default public Object getObject(@NonNull String name) {
        return this.getObject(this.firstIndexOf(name));
    }

    default public boolean getBoolean(@NonNull String name) {
        return this.getBoolean(this.firstIndexOf(name));
    }

    @Deprecated
    default public boolean getBool(@NonNull String name) {
        return this.getBoolean(name);
    }

    default public byte getByte(@NonNull String name) {
        return this.getByte(this.firstIndexOf(name));
    }

    default public double getDouble(@NonNull String name) {
        return this.getDouble(this.firstIndexOf(name));
    }

    default public float getFloat(@NonNull String name) {
        return this.getFloat(this.firstIndexOf(name));
    }

    default public int getInt(@NonNull String name) {
        return this.getInt(this.firstIndexOf(name));
    }

    default public long getLong(@NonNull String name) {
        return this.getLong(this.firstIndexOf(name));
    }

    default public short getShort(@NonNull String name) {
        return this.getShort(this.firstIndexOf(name));
    }

    @Nullable
    default public Instant getInstant(@NonNull String name) {
        return this.getInstant(this.firstIndexOf(name));
    }

    @Nullable
    default public LocalDate getLocalDate(@NonNull String name) {
        return this.getLocalDate(this.firstIndexOf(name));
    }

    @Nullable
    default public LocalTime getLocalTime(@NonNull String name) {
        return this.getLocalTime(this.firstIndexOf(name));
    }

    @Nullable
    default public ByteBuffer getByteBuffer(@NonNull String name) {
        return this.getByteBuffer(this.firstIndexOf(name));
    }

    @Nullable
    default public String getString(@NonNull String name) {
        return this.getString(this.firstIndexOf(name));
    }

    @Nullable
    default public BigInteger getBigInteger(@NonNull String name) {
        return this.getBigInteger(this.firstIndexOf(name));
    }

    @Nullable
    default public BigDecimal getBigDecimal(@NonNull String name) {
        return this.getBigDecimal(this.firstIndexOf(name));
    }

    @Nullable
    default public UUID getUuid(@NonNull String name) {
        return this.getUuid(this.firstIndexOf(name));
    }

    @Nullable
    default public InetAddress getInetAddress(@NonNull String name) {
        return this.getInetAddress(this.firstIndexOf(name));
    }

    @Nullable
    default public CqlDuration getCqlDuration(@NonNull String name) {
        return this.getCqlDuration(this.firstIndexOf(name));
    }

    @Nullable
    default public Token getToken(@NonNull String name) {
        return this.getToken(this.firstIndexOf(name));
    }

    @Nullable
    default public <ElementT> List<ElementT> getList(@NonNull String name, @NonNull Class<ElementT> elementsClass) {
        return this.getList(this.firstIndexOf(name), elementsClass);
    }

    @Nullable
    default public <ElementT> Set<ElementT> getSet(@NonNull String name, @NonNull Class<ElementT> elementsClass) {
        return this.getSet(this.firstIndexOf(name), elementsClass);
    }

    @Nullable
    default public <KeyT, ValueT> Map<KeyT, ValueT> getMap(@NonNull String name, @NonNull Class<KeyT> keyClass, @NonNull Class<ValueT> valueClass) {
        return this.getMap(this.firstIndexOf(name), keyClass, valueClass);
    }

    @Nullable
    default public UdtValue getUdtValue(@NonNull String name) {
        return this.getUdtValue(this.firstIndexOf(name));
    }

    @Nullable
    default public TupleValue getTupleValue(@NonNull String name) {
        return this.getTupleValue(this.firstIndexOf(name));
    }
}

