/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.translation;

import com.google.auto.service.AutoService;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.core.SystemReduceFn;
import org.apache.beam.runners.core.construction.NativeTransforms;
import org.apache.beam.runners.core.construction.PTransformTranslation;
import org.apache.beam.runners.core.construction.graph.PipelineNode;
import org.apache.beam.runners.core.construction.graph.QueryablePipeline;
import org.apache.beam.runners.fnexecution.provisioning.JobInfo;
import org.apache.beam.runners.fnexecution.translation.PipelineTranslatorUtils;
import org.apache.beam.runners.spark.SparkPipelineOptions;
import org.apache.beam.runners.spark.metrics.MetricsAccumulator;
import org.apache.beam.runners.spark.translation.BoundedDataset;
import org.apache.beam.runners.spark.translation.Dataset;
import org.apache.beam.runners.spark.translation.GroupCombineFunctions;
import org.apache.beam.runners.spark.translation.GroupNonMergingWindowsFunctions;
import org.apache.beam.runners.spark.translation.SparkExecutableStageContextFactory;
import org.apache.beam.runners.spark.translation.SparkExecutableStageExtractionFunction;
import org.apache.beam.runners.spark.translation.SparkExecutableStageFunction;
import org.apache.beam.runners.spark.translation.SparkGroupAlsoByWindowViaOutputBufferFn;
import org.apache.beam.runners.spark.translation.SparkPortablePipelineTranslator;
import org.apache.beam.runners.spark.translation.SparkTranslationContext;
import org.apache.beam.runners.spark.translation.TranslationUtils;
import org.apache.beam.runners.spark.util.ByteArray;
import org.apache.beam.sdk.coders.ByteArrayCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.transforms.windowing.GlobalWindows;
import org.apache.beam.sdk.transforms.windowing.TimestampCombiner;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.grpc.v1p48p1.com.google.protobuf.ByteString;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.BiMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.apache.spark.HashPartitioner;
import org.apache.spark.Partitioner;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.storage.StorageLevel;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import scala.Tuple2;

public class SparkBatchPortablePipelineTranslator
implements SparkPortablePipelineTranslator<SparkTranslationContext> {
    private final @UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized PTransformTranslator> urnToTransformTranslator;

    @Override
    public @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> knownUrns() {
        return this.urnToTransformTranslator.keySet();
    }

    public SparkBatchPortablePipelineTranslator() {
        ImmutableMap.Builder translatorMap = ImmutableMap.builder();
        translatorMap.put((Object)"beam:transform:impulse:v1", SparkBatchPortablePipelineTranslator::translateImpulse);
        translatorMap.put((Object)"beam:transform:group_by_key:v1", SparkBatchPortablePipelineTranslator::translateGroupByKey);
        translatorMap.put((Object)"beam:runner:executable_stage:v1", SparkBatchPortablePipelineTranslator::translateExecutableStage);
        translatorMap.put((Object)"beam:transform:flatten:v1", SparkBatchPortablePipelineTranslator::translateFlatten);
        translatorMap.put((Object)"beam:transform:reshuffle:v1", SparkBatchPortablePipelineTranslator::translateReshuffle);
        this.urnToTransformTranslator = translatorMap.build();
    }

    @Override
    public void translate(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Pipeline pipeline, @UnknownKeyFor @NonNull @Initialized SparkTranslationContext context) {
        QueryablePipeline p = QueryablePipeline.forTransforms((Collection)pipeline.getRootTransformIdsList(), (RunnerApi.Components)pipeline.getComponents());
        for (PipelineNode.PTransformNode transformNode : p.getTopologicallyOrderedTransforms()) {
            for (String inputId : transformNode.getTransform().getInputsMap().values()) {
                context.incrementConsumptionCountBy(inputId, 1);
            }
            if (transformNode.getTransform().getSpec().getUrn().equals("beam:runner:executable_stage:v1")) {
                context.incrementConsumptionCountBy(PipelineTranslatorUtils.getExecutableStageIntermediateId((PipelineNode.PTransformNode)transformNode), transformNode.getTransform().getOutputsMap().size());
            }
            for (String outputId : transformNode.getTransform().getOutputsMap().values()) {
                WindowedValue.WindowedValueCoder outputCoder = PipelineTranslatorUtils.getWindowedValueCoder((String)outputId, (RunnerApi.Components)pipeline.getComponents());
                context.putCoder(outputId, (Coder)outputCoder);
            }
        }
        for (PipelineNode.PTransformNode transformNode : p.getTopologicallyOrderedTransforms()) {
            ((PTransformTranslator)this.urnToTransformTranslator.getOrDefault((Object)transformNode.getTransform().getSpec().getUrn(), SparkBatchPortablePipelineTranslator::urnNotFound)).translate(transformNode, pipeline, context);
        }
    }

    private static void urnNotFound(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized PipelineNode.PTransformNode transformNode, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Pipeline pipeline, @UnknownKeyFor @NonNull @Initialized SparkTranslationContext context) {
        throw new IllegalArgumentException(String.format("Transform %s has unknown URN %s", transformNode.getId(), transformNode.getTransform().getSpec().getUrn()));
    }

    private static void translateImpulse(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized PipelineNode.PTransformNode transformNode, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Pipeline pipeline, @UnknownKeyFor @NonNull @Initialized SparkTranslationContext context) {
        BoundedDataset<byte[]> output = new BoundedDataset<byte[]>((Iterable<byte[]>)Collections.singletonList(new byte[0]), context.getSparkContext(), (Coder<byte[]>)ByteArrayCoder.of());
        context.pushDataset(PipelineTranslatorUtils.getOutputId((PipelineNode.PTransformNode)transformNode), output);
    }

    private static <K, V> void translateGroupByKey(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized PipelineNode.PTransformNode transformNode, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Pipeline pipeline, @UnknownKeyFor @NonNull @Initialized SparkTranslationContext context) {
        JavaRDD groupedByKeyAndWindow;
        RunnerApi.Components components = pipeline.getComponents();
        String inputId = PipelineTranslatorUtils.getInputId((PipelineNode.PTransformNode)transformNode);
        Dataset inputDataset = context.popDataset(inputId);
        JavaRDD inputRdd = ((BoundedDataset)inputDataset).getRDD();
        WindowedValue.WindowedValueCoder inputCoder = PipelineTranslatorUtils.getWindowedValueCoder((String)inputId, (RunnerApi.Components)components);
        KvCoder inputKvCoder = (KvCoder)inputCoder.getValueCoder();
        Coder inputKeyCoder = inputKvCoder.getKeyCoder();
        Coder inputValueCoder = inputKvCoder.getValueCoder();
        WindowingStrategy windowingStrategy = PipelineTranslatorUtils.getWindowingStrategy((String)inputId, (RunnerApi.Components)components);
        WindowFn windowFn = windowingStrategy.getWindowFn();
        WindowedValue.FullWindowedValueCoder wvCoder = WindowedValue.FullWindowedValueCoder.of((Coder)inputValueCoder, (Coder)windowFn.windowCoder());
        Partitioner partitioner = SparkBatchPortablePipelineTranslator.getPartitioner(context);
        if (windowingStrategy.getWindowFn().equals(new GlobalWindows()) && windowingStrategy.getTimestampCombiner().equals((Object)TimestampCombiner.END_OF_WINDOW)) {
            groupedByKeyAndWindow = GroupNonMergingWindowsFunctions.groupByKeyInGlobalWindow(inputRdd, inputKeyCoder, inputValueCoder, partitioner);
        } else if (GroupNonMergingWindowsFunctions.isEligibleForGroupByWindow(windowingStrategy)) {
            groupedByKeyAndWindow = GroupNonMergingWindowsFunctions.groupByKeyAndWindow(inputRdd, inputKeyCoder, inputValueCoder, windowingStrategy, partitioner);
        } else {
            JavaRDD groupedByKeyOnly = GroupCombineFunctions.groupByKeyOnly(inputRdd, inputKeyCoder, wvCoder, partitioner);
            groupedByKeyAndWindow = groupedByKeyOnly.flatMap(new SparkGroupAlsoByWindowViaOutputBufferFn(windowingStrategy, new TranslationUtils.InMemoryStateInternalsFactory(), SystemReduceFn.buffering((Coder)inputValueCoder), context.serializablePipelineOptions));
        }
        context.pushDataset(PipelineTranslatorUtils.getOutputId((PipelineNode.PTransformNode)transformNode), new BoundedDataset(groupedByKeyAndWindow));
    }

    private static <InputT, OutputT, SideInputT> void translateExecutableStage(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized PipelineNode.PTransformNode transformNode, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Pipeline pipeline, @UnknownKeyFor @NonNull @Initialized SparkTranslationContext context) {
        JavaRDD staged;
        RunnerApi.ExecutableStagePayload stagePayload;
        try {
            stagePayload = RunnerApi.ExecutableStagePayload.parseFrom((ByteString)transformNode.getTransform().getSpec().getPayload());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String inputPCollectionId = stagePayload.getInput();
        Dataset inputDataset = context.popDataset(inputPCollectionId);
        Map outputs = transformNode.getTransform().getOutputsMap();
        BiMap outputExtractionMap = PipelineTranslatorUtils.createOutputMap(outputs.values());
        RunnerApi.Components components = pipeline.getComponents();
        Coder windowCoder = PipelineTranslatorUtils.getWindowingStrategy((String)inputPCollectionId, (RunnerApi.Components)components).getWindowFn().windowCoder();
        ImmutableMap<String, Tuple2<Broadcast<List<byte[]>>, WindowedValue.WindowedValueCoder<SideInputT>>> broadcastVariables = SparkBatchPortablePipelineTranslator.broadcastSideInputs(stagePayload, context);
        if (stagePayload.getUserStatesCount() > 0 || stagePayload.getTimersCount() > 0) {
            Coder windowedInputCoder = PipelineTranslatorUtils.instantiateCoder((String)inputPCollectionId, (RunnerApi.Components)components);
            Coder valueCoder = ((WindowedValue.FullWindowedValueCoder)windowedInputCoder).getValueCoder();
            if (!(valueCoder instanceof KvCoder)) {
                throw new IllegalStateException(String.format(Locale.ENGLISH, "The element coder for stateful DoFn '%s' must be KvCoder but is: %s", inputPCollectionId, valueCoder.getClass().getSimpleName()));
            }
            Coder keyCoder = ((KvCoder)valueCoder).getKeyCoder();
            Coder innerValueCoder = ((KvCoder)valueCoder).getValueCoder();
            WindowingStrategy windowingStrategy = PipelineTranslatorUtils.getWindowingStrategy((String)inputPCollectionId, (RunnerApi.Components)components);
            WindowFn windowFn = windowingStrategy.getWindowFn();
            WindowedValue.FullWindowedValueCoder wvCoder = WindowedValue.FullWindowedValueCoder.of((Coder)innerValueCoder, (Coder)windowFn.windowCoder());
            JavaPairRDD groupedByKey = SparkBatchPortablePipelineTranslator.groupByKeyPair(inputDataset, keyCoder, wvCoder);
            SparkExecutableStageFunction function = new SparkExecutableStageFunction(context.getSerializableOptions(), stagePayload, context.jobInfo, (Map<String, Integer>)outputExtractionMap, SparkExecutableStageContextFactory.getInstance(), broadcastVariables, MetricsAccumulator.getInstance(), windowCoder);
            staged = groupedByKey.flatMap(function.forPair());
        } else {
            JavaRDD inputRdd2 = ((BoundedDataset)inputDataset).getRDD();
            SparkExecutableStageFunction function2 = new SparkExecutableStageFunction(context.getSerializableOptions(), stagePayload, context.jobInfo, (Map<String, Integer>)outputExtractionMap, SparkExecutableStageContextFactory.getInstance(), broadcastVariables, MetricsAccumulator.getInstance(), windowCoder);
            staged = inputRdd2.mapPartitions(function2);
        }
        String intermediateId = PipelineTranslatorUtils.getExecutableStageIntermediateId((PipelineNode.PTransformNode)transformNode);
        context.pushDataset(intermediateId, new Dataset(){

            @Override
            public void cache(@UnknownKeyFor @NonNull @Initialized String storageLevel, /*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> coder) {
                StorageLevel level = StorageLevel.fromString((String)storageLevel);
                staged.persist(level);
            }

            @Override
            public void action() {
                staged.foreach(TranslationUtils.emptyVoidFunction());
            }

            @Override
            public void setName(@UnknownKeyFor @NonNull @Initialized String name) {
                staged.setName(name);
            }
        });
        context.popDataset(intermediateId);
        for (String outputId : outputs.values()) {
            JavaRDD outputRdd = staged.flatMap(new SparkExecutableStageExtractionFunction((Integer)outputExtractionMap.get((Object)outputId)));
            context.pushDataset(outputId, new BoundedDataset(outputRdd));
        }
        if (outputs.isEmpty()) {
            JavaRDD outputRdd = staged.flatMap((FlatMapFunction & Serializable)rawUnionValue -> Collections.emptyIterator());
            context.pushDataset(String.format("EmptyOutputSink_%d", context.nextSinkId()), new BoundedDataset(outputRdd));
        }
    }

    private static <K, V> @UnknownKeyFor @NonNull @Initialized JavaPairRDD<@UnknownKeyFor @NonNull @Initialized ByteArray, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized KV<K, V>>>> groupByKeyPair(@UnknownKeyFor @NonNull @Initialized Dataset dataset, @UnknownKeyFor @NonNull @Initialized Coder<K> keyCoder, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized WindowedValue.WindowedValueCoder<V> wvCoder) {
        JavaRDD inputRdd = ((BoundedDataset)dataset).getRDD();
        return GroupCombineFunctions.groupByKeyPair(inputRdd, keyCoder, wvCoder);
    }

    private static <SideInputT> @UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Tuple2<@UnknownKeyFor @NonNull @Initialized Broadcast<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []>>, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized WindowedValue.WindowedValueCoder<SideInputT>>> broadcastSideInputs(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.ExecutableStagePayload stagePayload, @UnknownKeyFor @NonNull @Initialized SparkTranslationContext context) {
        HashMap broadcastVariables = new HashMap();
        for (RunnerApi.ExecutableStagePayload.SideInputId sideInputId : stagePayload.getSideInputsList()) {
            RunnerApi.Components stagePayloadComponents = stagePayload.getComponents();
            String collectionId = stagePayloadComponents.getTransformsOrThrow(sideInputId.getTransformId()).getInputsOrThrow(sideInputId.getLocalName());
            if (broadcastVariables.containsKey(collectionId)) continue;
            Tuple2 tuple2 = SparkBatchPortablePipelineTranslator.broadcastSideInput(collectionId, stagePayloadComponents, context);
            broadcastVariables.put(collectionId, tuple2);
        }
        return ImmutableMap.copyOf(broadcastVariables);
    }

    private static <T> @UnknownKeyFor @NonNull @Initialized Tuple2<@UnknownKeyFor @NonNull @Initialized Broadcast<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []>>, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized WindowedValue.WindowedValueCoder<T>> broadcastSideInput(@UnknownKeyFor @NonNull @Initialized String collectionId, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Components components, @UnknownKeyFor @NonNull @Initialized SparkTranslationContext context) {
        BoundedDataset dataset = (BoundedDataset)context.popDataset(collectionId);
        WindowedValue.WindowedValueCoder coder = PipelineTranslatorUtils.getWindowedValueCoder((String)collectionId, (RunnerApi.Components)components);
        List<byte[]> bytes = dataset.getBytes(coder);
        Broadcast broadcast = context.getSparkContext().broadcast(bytes);
        return new Tuple2((Object)broadcast, (Object)coder);
    }

    private static <T> void translateFlatten(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized PipelineNode.PTransformNode transformNode, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Pipeline pipeline, @UnknownKeyFor @NonNull @Initialized SparkTranslationContext context) {
        JavaRDD unionRDD;
        Map inputsMap = transformNode.getTransform().getInputsMap();
        if (inputsMap.isEmpty()) {
            unionRDD = context.getSparkContext().emptyRDD();
        } else {
            JavaRDD[] rdds = new JavaRDD[inputsMap.size()];
            int index = 0;
            for (String inputId : inputsMap.values()) {
                rdds[index] = ((BoundedDataset)context.popDataset(inputId)).getRDD();
                ++index;
            }
            unionRDD = context.getSparkContext().union(rdds);
        }
        context.pushDataset(PipelineTranslatorUtils.getOutputId((PipelineNode.PTransformNode)transformNode), new BoundedDataset(unionRDD));
    }

    private static <T> void translateReshuffle(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized PipelineNode.PTransformNode transformNode, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Pipeline pipeline, @UnknownKeyFor @NonNull @Initialized SparkTranslationContext context) {
        String inputId = PipelineTranslatorUtils.getInputId((PipelineNode.PTransformNode)transformNode);
        WindowedValue.WindowedValueCoder coder = PipelineTranslatorUtils.getWindowedValueCoder((String)inputId, (RunnerApi.Components)pipeline.getComponents());
        JavaRDD inRDD = ((BoundedDataset)context.popDataset(inputId)).getRDD();
        JavaRDD reshuffled = GroupCombineFunctions.reshuffle(inRDD, coder);
        context.pushDataset(PipelineTranslatorUtils.getOutputId((PipelineNode.PTransformNode)transformNode), new BoundedDataset(reshuffled));
    }

    private static @Nullable @UnknownKeyFor @Initialized Partitioner getPartitioner(@UnknownKeyFor @NonNull @Initialized SparkTranslationContext context) {
        Long bundleSize = ((SparkPipelineOptions)context.serializablePipelineOptions.get().as(SparkPipelineOptions.class)).getBundleSize();
        return bundleSize > 0L ? null : new HashPartitioner(context.getSparkContext().defaultParallelism().intValue());
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized SparkTranslationContext createTranslationContext(@UnknownKeyFor @NonNull @Initialized JavaSparkContext jsc, @UnknownKeyFor @NonNull @Initialized SparkPipelineOptions options, @UnknownKeyFor @NonNull @Initialized JobInfo jobInfo) {
        return new SparkTranslationContext(jsc, options, jobInfo);
    }

    @AutoService(value={NativeTransforms.IsNativeTransform.class})
    public static class IsSparkNativeTransform
    implements NativeTransforms.IsNativeTransform {
        public @UnknownKeyFor @NonNull @Initialized boolean test(// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized RunnerApi.PTransform pTransform) {
            return "beam:transform:reshuffle:v1".equals(PTransformTranslation.urnForTransformOrNull((RunnerApi.PTransform)pTransform));
        }
    }

    static interface PTransformTranslator {
        public void translate(// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized PipelineNode.PTransformNode var1, // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized RunnerApi.Pipeline var2, @UnknownKeyFor @NonNull @Initialized SparkTranslationContext var3);
    }
}

