/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.core.metrics;

import java.util.Date;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.beam.repackaged.direct_java.runners.core.metrics.MetricsContainerImpl;
import org.apache.beam.sdk.annotations.Experimental;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental(value=Experimental.Kind.METRICS)
public class MetricsLogger
extends MetricsContainerImpl {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(MetricsLogger.class);
    @UnknownKeyFor @NonNull @Initialized Lock reportingLocK = new ReentrantLock();
    @UnknownKeyFor @NonNull @Initialized AtomicLong lastReportedMillis = new AtomicLong(System.currentTimeMillis());
    @Nullable @UnknownKeyFor @Initialized MetricsContainerImpl lastMetricsSnapshot = null;

    public MetricsLogger(@Nullable @UnknownKeyFor @Initialized String stepName) {
        super(stepName);
    }

    public @UnknownKeyFor @NonNull @Initialized String generateLogMessage(@UnknownKeyFor @NonNull @Initialized String header, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> allowedMetricUrns, @UnknownKeyFor @NonNull @Initialized long lastReported) {
        MetricsContainerImpl nextMetricsSnapshot = new MetricsContainerImpl(this.stepName);
        nextMetricsSnapshot.update(this);
        MetricsContainerImpl deltaContainer = MetricsContainerImpl.deltaContainer(this.lastMetricsSnapshot, nextMetricsSnapshot);
        StringBuilder logMessage = new StringBuilder();
        logMessage.append(header);
        logMessage.append(deltaContainer.getCumulativeString(allowedMetricUrns));
        logMessage.append(String.format("(last reported at %s)%n", new Date(lastReported)));
        this.lastMetricsSnapshot = nextMetricsSnapshot;
        return logMessage.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tryLoggingMetrics(@UnknownKeyFor @NonNull @Initialized String header, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> allowedMetricUrns, @UnknownKeyFor @NonNull @Initialized long minimumLoggingFrequencyMillis) {
        if (this.reportingLocK.tryLock()) {
            try {
                long currentTimeMillis = System.currentTimeMillis();
                long lastReported = this.lastReportedMillis.get();
                if (currentTimeMillis - lastReported > minimumLoggingFrequencyMillis) {
                    LOG.info(this.generateLogMessage(header, allowedMetricUrns, lastReported));
                    this.lastReportedMillis.set(currentTimeMillis);
                }
            }
            finally {
                this.reportingLocK.unlock();
            }
        }
    }

    @Override
    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return super.hashCode();
    }

    @Override
    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object object) {
        if (object instanceof MetricsLogger) {
            return super.equals(object);
        }
        return false;
    }
}

