/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.sasinput;

import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.xml.XmlHandler;
import org.w3c.dom.Node;

public class SasInputField
implements Cloneable {
    private String name;
    private String rename;
    private int type;
    private int length;
    private int precision;
    private String conversionMask;
    private String decimalSymbol;
    private String groupingSymbol;
    private int trimType;

    public SasInputField(String name, String rename, int type, String conversionMask, String decimalSymbol, String groupingSymbol, int trimType) {
        this.name = name;
        this.rename = rename;
        this.type = type;
        this.conversionMask = conversionMask;
        this.decimalSymbol = decimalSymbol;
        this.groupingSymbol = groupingSymbol;
        this.trimType = trimType;
    }

    public SasInputField() {
    }

    protected SasInputField clone() {
        try {
            return (SasInputField)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String getXml() {
        String xml = "    " + XmlHandler.addTagValue((String)"name", (String)this.name) + "    " + XmlHandler.addTagValue((String)"rename", (String)this.rename) + "    " + XmlHandler.addTagValue((String)"type", (String)ValueMetaFactory.getValueMetaName((int)this.type)) + "    " + XmlHandler.addTagValue((String)"length", (int)this.length) + "    " + XmlHandler.addTagValue((String)"precision", (int)this.precision) + "    " + XmlHandler.addTagValue((String)"conversion_mask", (String)this.conversionMask) + "    " + XmlHandler.addTagValue((String)"decimal", (String)this.decimalSymbol) + "    " + XmlHandler.addTagValue((String)"grouping", (String)this.groupingSymbol) + "    " + XmlHandler.addTagValue((String)"trim_type", (String)ValueMetaString.getTrimTypeCode((int)this.trimType));
        return xml;
    }

    public SasInputField(Node node) throws HopXmlException {
        this.name = XmlHandler.getTagValue((Node)node, (String)"name");
        this.rename = XmlHandler.getTagValue((Node)node, (String)"rename");
        this.type = ValueMetaFactory.getIdForValueMeta((String)XmlHandler.getTagValue((Node)node, (String)"type"));
        this.length = Const.toInt((String)XmlHandler.getTagValue((Node)node, (String)"length"), (int)-1);
        this.precision = Const.toInt((String)XmlHandler.getTagValue((Node)node, (String)"precision"), (int)-1);
        this.conversionMask = XmlHandler.getTagValue((Node)node, (String)"conversion_mask");
        this.decimalSymbol = XmlHandler.getTagValue((Node)node, (String)"decimal");
        this.groupingSymbol = XmlHandler.getTagValue((Node)node, (String)"grouping");
        this.trimType = ValueMetaString.getTrimTypeByCode((String)XmlHandler.getTagValue((Node)node, (String)"trim_type"));
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getRename() {
        return this.rename;
    }

    public void setRename(String rename) {
        this.rename = rename;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getConversionMask() {
        return this.conversionMask;
    }

    public void setConversionMask(String conversionMask) {
        this.conversionMask = conversionMask;
    }

    public String getDecimalSymbol() {
        return this.decimalSymbol;
    }

    public void setDecimalSymbol(String decimalSymbol) {
        this.decimalSymbol = decimalSymbol;
    }

    public String getGroupingSymbol() {
        return this.groupingSymbol;
    }

    public void setGroupingSymbol(String groupingSymbol) {
        this.groupingSymbol = groupingSymbol;
    }

    public int getTrimType() {
        return this.trimType;
    }

    public void setTrimType(int trimType) {
        this.trimType = trimType;
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public String getTrimTypeDesc() {
        return ValueMetaString.getTrimTypeDesc((int)this.trimType);
    }
}

