/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction;

import com.google.cloud.Timestamp;
import java.io.Serializable;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;

public class PartitionRestrictionMetadata
implements Serializable {
    private static final @UnknownKeyFor @NonNull @Initialized long serialVersionUID = 4744539370804123350L;
    private final @UnknownKeyFor @NonNull @Initialized String partitionToken;
    private final @UnknownKeyFor @NonNull @Initialized Timestamp partitionStartTimestamp;
    private final @UnknownKeyFor @NonNull @Initialized Timestamp partitionEndTimestamp;

    public PartitionRestrictionMetadata(@UnknownKeyFor @NonNull @Initialized String partitionToken, @UnknownKeyFor @NonNull @Initialized Timestamp partitionStartTimestamp, @UnknownKeyFor @NonNull @Initialized Timestamp partitionEndTimestamp) {
        this.partitionToken = partitionToken;
        this.partitionStartTimestamp = partitionStartTimestamp;
        this.partitionEndTimestamp = partitionEndTimestamp;
    }

    public @UnknownKeyFor @NonNull @Initialized String getPartitionToken() {
        return this.partitionToken;
    }

    public @UnknownKeyFor @NonNull @Initialized Timestamp getPartitionStartTimestamp() {
        return this.partitionStartTimestamp;
    }

    public @UnknownKeyFor @NonNull @Initialized Timestamp getPartitionEndTimestamp() {
        return this.partitionEndTimestamp;
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return "PartitionRestrictionMetadata{partitionToken='" + this.partitionToken + '\'' + ", partitionStartTimestamp=" + this.partitionStartTimestamp + ", partitionEndTimestamp=" + this.partitionEndTimestamp + '}';
    }

    public static @UnknownKeyFor @NonNull @Initialized Builder newBuilder() {
        return new Builder();
    }

    public static @UnknownKeyFor @NonNull @Initialized Builder newBuilder(@UnknownKeyFor @NonNull @Initialized PartitionRestrictionMetadata metadata) {
        return new Builder(metadata);
    }

    public static class Builder {
        private @UnknownKeyFor @NonNull @Initialized String partitionToken;
        private @UnknownKeyFor @NonNull @Initialized Timestamp partitionStartTimestamp;
        private @UnknownKeyFor @NonNull @Initialized Timestamp partitionEndTimestamp;

        public Builder() {
        }

        public Builder(@UnknownKeyFor @NonNull @Initialized PartitionRestrictionMetadata metadata) {
            this.partitionToken = metadata.partitionToken;
            this.partitionStartTimestamp = metadata.partitionStartTimestamp;
            this.partitionEndTimestamp = metadata.partitionEndTimestamp;
        }

        public @UnknownKeyFor @NonNull @Initialized Builder withPartitionToken(@UnknownKeyFor @NonNull @Initialized String partitionToken) {
            this.partitionToken = partitionToken;
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized Builder withPartitionStartTimestamp(@UnknownKeyFor @NonNull @Initialized Timestamp partitionStartTimestamp) {
            this.partitionStartTimestamp = partitionStartTimestamp;
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized Builder withPartitionEndTimestamp(@UnknownKeyFor @NonNull @Initialized Timestamp partitionEndTimestamp) {
            this.partitionEndTimestamp = partitionEndTimestamp;
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized PartitionRestrictionMetadata build() {
            return new PartitionRestrictionMetadata(this.partitionToken, this.partitionStartTimestamp, this.partitionEndTimestamp);
        }
    }
}

