/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.healthcare;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.io.gcp.healthcare.HealthcareApiClient;
import org.apache.beam.sdk.io.gcp.healthcare.HttpHealthcareApiClient;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class DicomIO {
    public static @UnknownKeyFor @NonNull @Initialized ReadStudyMetadata readStudyMetadata() {
        return new ReadStudyMetadata();
    }

    public static class ReadStudyMetadata
    extends PTransform<PCollection<String>, Result> {
        public static final @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized String> METADATA = new TupleTag<String>(){};
        public static final @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized String> ERROR_MESSAGE = new TupleTag<String>(){};

        private ReadStudyMetadata() {
        }

        public @UnknownKeyFor @NonNull @Initialized Result expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized String> input) {
            return new Result((PCollectionTuple)input.apply((PTransform)ParDo.of((DoFn)new FetchStudyMetadataFn()).withOutputTags(METADATA, TupleTagList.of(ERROR_MESSAGE))));
        }

        static class FetchStudyMetadataFn
        extends DoFn<String, String> {
            private @UnknownKeyFor @NonNull @Initialized HealthcareApiClient dicomStore;

            FetchStudyMetadataFn() {
            }

            @DoFn.Setup
            public void instantiateHealthcareClient() throws @UnknownKeyFor @NonNull @Initialized IOException {
                if (this.dicomStore == null) {
                    this.dicomStore = new HttpHealthcareApiClient();
                }
            }

            @DoFn.ProcessElement
            public void processElement(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext context) {
                block2: {
                    String dicomWebPath = (String)context.element();
                    try {
                        String responseData = this.dicomStore.retrieveDicomStudyMetadata(dicomWebPath);
                        context.output(METADATA, (Object)responseData);
                    }
                    catch (IOException e) {
                        String errorMessage = e.getMessage();
                        if (errorMessage == null) break block2;
                        context.output(ERROR_MESSAGE, (Object)errorMessage);
                    }
                }
            }
        }

        public static class Result
        implements POutput,
        PInput {
            private @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized String> readResponse;
            private @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized String> failedReads;
            @UnknownKeyFor @NonNull @Initialized PCollectionTuple pct;

            static @UnknownKeyFor @NonNull @Initialized Result of(@UnknownKeyFor @NonNull @Initialized PCollectionTuple pct) throws @UnknownKeyFor @NonNull @Initialized IllegalArgumentException {
                if (pct.getAll().keySet().containsAll((Collection)TupleTagList.of(METADATA).and(ERROR_MESSAGE))) {
                    return new Result(pct);
                }
                throw new IllegalArgumentException("The PCollection tuple must have the DicomIO.ReadStudyMetadata.METADATA and DicomIO.ReadStudyMetadata.ERROR_MESSAGE tuple tags");
            }

            private Result(@UnknownKeyFor @NonNull @Initialized PCollectionTuple pct) {
                this.pct = pct;
                this.readResponse = pct.get(METADATA);
                this.failedReads = pct.get(ERROR_MESSAGE);
            }

            public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized String> getFailedReads() {
                return this.failedReads;
            }

            public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized String> getReadResponse() {
                return this.readResponse;
            }

            public @UnknownKeyFor @NonNull @Initialized Pipeline getPipeline() {
                return this.pct.getPipeline();
            }

            public /*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized PValue> expand() {
                return ImmutableMap.of(METADATA, this.readResponse);
            }

            public void finishSpecifyingOutput(@UnknownKeyFor @NonNull @Initialized String transformName, @UnknownKeyFor @NonNull @Initialized PInput input, /*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> transform) {
            }
        }
    }
}

