/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.healthcare;

import org.apache.beam.sdk.io.gcp.healthcare.FhirBundleParameter;

final class AutoValue_FhirBundleParameter
extends FhirBundleParameter {
    private final String metadata;
    private final String bundle;

    private AutoValue_FhirBundleParameter(String metadata, String bundle) {
        this.metadata = metadata;
        this.bundle = bundle;
    }

    @Override
    public String getMetadata() {
        return this.metadata;
    }

    @Override
    public String getBundle() {
        return this.bundle;
    }

    public String toString() {
        return "FhirBundleParameter{metadata=" + this.metadata + ", bundle=" + this.bundle + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof FhirBundleParameter) {
            FhirBundleParameter that = (FhirBundleParameter)o;
            return this.metadata.equals(that.getMetadata()) && this.bundle.equals(that.getBundle());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.metadata.hashCode();
        h$ *= 1000003;
        return h$ ^= this.bundle.hashCode();
    }

    static final class Builder
    extends FhirBundleParameter.Builder {
        private String metadata;
        private String bundle;

        Builder() {
        }

        @Override
        FhirBundleParameter.Builder setMetadata(String metadata) {
            if (metadata == null) {
                throw new NullPointerException("Null metadata");
            }
            this.metadata = metadata;
            return this;
        }

        @Override
        FhirBundleParameter.Builder setBundle(String bundle) {
            if (bundle == null) {
                throw new NullPointerException("Null bundle");
            }
            this.bundle = bundle;
            return this;
        }

        @Override
        FhirBundleParameter build() {
            if (this.metadata == null || this.bundle == null) {
                StringBuilder missing = new StringBuilder();
                if (this.metadata == null) {
                    missing.append(" metadata");
                }
                if (this.bundle == null) {
                    missing.append(" bundle");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_FhirBundleParameter(this.metadata, this.bundle);
        }
    }
}

