/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigtable;

import com.google.auth.Credentials;
import com.google.auto.value.AutoValue;
import com.google.cloud.bigtable.config.BigtableOptions;
import com.google.cloud.bigtable.config.CredentialOptions;
import java.io.Serializable;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.extensions.gcp.options.GcpOptions;
import org.apache.beam.sdk.io.gcp.bigtable.AutoValue_BigtableConfig;
import org.apache.beam.sdk.io.gcp.bigtable.BigtableService;
import org.apache.beam.sdk.io.gcp.bigtable.BigtableServiceImpl;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;

@AutoValue
@Internal
public abstract class BigtableConfig
implements Serializable {
    public abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> getProjectId();

    public abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> getInstanceId();

    public abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> getTableId();

    public abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> getAppProfileId();

    @Deprecated
    abstract @Nullable @UnknownKeyFor @Initialized BigtableOptions getBigtableOptions();

    abstract @Nullable @UnknownKeyFor @Initialized SerializableFunction<// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized BigtableOptions.Builder, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized BigtableOptions.Builder> getBigtableOptionsConfigurator();

    abstract @UnknownKeyFor @NonNull @Initialized boolean getValidate();

    abstract @Nullable @UnknownKeyFor @Initialized BigtableService getBigtableService();

    abstract @Nullable @UnknownKeyFor @Initialized String getEmulatorHost();

    abstract @UnknownKeyFor @NonNull @Initialized Builder toBuilder();

    static @UnknownKeyFor @NonNull @Initialized Builder builder() {
        return new AutoValue_BigtableConfig.Builder();
    }

    public @UnknownKeyFor @NonNull @Initialized BigtableConfig withProjectId(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> projectId) {
        Preconditions.checkArgument((projectId != null ? 1 : 0) != 0, (Object)"Project Id of BigTable can not be null");
        return this.toBuilder().setProjectId(projectId).build();
    }

    public @UnknownKeyFor @NonNull @Initialized BigtableConfig withInstanceId(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> instanceId) {
        Preconditions.checkArgument((instanceId != null ? 1 : 0) != 0, (Object)"Instance Id of BigTable can not be null");
        return this.toBuilder().setInstanceId(instanceId).build();
    }

    public @UnknownKeyFor @NonNull @Initialized BigtableConfig withTableId(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> tableId) {
        Preconditions.checkArgument((tableId != null ? 1 : 0) != 0, (Object)"tableId can not be null");
        return this.toBuilder().setTableId(tableId).build();
    }

    public @UnknownKeyFor @NonNull @Initialized BigtableConfig withAppProfileId(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> appProfileId) {
        Preconditions.checkArgument((appProfileId != null ? 1 : 0) != 0, (Object)"tableId can not be null");
        return this.toBuilder().setAppProfileId(appProfileId).build();
    }

    @Deprecated
    public @UnknownKeyFor @NonNull @Initialized BigtableConfig withBigtableOptions(@UnknownKeyFor @NonNull @Initialized BigtableOptions options) {
        Preconditions.checkArgument((options != null ? 1 : 0) != 0, (Object)"Bigtable options can not be null");
        return this.toBuilder().setBigtableOptions(options).build();
    }

    public @UnknownKeyFor @NonNull @Initialized BigtableConfig withBigtableOptionsConfigurator(@UnknownKeyFor @NonNull @Initialized SerializableFunction<// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized BigtableOptions.Builder, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized BigtableOptions.Builder> configurator) {
        Preconditions.checkArgument((configurator != null ? 1 : 0) != 0, (Object)"configurator can not be null");
        return this.toBuilder().setBigtableOptionsConfigurator(configurator).build();
    }

    public @UnknownKeyFor @NonNull @Initialized BigtableConfig withValidate(@UnknownKeyFor @NonNull @Initialized boolean isEnabled) {
        return this.toBuilder().setValidate(isEnabled).build();
    }

    @VisibleForTesting
    public @UnknownKeyFor @NonNull @Initialized BigtableConfig withBigtableService(@UnknownKeyFor @NonNull @Initialized BigtableService bigtableService) {
        Preconditions.checkArgument((bigtableService != null ? 1 : 0) != 0, (Object)"bigtableService can not be null");
        return this.toBuilder().setBigtableService(bigtableService).build();
    }

    @VisibleForTesting
    public @UnknownKeyFor @NonNull @Initialized BigtableConfig withEmulator(@UnknownKeyFor @NonNull @Initialized String emulatorHost) {
        Preconditions.checkArgument((emulatorHost != null ? 1 : 0) != 0, (Object)"emulatorHost can not be null");
        return this.toBuilder().setEmulatorHost(emulatorHost).build();
    }

    void validate() {
        Preconditions.checkArgument((this.getTableId() != null && (!this.getTableId().isAccessible() || !((String)this.getTableId().get()).isEmpty()) ? 1 : 0) != 0, (Object)"Could not obtain Bigtable table id");
        Preconditions.checkArgument((this.getProjectId() != null && (!this.getProjectId().isAccessible() || !((String)this.getProjectId().get()).isEmpty()) || this.getBigtableOptions() != null && this.getBigtableOptions().getProjectId() != null && !this.getBigtableOptions().getProjectId().isEmpty() ? 1 : 0) != 0, (Object)"Could not obtain Bigtable project id");
        Preconditions.checkArgument((this.getInstanceId() != null && (!this.getInstanceId().isAccessible() || !((String)this.getInstanceId().get()).isEmpty()) || this.getBigtableOptions() != null && this.getBigtableOptions().getInstanceId() != null && !this.getBigtableOptions().getInstanceId().isEmpty() ? 1 : 0) != 0, (Object)"Could not obtain Bigtable instance id");
    }

    void populateDisplayData(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
        builder.addIfNotNull(DisplayData.item((String)"projectId", this.getProjectId()).withLabel("Bigtable Project Id")).addIfNotNull(DisplayData.item((String)"instanceId", this.getInstanceId()).withLabel("Bigtable Instance Id")).addIfNotNull(DisplayData.item((String)"tableId", this.getTableId()).withLabel("Bigtable Table Id")).addIfNotNull(DisplayData.item((String)"appProfileId", this.getAppProfileId()).withLabel("Bigtable App Profile Id")).add(DisplayData.item((String)"withValidation", (Boolean)this.getValidate()).withLabel("Check is table exists"));
        if (this.getBigtableOptions() != null) {
            builder.add(DisplayData.item((String)"bigtableOptions", (String)this.getBigtableOptions().toString()).withLabel("Bigtable Options"));
        }
    }

    @VisibleForTesting
    @UnknownKeyFor @NonNull @Initialized BigtableService getBigtableService(@UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions) {
        if (this.getBigtableService() != null) {
            return this.getBigtableService();
        }
        BigtableOptions.Builder bigtableOptions = this.effectiveUserProvidedBigtableOptions();
        bigtableOptions.setUserAgent(pipelineOptions.getUserAgent());
        if (bigtableOptions.build().getCredentialOptions().getCredentialType() == CredentialOptions.CredentialType.DefaultCredentials) {
            bigtableOptions.setCredentialOptions(CredentialOptions.credential((Credentials)((GcpOptions)pipelineOptions.as(GcpOptions.class)).getGcpCredential()));
        }
        return new BigtableServiceImpl(bigtableOptions.build());
    }

    @UnknownKeyFor @NonNull @Initialized boolean isDataAccessible() {
        return !(!this.getTableId().isAccessible() || this.getProjectId() != null && !this.getProjectId().isAccessible() || this.getInstanceId() != null && !this.getInstanceId().isAccessible());
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized BigtableOptions.Builder effectiveUserProvidedBigtableOptions() {
        BigtableOptions.Builder effectiveOptions;
        BigtableOptions.Builder builder = effectiveOptions = this.getBigtableOptions() != null ? this.getBigtableOptions().toBuilder() : new BigtableOptions.Builder();
        if (this.getBigtableOptionsConfigurator() != null) {
            effectiveOptions = (BigtableOptions.Builder)this.getBigtableOptionsConfigurator().apply((Object)effectiveOptions);
        }
        effectiveOptions.setUseCachedDataPool(true);
        if (this.getInstanceId() != null) {
            effectiveOptions.setInstanceId((String)this.getInstanceId().get());
        }
        if (this.getProjectId() != null) {
            effectiveOptions.setProjectId((String)this.getProjectId().get());
        }
        if (this.getEmulatorHost() != null) {
            effectiveOptions.enableEmulator(this.getEmulatorHost());
            effectiveOptions.setUseCachedDataPool(false);
        }
        return effectiveOptions;
    }

    @SideEffectFree
    public final @UnknownKeyFor @NonNull @Initialized String toString() {
        return MoreObjects.toStringHelper(BigtableConfig.class).add("projectId", this.getProjectId()).add("instanceId", this.getInstanceId()).add("tableId", this.getTableId()).add("appProfileId", this.getAppProfileId()).add("bigtableOptionsConfigurator", this.getBigtableOptionsConfigurator() == null ? null : this.getBigtableOptionsConfigurator().getClass().getName()).add("options", (Object)this.getBigtableOptions()).toString();
    }

    @AutoValue.Builder
    static abstract class Builder {
        Builder() {
        }

        abstract @UnknownKeyFor @NonNull @Initialized Builder setProjectId(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setInstanceId(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setTableId(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setAppProfileId(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

        @Deprecated
        abstract @UnknownKeyFor @NonNull @Initialized Builder setBigtableOptions(@UnknownKeyFor @NonNull @Initialized BigtableOptions var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setValidate(@UnknownKeyFor @NonNull @Initialized boolean var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setBigtableOptionsConfigurator(@UnknownKeyFor @NonNull @Initialized SerializableFunction<// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized BigtableOptions.Builder, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized BigtableOptions.Builder> var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setBigtableService(@UnknownKeyFor @NonNull @Initialized BigtableService var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setEmulatorHost(@UnknownKeyFor @NonNull @Initialized String var1);

        abstract @UnknownKeyFor @NonNull @Initialized BigtableConfig build();
    }
}

