/*
 * Decompiled with CFR 0.152.
 */
package com.epam.parso.impl;

import com.epam.parso.CSVMetadataWriter;
import com.epam.parso.Column;
import com.epam.parso.SasFileProperties;
import com.epam.parso.impl.AbstractCSVWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.List;

public class CSVMetadataWriterImpl
extends AbstractCSVWriter
implements CSVMetadataWriter {
    private static final String COLUMN_HEADING_ID = "Number";
    private static final String COLUMN_HEADING_NAME = "Name";
    private static final String COLUMN_HEADING_TYPE = "Type";
    private static final String COLUMN_HEADING_DATA_LENGTH = "Data length";
    private static final String COLUMN_HEADING_FORMAT = "Format";
    private static final String COLUMN_HEADING_LABEL = "Label";
    private static final String JAVA_NUMBER_CLASS_NAME = "java.lang.Number";
    private static final String JAVA_STRING_CLASS_NAME = "java.lang.String";
    private static final String OUTPUT_NUMBER_TYPE_NAME = "Numeric";
    private static final String OUTPUT_STRING_TYPE_NAME = "Character";

    public CSVMetadataWriterImpl(Writer writer) {
        super(writer);
    }

    public CSVMetadataWriterImpl(Writer writer, String delimiter) {
        super(writer, delimiter);
    }

    public CSVMetadataWriterImpl(Writer writer, String delimiter, String endline) {
        super(writer, delimiter, endline);
    }

    @Override
    public void writeMetadata(List<Column> columns) throws IOException {
        Writer writer = this.getWriter();
        String delimiter = this.getDelimiter();
        String endline = this.getEndline();
        writer.write(COLUMN_HEADING_ID);
        writer.write(delimiter);
        writer.write(COLUMN_HEADING_NAME);
        writer.write(delimiter);
        writer.write(COLUMN_HEADING_TYPE);
        writer.write(delimiter);
        writer.write(COLUMN_HEADING_DATA_LENGTH);
        writer.write(delimiter);
        writer.write(COLUMN_HEADING_FORMAT);
        writer.write(delimiter);
        writer.write(COLUMN_HEADING_LABEL);
        writer.write(endline);
        for (Column column : columns) {
            writer.write(String.valueOf(column.getId()));
            writer.write(delimiter);
            CSVMetadataWriterImpl.checkSurroundByQuotesAndWrite(writer, delimiter, column.getName());
            writer.write(delimiter);
            writer.write(column.getType().getName().replace(JAVA_NUMBER_CLASS_NAME, OUTPUT_NUMBER_TYPE_NAME).replace(JAVA_STRING_CLASS_NAME, OUTPUT_STRING_TYPE_NAME));
            writer.write(delimiter);
            writer.write(String.valueOf(column.getLength()));
            writer.write(delimiter);
            if (!column.getFormat().isEmpty()) {
                CSVMetadataWriterImpl.checkSurroundByQuotesAndWrite(writer, delimiter, column.getFormat().toString());
            }
            writer.write(delimiter);
            CSVMetadataWriterImpl.checkSurroundByQuotesAndWrite(writer, delimiter, column.getLabel());
            writer.write(endline);
        }
        writer.flush();
    }

    @Override
    public void writeSasFileProperties(SasFileProperties sasFileProperties) throws IOException {
        this.constructPropertiesString("Bitness: ", sasFileProperties.isU64() ? "x64" : "x86");
        this.constructPropertiesString("Compressed: ", sasFileProperties.getCompressionMethod());
        this.constructPropertiesString("Endianness: ", sasFileProperties.getEndianness() == 1 ? "LITTLE_ENDIANNESS" : "BIG_ENDIANNESS");
        this.constructPropertiesString("Encoding: ", sasFileProperties.getEncoding());
        this.constructPropertiesString("Name: ", sasFileProperties.getName());
        this.constructPropertiesString("File type: ", sasFileProperties.getFileType());
        this.constructPropertiesString("File label: ", sasFileProperties.getFileLabel());
        this.constructPropertiesString("Date created: ", sasFileProperties.getDateCreated());
        this.constructPropertiesString("Date modified: ", sasFileProperties.getDateModified());
        this.constructPropertiesString("SAS release: ", sasFileProperties.getSasRelease());
        this.constructPropertiesString("SAS server type: ", sasFileProperties.getServerType());
        this.constructPropertiesString("OS name: ", sasFileProperties.getOsName());
        this.constructPropertiesString("OS type: ", sasFileProperties.getOsType());
        this.constructPropertiesString("Header Length: ", sasFileProperties.getHeaderLength());
        this.constructPropertiesString("Page Length: ", sasFileProperties.getPageLength());
        this.constructPropertiesString("Page Count: ", sasFileProperties.getPageCount());
        this.constructPropertiesString("Row Length: ", sasFileProperties.getRowLength());
        this.constructPropertiesString("Row Count: ", sasFileProperties.getRowCount());
        this.constructPropertiesString("Mix Page Row Count: ", sasFileProperties.getMixPageRowCount());
        this.constructPropertiesString("Columns Count: ", sasFileProperties.getColumnsCount());
        this.getWriter().flush();
    }

    private void constructPropertiesString(String propertyName, Object property) throws IOException {
        this.getWriter().write(propertyName + property + "\n");
    }
}

