/*
 * Decompiled with CFR 0.152.
 */
package org.monetdb.mcl.net;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.ClientInfoStatus;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.monetdb.jdbc.MonetDriver;

public final class ClientInfo {
    public static final String defaultHostname = ClientInfo.findHostname();
    public static final String defaultClientLibrary = ClientInfo.findClientLibrary();
    public static final String defaultApplicationName = ClientInfo.findApplicationName();
    public static final String defaultPid = ClientInfo.findPid();
    private final Properties props = new Properties();
    private HashMap<String, ClientInfoStatus> problems = null;

    public void setDefaults() {
        this.props.setProperty("ClientHostname", defaultHostname);
        this.props.setProperty("ClientLibrary", defaultClientLibrary);
        this.props.setProperty("ClientPid", defaultPid);
        this.props.setProperty("ApplicationName", defaultApplicationName);
        this.props.setProperty("ClientRemark", "");
    }

    private static String findHostname() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            return "";
        }
    }

    private static String findApplicationName() {
        String string = "";
        try {
            String string2 = System.getProperty("sun.java.command");
            if (string2 != null) {
                int n = (string2 = string2.split("\\s", 2)[0]).lastIndexOf(File.separatorChar);
                if (n >= 0) {
                    string2 = string2.substring(n + 1);
                }
                string = string2;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return string;
    }

    private static String findPid() {
        try {
            RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
            String string = runtimeMXBean.getName();
            return string.split("@", 2)[0];
        }
        catch (RuntimeException runtimeException) {
            return "";
        }
    }

    private static String findClientLibrary() {
        return "monetdb-java " + MonetDriver.getDriverVersion();
    }

    public String format() {
        StringBuilder stringBuilder = new StringBuilder(200);
        for (String string : this.props.stringPropertyNames()) {
            String string2 = this.props.getProperty(string);
            stringBuilder.append(string);
            stringBuilder.append('=');
            stringBuilder.append(string2);
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    public Properties get() {
        return this.props;
    }

    public HashMap<String, ClientInfoStatus> getProblems() {
        return this.problems;
    }

    public void set(String string, String string2, Set<String> set) throws SQLClientInfoException {
        if (string2 == null) {
            string2 = "";
        }
        if (set != null && !set.contains(string)) {
            this.addProblem(string, ClientInfoStatus.REASON_UNKNOWN_PROPERTY);
        } else {
            if (string2.contains("\n")) {
                this.addProblem(string, ClientInfoStatus.REASON_VALUE_INVALID);
                throw new SQLClientInfoException("Invalid value for Client Info property '" + string + "'", "01M07", this.problems);
            }
            this.props.setProperty(string, string2);
        }
    }

    public void set(String string, String string2) throws SQLClientInfoException {
        this.set(string, string2, null);
    }

    private void addProblem(String string, ClientInfoStatus clientInfoStatus) {
        ClientInfoStatus clientInfoStatus2;
        if (this.problems == null) {
            this.problems = new HashMap();
        }
        if ((clientInfoStatus2 = this.problems.get(string)) == null || clientInfoStatus.compareTo(clientInfoStatus2) > 0) {
            this.problems.put(string, clientInfoStatus);
        }
    }

    public SQLClientInfoException wrapException(SQLException sQLException) {
        return new SQLClientInfoException(this.problems, (Throwable)sQLException);
    }

    public SQLWarning warnings() {
        SQLWarning sQLWarning = null;
        if (this.problems == null) {
            return null;
        }
        for (Map.Entry<String, ClientInfoStatus> entry : this.problems.entrySet()) {
            if (!entry.getValue().equals((Object)ClientInfoStatus.REASON_UNKNOWN_PROPERTY)) continue;
            SQLWarning sQLWarning2 = new SQLWarning("unknown client info property: " + entry.getKey(), "01M07");
            if (sQLWarning == null) {
                sQLWarning = sQLWarning2;
                continue;
            }
            sQLWarning.setNextWarning(sQLWarning2);
        }
        return sQLWarning;
    }
}

