/*
 * Decompiled with CFR 0.152.
 */
package org.monetdb.client;

import java.io.BufferedWriter;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import org.monetdb.merovingian.Control;
import org.monetdb.merovingian.SabaothDB;
import org.monetdb.util.CmdLineOpts;
import org.monetdb.util.OptionsException;

public final class JMonetDB {
    private static PrintWriter out;

    public static final void main(String[] stringArray) throws Exception {
        String[] stringArray2;
        Object object;
        CmdLineOpts cmdLineOpts = new CmdLineOpts();
        cmdLineOpts.addOption("h", "host", 1, "localhost", "The hostname of the host that runs the MonetDB server.  A port number can be supplied by use of a colon, i.e. -h somehost:12345.");
        cmdLineOpts.addOption("p", "port", 1, "50000", "The port number to connect to.");
        cmdLineOpts.addOption("P", "passphrase", 1, null, "The passphrase to tell the MonetDB server");
        cmdLineOpts.addOption("c", "command", 4, null, "The command to execute on the MonetDB server");
        cmdLineOpts.addOption(null, "help", 0, null, "This help screen.");
        cmdLineOpts.addOption(null, "Xhash", 1, null, "Use the given hash algorithm during challenge response.  Supported algorithm names: SHA512, SHA384, SHA256 and SHA1.");
        cmdLineOpts.addOption(null, "Xdebug", 1, null, "Writes a transmission log to disk for debugging purposes.  A file name must be given.");
        try {
            cmdLineOpts.processArgs(stringArray);
        }
        catch (OptionsException optionsException) {
            System.err.println("Error: " + optionsException.getMessage());
            System.exit(1);
        }
        if (cmdLineOpts.getOption("help").isPresent()) {
            System.out.print("Usage java -jar jmonetdb.jar\n                  -h host[:port] -p port -P passphrase [-X<opt>] -c cmd ...\nor using long option equivalents --host --port --passphrase.\nArguments may be written directly after the option like -p50000.\n\nIf no host and port are given, localhost and 50000 are assumed.\n\nOPTIONS\n" + cmdLineOpts.produceHelpMessage());
            System.exit(0);
        }
        out = new PrintWriter(new BufferedWriter(new OutputStreamWriter(System.out)));
        String string = cmdLineOpts.getOption("passphrase").getArgument();
        if (string == null) {
            object = System.console().readPassword("passphrase: ", new Object[0]);
            if (object == null) {
                System.err.println("Invalid passphrase!");
                System.exit(1);
            }
            string = String.valueOf((char[])object);
        }
        object = cmdLineOpts.getOption("host").getArgument();
        String string2 = cmdLineOpts.getOption("port").getArgument();
        int n = ((String)object).indexOf(58);
        if (n != -1) {
            string2 = ((String)object).substring(n + 1);
            object = ((String)object).substring(0, n);
        }
        int n2 = Integer.parseInt(string2);
        String string3 = null;
        if (cmdLineOpts.getOption("Xhash").isPresent()) {
            string3 = cmdLineOpts.getOption("Xhash").getArgument();
        }
        if (!cmdLineOpts.getOption("command").isPresent()) {
            System.err.println("need a command to execute (-c)");
            System.exit(1);
        }
        Control control = null;
        try {
            control = new Control((String)object, n2, string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println(illegalArgumentException.getMessage());
            System.exit(1);
        }
        if (cmdLineOpts.getOption("Xdebug").isPresent()) {
            stringArray2 = cmdLineOpts.getOption("Xdebug").getArgument();
            control.setDebug((String)stringArray2);
        }
        if ((stringArray2 = cmdLineOpts.getOption("command").getArguments())[0].equals("status")) {
            ArrayList<SabaothDB> arrayList;
            if (stringArray2.length == 1) {
                arrayList = control.getAllStatuses();
            } else {
                arrayList = new ArrayList<SabaothDB>();
                for (int i = 1; i < stringArray2.length; ++i) {
                    arrayList.add(control.getStatus(stringArray2[i]));
                }
            }
            for (SabaothDB sabaothDB : arrayList) {
                System.out.println(sabaothDB.getName() + " " + sabaothDB.getURI());
            }
        }
    }
}

