/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.teamlog;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SfTeamInviteChangeRoleDetails {
    protected final long targetAssetIndex;
    @Nonnull
    protected final String originalFolderName;
    @Nullable
    protected final String newSharingPermission;
    @Nullable
    protected final String previousSharingPermission;

    public SfTeamInviteChangeRoleDetails(long targetAssetIndex, @Nonnull String originalFolderName, @Nullable String newSharingPermission, @Nullable String previousSharingPermission) {
        this.targetAssetIndex = targetAssetIndex;
        if (originalFolderName == null) {
            throw new IllegalArgumentException("Required value for 'originalFolderName' is null");
        }
        this.originalFolderName = originalFolderName;
        this.newSharingPermission = newSharingPermission;
        this.previousSharingPermission = previousSharingPermission;
    }

    public SfTeamInviteChangeRoleDetails(long targetAssetIndex, @Nonnull String originalFolderName) {
        this(targetAssetIndex, originalFolderName, null, null);
    }

    public long getTargetAssetIndex() {
        return this.targetAssetIndex;
    }

    @Nonnull
    public String getOriginalFolderName() {
        return this.originalFolderName;
    }

    @Nullable
    public String getNewSharingPermission() {
        return this.newSharingPermission;
    }

    @Nullable
    public String getPreviousSharingPermission() {
        return this.previousSharingPermission;
    }

    public static Builder newBuilder(long targetAssetIndex, String originalFolderName) {
        return new Builder(targetAssetIndex, originalFolderName);
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.targetAssetIndex, this.originalFolderName, this.newSharingPermission, this.previousSharingPermission});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            SfTeamInviteChangeRoleDetails other = (SfTeamInviteChangeRoleDetails)obj;
            return this.targetAssetIndex == other.targetAssetIndex && (this.originalFolderName == other.originalFolderName || this.originalFolderName.equals(other.originalFolderName)) && (this.newSharingPermission == other.newSharingPermission || this.newSharingPermission != null && this.newSharingPermission.equals(other.newSharingPermission)) && (this.previousSharingPermission == other.previousSharingPermission || this.previousSharingPermission != null && this.previousSharingPermission.equals(other.previousSharingPermission));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<SfTeamInviteChangeRoleDetails> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(SfTeamInviteChangeRoleDetails value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("target_asset_index");
            StoneSerializers.uInt64().serialize((Long)value.targetAssetIndex, g);
            g.writeFieldName("original_folder_name");
            StoneSerializers.string().serialize(value.originalFolderName, g);
            if (value.newSharingPermission != null) {
                g.writeFieldName("new_sharing_permission");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.newSharingPermission, g);
            }
            if (value.previousSharingPermission != null) {
                g.writeFieldName("previous_sharing_permission");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.previousSharingPermission, g);
            }
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public SfTeamInviteChangeRoleDetails deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            String f_previousSharingPermission;
            String f_newSharingPermission;
            String f_originalFolderName;
            Long f_targetAssetIndex;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_targetAssetIndex = null;
                f_originalFolderName = null;
                f_newSharingPermission = null;
                f_previousSharingPermission = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("target_asset_index".equals(field)) {
                        f_targetAssetIndex = StoneSerializers.uInt64().deserialize(p);
                        continue;
                    }
                    if ("original_folder_name".equals(field)) {
                        f_originalFolderName = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("new_sharing_permission".equals(field)) {
                        f_newSharingPermission = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("previous_sharing_permission".equals(field)) {
                        f_previousSharingPermission = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_targetAssetIndex == null) {
                    throw new JsonParseException(p, "Required field \"target_asset_index\" missing.");
                }
                if (f_originalFolderName == null) {
                    throw new JsonParseException(p, "Required field \"original_folder_name\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            SfTeamInviteChangeRoleDetails value = new SfTeamInviteChangeRoleDetails(f_targetAssetIndex, f_originalFolderName, f_newSharingPermission, f_previousSharingPermission);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }

    public static class Builder {
        protected final long targetAssetIndex;
        protected final String originalFolderName;
        protected String newSharingPermission;
        protected String previousSharingPermission;

        protected Builder(long targetAssetIndex, String originalFolderName) {
            this.targetAssetIndex = targetAssetIndex;
            if (originalFolderName == null) {
                throw new IllegalArgumentException("Required value for 'originalFolderName' is null");
            }
            this.originalFolderName = originalFolderName;
            this.newSharingPermission = null;
            this.previousSharingPermission = null;
        }

        public Builder withNewSharingPermission(String newSharingPermission) {
            this.newSharingPermission = newSharingPermission;
            return this;
        }

        public Builder withPreviousSharingPermission(String previousSharingPermission) {
            this.previousSharingPermission = previousSharingPermission;
            return this;
        }

        public SfTeamInviteChangeRoleDetails build() {
            return new SfTeamInviteChangeRoleDetails(this.targetAssetIndex, this.originalFolderName, this.newSharingPermission, this.previousSharingPermission);
        }
    }
}

