/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.airline;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Streams;
import io.airlift.airline.CommandFactory;
import io.airlift.airline.Context;
import io.airlift.airline.DefaultCommandFactory;
import io.airlift.airline.ParseArgumentsMissingException;
import io.airlift.airline.ParseArgumentsUnexpectedException;
import io.airlift.airline.ParseCommandMissingException;
import io.airlift.airline.ParseCommandUnrecognizedException;
import io.airlift.airline.ParseOptionMissingException;
import io.airlift.airline.ParseOptionMissingValueException;
import io.airlift.airline.ParseState;
import io.airlift.airline.Parser;
import io.airlift.airline.ParserUtil;
import io.airlift.airline.TypeConverter;
import io.airlift.airline.model.ArgumentsMetadata;
import io.airlift.airline.model.CommandMetadata;
import io.airlift.airline.model.GlobalMetadata;
import io.airlift.airline.model.MetadataLoader;
import io.airlift.airline.model.OptionMetadata;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class Cli<C> {
    private final GlobalMetadata metadata;

    public static <T> CliBuilder<T> builder(String name) {
        Objects.requireNonNull(name, "name is null");
        return new CliBuilder(name);
    }

    @Deprecated
    public static CliBuilder<Object> buildCli(String name) {
        return Cli.builder(name);
    }

    @Deprecated
    public static <T> CliBuilder<T> buildCli(String name, Class<T> commandTypes) {
        return Cli.builder(name);
    }

    private Cli(String name, String description, TypeConverter typeConverter, Class<? extends C> defaultCommand, Iterable<Class<? extends C>> defaultGroupCommands, Iterable<GroupBuilder<C>> groups) {
        Objects.requireNonNull(name, "name is null");
        Objects.requireNonNull(typeConverter, "typeConverter is null");
        CommandMetadata defaultCommandMetadata = null;
        if (defaultCommand != null) {
            defaultCommandMetadata = MetadataLoader.loadCommand(defaultCommand);
        }
        ImmutableList<CommandMetadata> defaultCommandGroup = MetadataLoader.loadCommands(defaultGroupCommands);
        List commandGroups = (List)Streams.stream(groups).map(group -> MetadataLoader.loadCommandGroup(((GroupBuilder)group).name, ((GroupBuilder)group).description, MetadataLoader.loadCommand(((GroupBuilder)group).defaultCommand), MetadataLoader.loadCommands(((GroupBuilder)group).commands))).collect(ImmutableList.toImmutableList());
        this.metadata = MetadataLoader.loadGlobal(name, description, defaultCommandMetadata, defaultCommandGroup, commandGroups);
    }

    public GlobalMetadata getMetadata() {
        return this.metadata;
    }

    public C parse(String ... args) {
        return this.parse((Iterable<String>)ImmutableList.copyOf((Object[])args));
    }

    public C parse(Iterable<String> args) {
        return (C)this.parse(new DefaultCommandFactory(), args);
    }

    public C parse(CommandFactory<C> commandFactory, String ... args) {
        return this.parse(commandFactory, (Iterable<String>)ImmutableList.copyOf((Object[])args));
    }

    public C parse(CommandFactory<C> commandFactory, Iterable<String> args) {
        Objects.requireNonNull(args, "args is null");
        Parser parser = new Parser();
        ParseState state = parser.parse(this.metadata, args);
        if (state.getCommand() == null) {
            state = state.getGroup() != null ? state.withCommand(state.getGroup().getDefaultCommand()) : state.withCommand(this.metadata.getDefaultCommand());
        }
        this.validate(state);
        CommandMetadata command = state.getCommand();
        return ParserUtil.createInstance(command.getType(), command.getAllOptions(), state.getParsedOptions(), command.getArguments(), state.getParsedArguments(), command.getMetadataInjections(), ImmutableMap.of(GlobalMetadata.class, (Object)this.metadata), commandFactory);
    }

    public C parse(C commandInstance, String ... args) {
        Objects.requireNonNull(args, "args is null");
        Parser parser = new Parser();
        ParseState state = parser.parse(this.metadata, args);
        if (state.getCommand() == null) {
            state = state.getGroup() != null ? state.withCommand(state.getGroup().getDefaultCommand()) : state.withCommand(this.metadata.getDefaultCommand());
        }
        this.validate(state);
        CommandMetadata command = state.getCommand();
        return ParserUtil.injectOptions(commandInstance, command.getAllOptions(), state.getParsedOptions(), command.getArguments(), state.getParsedArguments(), command.getMetadataInjections(), ImmutableMap.of(GlobalMetadata.class, (Object)this.metadata));
    }

    private void validate(ParseState state) {
        CommandMetadata command = state.getCommand();
        if (command == null) {
            List<String> unparsedInput = state.getUnparsedInput();
            if (unparsedInput.isEmpty()) {
                throw new ParseCommandMissingException();
            }
            throw new ParseCommandUnrecognizedException(unparsedInput);
        }
        ArgumentsMetadata arguments = command.getArguments();
        if (state.getParsedArguments().isEmpty() && arguments != null && arguments.isRequired()) {
            throw new ParseArgumentsMissingException(arguments.getTitle());
        }
        if (!state.getUnparsedInput().isEmpty()) {
            throw new ParseArgumentsUnexpectedException(state.getUnparsedInput());
        }
        if (state.getLocation() == Context.OPTION) {
            throw new ParseOptionMissingValueException(state.getCurrentOption().getTitle());
        }
        for (OptionMetadata option : command.getAllOptions()) {
            if (!option.isRequired() || state.getParsedOptions().containsKey((Object)option)) continue;
            throw new ParseOptionMissingException(option.getOptions().iterator().next());
        }
    }

    public static class GroupBuilder<C> {
        private final String name;
        private String description = null;
        private Class<? extends C> defaultCommand = null;
        private final List<Class<? extends C>> commands = new ArrayList<Class<? extends C>>();

        private GroupBuilder(String name) {
            Objects.requireNonNull(name, "name is null");
            this.name = name;
        }

        public GroupBuilder<C> withDescription(String description) {
            Objects.requireNonNull(description, "description is null");
            Preconditions.checkArgument((!description.isEmpty() ? 1 : 0) != 0, (Object)"description is empty");
            Preconditions.checkState((this.description == null ? 1 : 0) != 0, (Object)"description is already set");
            this.description = description;
            return this;
        }

        public GroupBuilder<C> withDefaultCommand(Class<? extends C> defaultCommand) {
            Objects.requireNonNull(defaultCommand, "defaultCommand is null");
            Preconditions.checkState((this.defaultCommand == null ? 1 : 0) != 0, (Object)"defaultCommand is already set");
            this.defaultCommand = defaultCommand;
            return this;
        }

        public GroupBuilder<C> withCommand(Class<? extends C> command) {
            Objects.requireNonNull(command, "command is null");
            this.commands.add(command);
            return this;
        }

        @SafeVarargs
        public final GroupBuilder<C> withCommands(Class<? extends C> command, Class<? extends C> ... moreCommands) {
            this.commands.add(command);
            this.commands.addAll((Collection<Class<C>>)ImmutableList.copyOf((Object[])moreCommands));
            return this;
        }

        public GroupBuilder<C> withCommands(Iterable<Class<? extends C>> commands) {
            this.commands.addAll((Collection<Class<C>>)ImmutableList.copyOf(commands));
            return this;
        }
    }

    public static class CliBuilder<C> {
        protected final String name;
        protected String description;
        protected TypeConverter typeConverter = new TypeConverter();
        protected String optionSeparators;
        private Class<? extends C> defaultCommand;
        private final List<Class<? extends C>> defaultCommandGroupCommands = new ArrayList<Class<? extends C>>();
        protected final Map<String, GroupBuilder<C>> groups = new HashMap<String, GroupBuilder<C>>();
        protected CommandFactory<C> commandFactory;

        public CliBuilder(String name) {
            Objects.requireNonNull(name, "name is null");
            Preconditions.checkArgument((!name.isEmpty() ? 1 : 0) != 0, (Object)"name is empty");
            this.name = name;
        }

        public CliBuilder<C> withDescription(String description) {
            Objects.requireNonNull(description, "description is null");
            Preconditions.checkArgument((!description.isEmpty() ? 1 : 0) != 0, (Object)"description is empty");
            this.description = description;
            return this;
        }

        public CliBuilder<C> withCommandFactory(CommandFactory<C> commandFactory) {
            Objects.requireNonNull(commandFactory, "commandFactory is null");
            this.commandFactory = commandFactory;
            return this;
        }

        public CliBuilder<C> withDefaultCommand(Class<? extends C> defaultCommand) {
            this.defaultCommand = defaultCommand;
            return this;
        }

        public CliBuilder<C> withCommand(Class<? extends C> command) {
            this.defaultCommandGroupCommands.add(command);
            return this;
        }

        @SafeVarargs
        public final CliBuilder<C> withCommands(Class<? extends C> command, Class<? extends C> ... moreCommands) {
            this.defaultCommandGroupCommands.add(command);
            this.defaultCommandGroupCommands.addAll((Collection<Class<C>>)ImmutableList.copyOf((Object[])moreCommands));
            return this;
        }

        public CliBuilder<C> withCommands(Iterable<Class<? extends C>> commands) {
            this.defaultCommandGroupCommands.addAll((Collection<Class<C>>)ImmutableList.copyOf(commands));
            return this;
        }

        public GroupBuilder<C> withGroup(String name) {
            Objects.requireNonNull(name, "name is null");
            Preconditions.checkArgument((!name.isEmpty() ? 1 : 0) != 0, (Object)"name is empty");
            if (this.groups.containsKey(name)) {
                return this.groups.get(name);
            }
            GroupBuilder group = new GroupBuilder(name);
            this.groups.put(name, group);
            return group;
        }

        public Cli<C> build() {
            return new Cli(this.name, this.description, this.typeConverter, this.defaultCommand, this.defaultCommandGroupCommands, this.groups.values());
        }
    }
}

