/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.vfs.minio;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.vfs2.provider.FileProvider;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.plugin.IVfs;
import org.apache.hop.core.vfs.plugin.VfsPlugin;
import org.apache.hop.metadata.serializer.multi.MultiMetadataProvider;
import org.apache.hop.metadata.util.HopMetadataUtil;
import org.apache.hop.vfs.minio.MinioFileProvider;
import org.apache.hop.vfs.minio.metadata.MinioMeta;

@VfsPlugin(type="minio", typeDescription="S3 VFS plugin", classLoaderGroup="vfs-s3")
public class MinioVfsPlugin
implements IVfs {
    public String[] getUrlSchemes() {
        return new String[0];
    }

    public FileProvider getProvider() {
        return new MinioFileProvider();
    }

    public Map<String, FileProvider> getProviders(IVariables variables) {
        HashMap<String, FileProvider> providers = new HashMap<String, FileProvider>();
        try {
            MultiMetadataProvider metadataProvider = HopMetadataUtil.getStandardHopMetadataProvider((IVariables)variables);
            List minioMetaTypes = metadataProvider.getSerializer(MinioMeta.class).loadAll();
            for (MinioMeta minioMeta : minioMetaTypes) {
                providers.put(minioMeta.getName(), (FileProvider)new MinioFileProvider(variables, minioMeta));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return providers;
    }
}

