/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.micro;

import com.ibm.as400.access.Trace;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

class MicroDataOutputStream {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    DataOutputStream out_;

    public MicroDataOutputStream(OutputStream out) throws IOException {
        this.out_ = new DataOutputStream(out);
    }

    public void flush() throws IOException {
        this.out_.flush();
    }

    public void writeBoolean(boolean b) throws IOException {
        if (Trace.isTraceOn()) {
            Trace.log(6, Thread.currentThread().getName() + " out < " + b);
        }
        this.out_.writeBoolean(b);
    }

    public void writeByte(byte b) throws IOException {
        if (Trace.isTraceOn()) {
            Trace.log(6, Thread.currentThread().getName() + " out < " + b);
        }
        this.out_.writeByte(b);
    }

    public void writeBytes(byte[] b) throws IOException {
        if (Trace.isTraceOn()) {
            Trace.log(6, "  " + Thread.currentThread().getName() + " out < ", b);
        }
        this.out_.write(b, 0, b.length);
    }

    public void writeDouble(double d) throws IOException {
        if (Trace.isTraceOn()) {
            Trace.log(6, Thread.currentThread().getName() + " out < " + d);
        }
        this.out_.writeDouble(d);
    }

    public void writeFloat(float f) throws IOException {
        if (Trace.isTraceOn()) {
            Trace.log(6, Thread.currentThread().getName() + " out < " + f);
        }
        this.out_.writeFloat(f);
    }

    public void writeInt(int i) throws IOException {
        if (Trace.isTraceOn()) {
            Trace.log(6, Thread.currentThread().getName() + " out < " + Integer.toHexString(i));
        }
        this.out_.writeInt(i);
    }

    public void writeLong(long l) throws IOException {
        if (Trace.isTraceOn()) {
            Trace.log(6, Thread.currentThread().getName() + " out < " + l);
        }
        this.out_.writeLong(l);
    }

    public void writeShort(short s) throws IOException {
        if (Trace.isTraceOn()) {
            Trace.log(6, Thread.currentThread().getName() + " out < " + s);
        }
        this.out_.writeShort(s);
    }

    public void writeString(String s) throws IOException {
        this.writeUTF(s);
    }

    public void writeUTF(String s) throws IOException {
        if (Trace.isTraceOn()) {
            Trace.log(6, Thread.currentThread().getName() + " out < " + s);
        }
        this.out_.writeUTF(s);
    }
}

