/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sqs.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.sqs.model.MessageSystemAttributeValue;
import java.nio.ByteBuffer;
import java.util.List;

@SdkInternalApi
public class MessageSystemAttributeValueMarshaller {
    private static final MarshallingInfo<String> STRINGVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StringValue").build();
    private static final MarshallingInfo<ByteBuffer> BINARYVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BYTE_BUFFER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BinaryValue").build();
    private static final MarshallingInfo<List> STRINGLISTVALUES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StringListValues").build();
    private static final MarshallingInfo<List> BINARYLISTVALUES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BinaryListValues").build();
    private static final MarshallingInfo<String> DATATYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DataType").build();
    private static final MessageSystemAttributeValueMarshaller instance = new MessageSystemAttributeValueMarshaller();

    public static MessageSystemAttributeValueMarshaller getInstance() {
        return instance;
    }

    public void marshall(MessageSystemAttributeValue messageSystemAttributeValue, ProtocolMarshaller protocolMarshaller) {
        if (messageSystemAttributeValue == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)messageSystemAttributeValue.getStringValue(), STRINGVALUE_BINDING);
            protocolMarshaller.marshall((Object)messageSystemAttributeValue.getBinaryValue(), BINARYVALUE_BINDING);
            protocolMarshaller.marshall(messageSystemAttributeValue.getStringListValues(), STRINGLISTVALUES_BINDING);
            protocolMarshaller.marshall(messageSystemAttributeValue.getBinaryListValues(), BINARYLISTVALUES_BINDING);
            protocolMarshaller.marshall((Object)messageSystemAttributeValue.getDataType(), DATATYPE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

