/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms.join;

import java.util.ArrayList;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.Flatten;
import org.apache.beam.sdk.transforms.GroupByKey;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.join.CoGbkResult;
import org.apache.beam.sdk.transforms.join.CoGbkResultSchema;
import org.apache.beam.sdk.transforms.join.KeyedPCollectionTuple;
import org.apache.beam.sdk.transforms.join.RawUnionValue;
import org.apache.beam.sdk.transforms.join.UnionCoder;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class CoGroupByKey<@UnknownKeyFor K>
extends PTransform<KeyedPCollectionTuple<K>, PCollection<KV<K, CoGbkResult>>> {
    public static <K> @UnknownKeyFor @NonNull @Initialized CoGroupByKey<K> create() {
        return new CoGroupByKey<K>();
    }

    private CoGroupByKey() {
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized CoGbkResult>> expand(@UnknownKeyFor @NonNull @Initialized KeyedPCollectionTuple<K> input) {
        if (input.isEmpty()) {
            throw new IllegalArgumentException("must have at least one input to a KeyedPCollections");
        }
        ArrayList codersList = new ArrayList();
        for (KeyedPCollectionTuple.TaggedKeyedPCollection<K, ?> entry : input.getKeyedCollections()) {
            codersList.add(this.getValueCoder(entry.pCollection));
        }
        UnionCoder unionCoder = UnionCoder.of(codersList);
        Coder<K> keyCoder = input.getKeyCoder();
        KvCoder<K, RawUnionValue> kVCoder = KvCoder.of(keyCoder, unionCoder);
        PCollectionList unionTables = PCollectionList.empty(input.getPipeline());
        int index = -1;
        for (KeyedPCollectionTuple.TaggedKeyedPCollection<K, ?> entry : input.getKeyedCollections()) {
            PCollection unionTable = this.makeUnionTable(++index, entry.pCollection, kVCoder);
            unionTables = unionTables.and(unionTable);
        }
        PCollection flattenedTable = (PCollection)unionTables.apply("Flatten", Flatten.pCollections());
        PCollection groupedTable = (PCollection)flattenedTable.apply("GBK", GroupByKey.create());
        CoGbkResultSchema tupleTags = input.getCoGbkResultSchema();
        PCollection result = (PCollection)groupedTable.apply("ConstructCoGbkResultFn", ParDo.of(new ConstructCoGbkResultFn(tupleTags)));
        result.setCoder(KvCoder.of(keyCoder, CoGbkResult.CoGbkResultCoder.of(tupleTags, unionCoder)));
        return result;
    }

    private <V> @UnknownKeyFor @NonNull @Initialized Coder<V> getValueCoder(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, V>> pCollection) {
        Coder<KV<K, V>> entryCoder = pCollection.getCoder();
        if (!(entryCoder instanceof KvCoder)) {
            throw new IllegalArgumentException("PCollection does not use a KvCoder");
        }
        KvCoder coder = (KvCoder)entryCoder;
        return coder.getValueCoder();
    }

    private <V> @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized RawUnionValue>> makeUnionTable(@UnknownKeyFor @NonNull @Initialized int index, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, V>> pCollection, @UnknownKeyFor @NonNull @Initialized KvCoder<K, @UnknownKeyFor @NonNull @Initialized RawUnionValue> unionTableEncoder) {
        return ((PCollection)pCollection.apply("MakeUnionTable" + index, ParDo.of(new ConstructUnionTableFn(index)))).setCoder(unionTableEncoder);
    }

    private static class ConstructCoGbkResultFn<@UnknownKeyFor K>
    extends DoFn<KV<K, Iterable<RawUnionValue>>, KV<K, CoGbkResult>> {
        private final @UnknownKeyFor @NonNull @Initialized CoGbkResultSchema schema;

        public ConstructCoGbkResultFn(@UnknownKeyFor @NonNull @Initialized CoGbkResultSchema schema) {
            this.schema = schema;
        }

        @DoFn.ProcessElement
        public void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) {
            KV e = (KV)c.element();
            c.output(KV.of(e.getKey(), new CoGbkResult(this.schema, (Iterable)e.getValue())));
        }
    }

    private static class ConstructUnionTableFn<@UnknownKeyFor K, @UnknownKeyFor V>
    extends DoFn<KV<K, V>, KV<K, RawUnionValue>> {
        private final @UnknownKeyFor @NonNull @Initialized int index;

        public ConstructUnionTableFn(@UnknownKeyFor @NonNull @Initialized int index) {
            this.index = index;
        }

        @DoFn.ProcessElement
        public void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) {
            KV e = (KV)c.element();
            c.output(KV.of(e.getKey(), new RawUnionValue(this.index, e.getValue())));
        }
    }
}

