/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.mail.pipeline.transforms.mail;

import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.activation.URLDataSource;
import jakarta.mail.Address;
import jakarta.mail.BodyPart;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.Session;
import jakarta.mail.Transport;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import jakarta.mail.util.ByteArrayDataSource;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashSet;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelectInfo;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileType;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.mail.metadata.MailServerConnection;
import org.apache.hop.mail.pipeline.transforms.mail.MailData;
import org.apache.hop.mail.pipeline.transforms.mail.MailMeta;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;

public class Mail
extends BaseTransform<MailMeta, MailData> {
    private static final Class<?> PKG = MailMeta.class;
    public static final String CONST_MAIL = "mail.";
    private MailServerConnection connection;

    public Mail(TransformMeta transformMeta, MailMeta meta, MailData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processRow() throws HopException {
        block95: {
            Object[] r = this.getRow();
            if (r == null) {
                this.setOutputDone();
                return false;
            }
            if (this.first) {
                this.first = false;
                Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
                ((MailData)this.data).previousRowMeta = this.getInputRowMeta().clone();
                if (((MailMeta)this.meta).isAddMessageToOutput()) {
                    if (Utils.isEmpty((CharSequence)this.variables.resolve(((MailMeta)this.meta).getMessageOutputField()))) {
                        throw new HopException(BaseMessages.getString(PKG, (String)"Mail.Log.OutputFieldEmpty", (String[])new String[0]));
                    }
                    ((MailData)this.data).previousRowMeta.addValueMeta((IValueMeta)new ValueMetaString(this.variables.resolve(((MailMeta)this.meta).getMessageOutputField())));
                }
                if (Utils.isEmpty((CharSequence)((MailMeta)this.meta).getDestination())) {
                    throw new HopException(BaseMessages.getString(PKG, (String)"Mail.Log.DestinationFieldEmpty", (String[])new String[0]));
                }
                if (Utils.isEmpty((CharSequence)((MailMeta)this.meta).getReplyAddress())) {
                    throw new HopException(BaseMessages.getString(PKG, (String)"Mail.Log.ReplyFieldEmpty", (String[])new String[0]));
                }
                if (StringUtils.isEmpty((String)((MailMeta)this.meta).getConnectionName()) && Utils.isEmpty((CharSequence)((MailMeta)this.meta).getServer())) {
                    throw new HopException(BaseMessages.getString(PKG, (String)"Mail.Log.ServerFieldEmpty", (String[])new String[0]));
                }
                if (((MailMeta)this.meta).isFilenameDynamic() && Utils.isEmpty((CharSequence)((MailMeta)this.meta).getDynamicFieldname())) {
                    throw new HopException(BaseMessages.getString(PKG, (String)"Mail.Log.DynamicFilenameFielddEmpty", (String[])new String[0]));
                }
                if (((MailMeta)this.meta).isZipFiles()) {
                    if (((MailMeta)this.meta).isZipFilenameDynamic() && Utils.isEmpty((CharSequence)((MailMeta)this.meta).getDynamicZipFilename())) {
                        throw new HopException(BaseMessages.getString(PKG, (String)"Mail.Log.DynamicZipFilenameFieldEmpty", (String[])new String[0]));
                    }
                    if (!((MailMeta)this.meta).isZipFilenameDynamic() && Utils.isEmpty((CharSequence)((MailMeta)this.meta).getZipFilename())) {
                        throw new HopException(BaseMessages.getString(PKG, (String)"Mail.Log.ZipFilenameEmpty", (String[])new String[0]));
                    }
                }
                if (StringUtils.isEmpty((String)((MailMeta)this.meta).getConnectionName()) && ((MailMeta)this.meta).isUsingAuthentication()) {
                    if (Utils.isEmpty((CharSequence)((MailMeta)this.meta).getAuthenticationUser())) {
                        throw new HopException(BaseMessages.getString(PKG, (String)"Mail.Log.AuthenticationUserFieldEmpty", (String[])new String[0]));
                    }
                    if (Utils.isEmpty((CharSequence)((MailMeta)this.meta).getAuthenticationPassword())) {
                        throw new HopException(BaseMessages.getString(PKG, (String)"Mail.Log.AuthenticationPasswordFieldEmpty", (String[])new String[0]));
                    }
                }
                if (((MailData)this.data).indexOfDestination < 0) {
                    String realDestinationFieldname = ((MailMeta)this.meta).getDestination();
                    ((MailData)this.data).indexOfDestination = ((MailData)this.data).previousRowMeta.indexOfValue(realDestinationFieldname);
                    if (((MailData)this.data).indexOfDestination < 0) {
                        throw new HopException(BaseMessages.getString(PKG, (String)"Mail.Exception.CouldnotFindDestinationField", (String[])new String[]{realDestinationFieldname}));
                    }
                }
                if (!Utils.isEmpty((CharSequence)((MailMeta)this.meta).getDestinationCc()) && ((MailData)this.data).indexOfDestinationCc < 0) {
                    String realDestinationCcFieldname = ((MailMeta)this.meta).getDestinationCc();
                    ((MailData)this.data).indexOfDestinationCc = ((MailData)this.data).previousRowMeta.indexOfValue(realDestinationCcFieldname);
                    if (((MailData)this.data).indexOfDestinationCc < 0) {
                        throw new HopException(BaseMessages.getString(PKG, (String)"Mail.Exception.CouldnotFindDestinationCcField", (String[])new String[]{realDestinationCcFieldname}));
                    }
                }
                if (!Utils.isEmpty((CharSequence)((MailMeta)this.meta).getDestinationBCc()) && ((MailData)this.data).indexOfDestinationBCc < 0) {
                    String realDestinationBCcFieldname = ((MailMeta)this.meta).getDestinationBCc();
                    ((MailData)this.data).indexOfDestinationBCc = ((MailData)this.data).previousRowMeta.indexOfValue(realDestinationBCcFieldname);
                    if (((MailData)this.data).indexOfDestinationBCc < 0) {
                        throw new HopException(BaseMessages.getString(PKG, (String)"Mail.Exception.CouldnotFindDestinationBCcField", (String[])new String[]{realDestinationBCcFieldname}));
                    }
                }
                if (!Utils.isEmpty((CharSequence)((MailMeta)this.meta).getReplyName()) && ((MailData)this.data).indexOfSenderName < 0) {
                    String realSenderName = ((MailMeta)this.meta).getReplyName();
                    ((MailData)this.data).indexOfSenderName = ((MailData)this.data).previousRowMeta.indexOfValue(realSenderName);
                    if (((MailData)this.data).indexOfSenderName < 0) {
                        throw new HopException(BaseMessages.getString(PKG, (String)"Mail.Exception.CouldnotFindReplyNameField", (String[])new String[]{realSenderName}));
                    }
                }
                if (((MailData)this.data).indexOfSenderAddress < 0) {
                    String realSenderAddress = ((MailMeta)this.meta).getReplyAddress();
                    ((MailData)this.data).indexOfSenderAddress = ((MailData)this.data).previousRowMeta.indexOfValue(realSenderAddress);
                    if (((MailData)this.data).indexOfSenderAddress < 0) {
                        throw new HopException(BaseMessages.getString(PKG, (String)"Mail.Exception.CouldnotFindReplyAddressField", (String[])new String[]{realSenderAddress}));
                    }
                }
                if (!Utils.isEmpty((CharSequence)((MailMeta)this.meta).getReplyToAddresses()) && ((MailData)this.data).indexOfReplyToAddresses < 0) {
                    String realReplyToAddresses = ((MailMeta)this.meta).getReplyToAddresses();
                    ((MailData)this.data).indexOfReplyToAddresses = ((MailData)this.data).previousRowMeta.indexOfValue(realReplyToAddresses);
                    if (((MailData)this.data).indexOfReplyToAddresses < 0) {
                        throw new HopException(BaseMessages.getString(PKG, (String)"Mail.Exception.CouldnotFindReplyToAddressesField", (String[])new String[]{realReplyToAddresses}));
                    }
                }
                if (!Utils.isEmpty((CharSequence)((MailMeta)this.meta).getContactPerson()) && ((MailData)this.data).indexOfContactPerson < 0) {
                    String realContactPerson = ((MailMeta)this.meta).getContactPerson();
                    ((MailData)this.data).indexOfContactPerson = ((MailData)this.data).previousRowMeta.indexOfValue(realContactPerson);
                    if (((MailData)this.data).indexOfContactPerson < 0) {
                        throw new HopException(BaseMessages.getString(PKG, (String)"Mail.Exception.CouldnotFindContactPersonField", (String[])new String[]{realContactPerson}));
                    }
                }
                if (!Utils.isEmpty((CharSequence)((MailMeta)this.meta).getContactPhone()) && ((MailData)this.data).indexOfContactPhone < 0) {
                    String realContactPhone = ((MailMeta)this.meta).getContactPhone();
                    ((MailData)this.data).indexOfContactPhone = ((MailData)this.data).previousRowMeta.indexOfValue(realContactPhone);
                    if (((MailData)this.data).indexOfContactPhone < 0) {
                        throw new HopException(BaseMessages.getString(PKG, (String)"Mail.Exception.CouldnotFindContactPhoneField", (String[])new String[]{realContactPhone}));
                    }
                }
                if (StringUtils.isEmpty((String)((MailMeta)this.meta).getConnectionName()) && ((MailData)this.data).indexOfServer < 0) {
                    String realServer = ((MailMeta)this.meta).getServer();
                    ((MailData)this.data).indexOfServer = ((MailData)this.data).previousRowMeta.indexOfValue(realServer);
                    if (((MailData)this.data).indexOfServer < 0) {
                        throw new HopException(BaseMessages.getString(PKG, (String)"Mail.Exception.CouldnotFindServerField", (String[])new String[]{realServer}));
                    }
                }
                if (StringUtils.isEmpty((String)((MailMeta)this.meta).getConnectionName()) && !Utils.isEmpty((CharSequence)((MailMeta)this.meta).getPort()) && ((MailData)this.data).indexOfPort < 0) {
                    String realPort = ((MailMeta)this.meta).getPort();
                    ((MailData)this.data).indexOfPort = ((MailData)this.data).previousRowMeta.indexOfValue(realPort);
                    if (((MailData)this.data).indexOfPort < 0) {
                        throw new HopException(BaseMessages.getString(PKG, (String)"Mail.Exception.CouldnotFindPortField", (String[])new String[]{realPort}));
                    }
                }
                if (StringUtils.isEmpty((String)((MailMeta)this.meta).getConnectionName()) && ((MailMeta)this.meta).isUsingAuthentication()) {
                    if (((MailData)this.data).indexOfAuthenticationUser < 0) {
                        String realAuthenticationUser = ((MailMeta)this.meta).getAuthenticationUser();
                        ((MailData)this.data).indexOfAuthenticationUser = ((MailData)this.data).previousRowMeta.indexOfValue(realAuthenticationUser);
                        if (((MailData)this.data).indexOfAuthenticationUser < 0) {
                            throw new HopException(BaseMessages.getString(PKG, (String)"Mail.Exception.CouldnotFindAuthenticationUserField", (String[])new String[]{realAuthenticationUser}));
                        }
                    }
                    if (((MailData)this.data).indexOfAuthenticationPass < 0) {
                        String realAuthenticationPassword = ((MailMeta)this.meta).getAuthenticationPassword();
                        ((MailData)this.data).indexOfAuthenticationPass = ((MailData)this.data).previousRowMeta.indexOfValue(realAuthenticationPassword);
                        if (((MailData)this.data).indexOfAuthenticationPass < 0) {
                            throw new HopException(BaseMessages.getString(PKG, (String)"Mail.Exception.CouldnotFindAuthenticationPassField", (String[])new String[]{realAuthenticationPassword}));
                        }
                    }
                }
                if (!Utils.isEmpty((CharSequence)((MailMeta)this.meta).getSubject()) && ((MailData)this.data).indexOfSubject < 0) {
                    String realSubject = ((MailMeta)this.meta).getSubject();
                    ((MailData)this.data).indexOfSubject = ((MailData)this.data).previousRowMeta.indexOfValue(realSubject);
                    if (((MailData)this.data).indexOfSubject < 0) {
                        throw new HopException(BaseMessages.getString(PKG, (String)"Mail.Exception.CouldnotFindSubjectField", (String[])new String[]{realSubject}));
                    }
                }
                if (!Utils.isEmpty((CharSequence)((MailMeta)this.meta).getComment()) && ((MailData)this.data).indexOfComment < 0) {
                    String realComment = ((MailMeta)this.meta).getComment();
                    ((MailData)this.data).indexOfComment = ((MailData)this.data).previousRowMeta.indexOfValue(realComment);
                    if (((MailData)this.data).indexOfComment < 0) {
                        throw new HopException(BaseMessages.getString(PKG, (String)"Mail.Exception.CouldnotFindCommentField", (String[])new String[]{realComment}));
                    }
                }
                if (((MailMeta)this.meta).isAttachContentFromField()) {
                    String attachedContentField = ((MailMeta)this.meta).getAttachContentField();
                    if (Utils.isEmpty((CharSequence)attachedContentField)) {
                        throw new HopException(BaseMessages.getString(PKG, (String)"Mail.Exception.AttachedContentFieldEmpty", (String[])new String[0]));
                    }
                    ((MailData)this.data).indexOfAttachedContent = ((MailData)this.data).previousRowMeta.indexOfValue(attachedContentField);
                    if (((MailData)this.data).indexOfAttachedContent < 0) {
                        throw new HopException(BaseMessages.getString(PKG, (String)"Mail.Exception.CouldnotFindAttachedContentField", (String[])new String[]{attachedContentField}));
                    }
                    String attachedContentFileNameField = ((MailMeta)this.meta).getAttachContentFileNameField();
                    if (Utils.isEmpty((CharSequence)attachedContentFileNameField)) {
                        throw new HopException(BaseMessages.getString(PKG, (String)"Mail.Exception.AttachedContentFileNameFieldEmpty", (String[])new String[0]));
                    }
                    ((MailData)this.data).indexOfAttachedFilename = ((MailData)this.data).previousRowMeta.indexOfValue(attachedContentFileNameField);
                    if (((MailData)this.data).indexOfAttachedFilename < 0) {
                        throw new HopException(BaseMessages.getString(PKG, (String)"Mail.Exception.CouldnotFindAttachedContentFileNameField", (String[])new String[]{attachedContentFileNameField}));
                    }
                } else {
                    if (((MailMeta)this.meta).isZipFilenameDynamic() && ((MailData)this.data).indexOfDynamicZipFilename < 0) {
                        String realZipFilename = ((MailMeta)this.meta).getDynamicZipFilename();
                        ((MailData)this.data).indexOfDynamicZipFilename = ((MailData)this.data).previousRowMeta.indexOfValue(realZipFilename);
                        if (((MailData)this.data).indexOfDynamicZipFilename < 0) {
                            throw new HopException(BaseMessages.getString(PKG, (String)"Mail.Exception.CouldnotSourceAttachedZipFilenameField", (String[])new String[]{realZipFilename}));
                        }
                    }
                    ((MailData)this.data).zipFileLimit = Const.toLong((String)this.resolve(((MailMeta)this.meta).getZiplimitsize()), (long)0L);
                    if (((MailData)this.data).zipFileLimit > 0L) {
                        ((MailData)this.data).zipFileLimit *= 0x100000L;
                    }
                    if (!((MailMeta)this.meta).isZipFilenameDynamic()) {
                        ((MailData)this.data).ZipFilename = this.resolve(((MailMeta)this.meta).getZipFilename());
                    }
                    if (((MailMeta)this.meta).isFilenameDynamic()) {
                        if (((MailData)this.data).indexOfSourceFilename < 0) {
                            String realSourceattachedFilename = ((MailMeta)this.meta).getDynamicFieldname();
                            ((MailData)this.data).indexOfSourceFilename = ((MailData)this.data).previousRowMeta.indexOfValue(realSourceattachedFilename);
                            if (((MailData)this.data).indexOfSourceFilename < 0) {
                                throw new HopException(BaseMessages.getString(PKG, (String)"Mail.Exception.CouldnotSourceAttachedFilenameField", (String[])new String[]{realSourceattachedFilename}));
                            }
                        }
                        if (!Utils.isEmpty((CharSequence)((MailMeta)this.meta).getSourcewildcard()) && ((MailData)this.data).indexOfSourceWildcard < 0) {
                            String realSourceattachedWildcard = ((MailMeta)this.meta).getDynamicWildcard();
                            ((MailData)this.data).indexOfSourceWildcard = ((MailData)this.data).previousRowMeta.indexOfValue(realSourceattachedWildcard);
                            if (((MailData)this.data).indexOfSourceWildcard < 0) {
                                throw new HopException(BaseMessages.getString(PKG, (String)"Mail.Exception.CouldnotSourceAttachedWildcard", (String[])new String[]{realSourceattachedWildcard}));
                            }
                        }
                    } else {
                        ((MailData)this.data).realSourceFileFoldername = this.resolve(((MailMeta)this.meta).getSourcefilefoldername());
                        ((MailData)this.data).realSourceWildcard = this.resolve(((MailMeta)this.meta).getSourcewildcard());
                    }
                }
                if (!Utils.isEmpty(((MailMeta)this.meta).getEmbeddedImages())) {
                    FileObject image = null;
                    ((MailData)this.data).embeddedMimePart = new HashSet();
                    try {
                        for (int i = 0; i < ((MailMeta)this.meta).getEmbeddedImages().size(); ++i) {
                            String imageFile = this.resolve(((MailMeta)this.meta).getEmbeddedImages().get(i).getEmbeddedimage());
                            String contentID = this.resolve(((MailMeta)this.meta).getEmbeddedImages().get(i).getContentId());
                            image = HopVfs.getFileObject((String)imageFile, (IVariables)this.variables);
                            if (image.exists() && image.getType() == FileType.FILE) {
                                MimeBodyPart imagePart = new MimeBodyPart();
                                URLDataSource fds = new URLDataSource(image.getURL());
                                imagePart.setDataHandler(new DataHandler((DataSource)fds));
                                imagePart.setHeader("Content-ID", "<" + contentID + ">");
                                ((MailData)this.data).embeddedMimePart.add(imagePart);
                                this.logBasic(BaseMessages.getString(PKG, (String)"Mail.Log.ImageAdded", (String[])new String[]{imageFile}));
                                continue;
                            }
                            this.logError(BaseMessages.getString(PKG, (String)"Mail.Log.WrongImage", (String[])new String[]{imageFile}));
                        }
                    }
                    catch (Exception e) {
                        this.logError(BaseMessages.getString(PKG, (String)"Mail.Error.AddingImage", (String[])new String[]{e.getMessage()}));
                    }
                    finally {
                        if (image != null) {
                            try {
                                image.close();
                            }
                            catch (Exception e) {}
                        }
                    }
                }
            }
            boolean sendToErrorRow = false;
            String errorMessage = null;
            try {
                String maildestination = ((MailData)this.data).previousRowMeta.getString(r, ((MailData)this.data).indexOfDestination);
                if (Utils.isEmpty((CharSequence)maildestination)) {
                    throw new HopException("Mail.Error.MailDestinationEmpty");
                }
                String maildestinationCc = null;
                if (((MailData)this.data).indexOfDestinationCc > -1) {
                    maildestinationCc = ((MailData)this.data).previousRowMeta.getString(r, ((MailData)this.data).indexOfDestinationCc);
                }
                String maildestinationBCc = null;
                if (((MailData)this.data).indexOfDestinationBCc > -1) {
                    maildestinationBCc = ((MailData)this.data).previousRowMeta.getString(r, ((MailData)this.data).indexOfDestinationBCc);
                }
                String mailsendername = null;
                if (((MailData)this.data).indexOfSenderName > -1) {
                    mailsendername = ((MailData)this.data).previousRowMeta.getString(r, ((MailData)this.data).indexOfSenderName);
                }
                String mailsenderaddress = ((MailData)this.data).previousRowMeta.getString(r, ((MailData)this.data).indexOfSenderAddress);
                String mailreplyToAddresses = null;
                if (((MailData)this.data).indexOfReplyToAddresses > -1) {
                    mailreplyToAddresses = ((MailData)this.data).previousRowMeta.getString(r, ((MailData)this.data).indexOfReplyToAddresses);
                }
                String contactperson = null;
                if (((MailData)this.data).indexOfContactPerson > -1) {
                    contactperson = ((MailData)this.data).previousRowMeta.getString(r, ((MailData)this.data).indexOfContactPerson);
                }
                String contactphone = null;
                if (((MailData)this.data).indexOfContactPhone > -1) {
                    contactphone = ((MailData)this.data).previousRowMeta.getString(r, ((MailData)this.data).indexOfContactPhone);
                }
                String servername = null;
                int port = -1;
                String authuser = null;
                String authpass = null;
                if (StringUtils.isEmpty((String)((MailMeta)this.meta).getConnectionName())) {
                    servername = ((MailData)this.data).previousRowMeta.getString(r, ((MailData)this.data).indexOfServer);
                    if (Utils.isEmpty((CharSequence)servername)) {
                        throw new HopException("Mail.Error.MailServerEmpty");
                    }
                    if (((MailData)this.data).indexOfPort > -1) {
                        port = Const.toInt((String)("" + ((MailData)this.data).previousRowMeta.getInteger(r, ((MailData)this.data).indexOfPort)), (int)-1);
                    }
                    if (StringUtils.isEmpty((String)((MailMeta)this.meta).getConnectionName()) && ((MailData)this.data).indexOfAuthenticationUser > -1) {
                        authuser = ((MailData)this.data).previousRowMeta.getString(r, ((MailData)this.data).indexOfAuthenticationUser);
                    }
                    if (StringUtils.isEmpty((String)((MailMeta)this.meta).getConnectionName()) && ((MailData)this.data).indexOfAuthenticationPass > -1) {
                        authpass = Utils.resolvePassword((IVariables)this.variables, (String)((MailData)this.data).previousRowMeta.getString(r, ((MailData)this.data).indexOfAuthenticationPass));
                    }
                }
                String subject = null;
                if (((MailData)this.data).indexOfSubject > -1) {
                    subject = ((MailData)this.data).previousRowMeta.getString(r, ((MailData)this.data).indexOfSubject);
                }
                String comment = null;
                if (((MailData)this.data).indexOfComment > -1) {
                    comment = ((MailData)this.data).previousRowMeta.getString(r, ((MailData)this.data).indexOfComment);
                }
                String message = this.sendMail(r, servername, port, mailsenderaddress, mailsendername, maildestination, maildestinationCc, maildestinationBCc, contactperson, contactphone, authuser, authpass, subject, comment, mailreplyToAddresses);
                if (((MailMeta)this.meta).isAddMessageToOutput()) {
                    int index = ((MailData)this.data).previousRowMeta.indexOfValue(this.resolve(((MailMeta)this.meta).getMessageOutputField()));
                    Object[] outputRowData = RowDataUtil.createResizedCopy((Object[])r, (int)((MailData)this.data).previousRowMeta.size());
                    outputRowData[index] = message;
                    this.putRow(((MailData)this.data).previousRowMeta, outputRowData);
                } else {
                    this.putRow(((MailData)this.data).previousRowMeta, r);
                }
                if (this.isRowLevel()) {
                    this.logRowlevel(BaseMessages.getString(PKG, (String)"Mail.Log.LineNumber", (String[])new String[]{this.getLinesRead() + " : " + this.getInputRowMeta().getString(r)}));
                }
            }
            catch (Exception e) {
                if (!this.getTransformMeta().isDoingErrorHandling()) {
                    throw new HopException(BaseMessages.getString(PKG, (String)"Mail.Error.General", (String[])new String[0]), (Throwable)e);
                }
                sendToErrorRow = true;
                errorMessage = e.toString();
                if (!sendToErrorRow) break block95;
                this.putError(this.getInputRowMeta(), r, 1L, errorMessage, null, "MAIL001");
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String sendMail(Object[] r, String server, int port, String senderAddress, String senderName, String destination, String destinationCc, String destinationBCc, String contactPerson, String contactPhone, String authenticationUser, String authenticationPassword, String mailsubject, String comment, String replyToAddresses) throws Exception {
        String realdestinationBCc;
        int i;
        InternetAddress[] address;
        Object emailAddress;
        Session session = null;
        String protocol = null;
        if (!StringUtils.isEmpty((String)((MailMeta)this.meta).getConnectionName())) {
            this.connection = (MailServerConnection)this.getMetadataProvider().getSerializer(MailServerConnection.class).load(((MailMeta)this.meta).getConnectionName());
            session = this.connection.getSession(this.variables);
        } else {
            protocol = "smtp";
            if (((MailMeta)this.meta).isUsingSecureAuthentication()) {
                if (((MailMeta)this.meta).isUsexoauth2()) {
                    ((MailData)this.data).props.put("mail.smtp.ssl.enable", "true");
                    ((MailData)this.data).props.put("mail.smtp.auth.mechanisms", "XOAUTH2");
                }
                if (((MailMeta)this.meta).getSecureConnectionType().equals("TLS")) {
                    ((MailData)this.data).props.put("mail.smtp.starttls.enable", "true");
                } else if (((MailMeta)this.meta).getSecureConnectionType().equals("TLS 1.2")) {
                    ((MailData)this.data).props.put("mail.smtp.starttls.enable", "true");
                    ((MailData)this.data).props.put("mail.smtp.ssl.protocols", "TLSv1.2");
                } else {
                    protocol = "smtps";
                    ((MailData)this.data).props.put("mail.smtps.quitwait", "false");
                }
            }
            ((MailData)this.data).props.put(CONST_MAIL + protocol + ".host", server);
            if (port != -1) {
                ((MailData)this.data).props.put(CONST_MAIL + protocol + ".port", "" + port);
            }
            if (this.isDebug()) {
                ((MailData)this.data).props.put("mail.debug", "true");
            }
            if (((MailMeta)this.meta).isUsingAuthentication()) {
                ((MailData)this.data).props.put(CONST_MAIL + protocol + ".auth", "true");
            }
            session = Session.getInstance((Properties)((MailData)this.data).props);
        }
        session.setDebug(this.isDebug());
        MimeMessage msg = new MimeMessage(session);
        if (((MailMeta)this.meta).isUsePriority()) {
            String priorityInt = "1";
            if (((MailMeta)this.meta).getPriority().equals("low")) {
                priorityInt = "3";
            }
            if (((MailMeta)this.meta).getPriority().equals("normal")) {
                priorityInt = "2";
            }
            msg.setHeader("X-Priority", priorityInt);
            msg.setHeader("Importance", ((MailMeta)this.meta).getImportance());
            msg.setHeader("Sensitivity", ((MailMeta)this.meta).getSensitivity());
        }
        if (!Utils.isEmpty((CharSequence)(emailAddress = senderAddress))) {
            if (!Utils.isEmpty((CharSequence)senderName)) {
                emailAddress = senderName + "<" + (String)emailAddress + ">";
            }
        } else {
            throw new MessagingException(BaseMessages.getString(PKG, (String)"Mail.Error.ReplyEmailNotFilled", (String[])new String[0]));
        }
        msg.setFrom((Address)new InternetAddress((String)emailAddress));
        if (!Utils.isEmpty((CharSequence)replyToAddresses)) {
            String[] replyAddressList = replyToAddresses.split(" ");
            address = new InternetAddress[replyAddressList.length];
            for (i = 0; i < replyAddressList.length; ++i) {
                address[i] = new InternetAddress(replyAddressList[i]);
            }
            msg.setReplyTo((Address[])address);
        }
        String[] destinations = destination.split(" ");
        address = new InternetAddress[destinations.length];
        for (i = 0; i < destinations.length; ++i) {
            address[i] = new InternetAddress(destinations[i]);
        }
        msg.setRecipients(Message.RecipientType.TO, (Address[])address);
        String realdestinationCc = destinationCc;
        if (!Utils.isEmpty((CharSequence)realdestinationCc)) {
            String[] destinationsCc = realdestinationCc.split(" ");
            InternetAddress[] addressCc = new InternetAddress[destinationsCc.length];
            for (int i2 = 0; i2 < destinationsCc.length; ++i2) {
                addressCc[i2] = new InternetAddress(destinationsCc[i2]);
            }
            msg.setRecipients(Message.RecipientType.CC, (Address[])addressCc);
        }
        if (!Utils.isEmpty((CharSequence)(realdestinationBCc = destinationBCc))) {
            String[] destinationsBCc = realdestinationBCc.split(" ");
            InternetAddress[] addressBCc = new InternetAddress[destinationsBCc.length];
            for (int i3 = 0; i3 < destinationsBCc.length; ++i3) {
                addressBCc[i3] = new InternetAddress(destinationsBCc[i3]);
            }
            msg.setRecipients(Message.RecipientType.BCC, (Address[])addressBCc);
        }
        if (mailsubject != null) {
            msg.setSubject(mailsubject);
        }
        msg.setSentDate(new Date());
        StringBuilder messageText = new StringBuilder();
        if (comment != null) {
            messageText.append(comment).append(Const.CR).append(Const.CR);
        }
        if (((MailMeta)this.meta).isIncludeDate()) {
            messageText.append(BaseMessages.getString(PKG, (String)"Mail.Log.Comment.MsgDate", (String[])new String[0]) + ": ").append(XmlHandler.date2string((Date)new Date())).append(Const.CR).append(Const.CR);
        }
        if (!(((MailMeta)this.meta).isOnlySendComment() || Utils.isEmpty((CharSequence)contactPerson) && Utils.isEmpty((CharSequence)contactPhone))) {
            messageText.append(BaseMessages.getString(PKG, (String)"Mail.Log.Comment.ContactInfo", (String[])new String[0]) + " :").append(Const.CR);
            messageText.append("---------------------").append(Const.CR);
            messageText.append(BaseMessages.getString(PKG, (String)"Mail.Log.Comment.PersonToContact", (String[])new String[0]) + " : ").append(contactPerson).append(Const.CR);
            messageText.append(BaseMessages.getString(PKG, (String)"Mail.Log.Comment.Tel", (String[])new String[0]) + "  : ").append(contactPhone).append(Const.CR);
            messageText.append(Const.CR);
        }
        ((MailData)this.data).parts = new MimeMultipart();
        MimeBodyPart part1 = new MimeBodyPart();
        if (((MailMeta)this.meta).isUseHTML()) {
            if (!Utils.isEmpty((CharSequence)((MailMeta)this.meta).getEncoding())) {
                part1.setContent((Object)messageText.toString(), "text/html; charset=" + ((MailMeta)this.meta).getEncoding());
            } else {
                part1.setContent((Object)messageText.toString(), "text/html; charset=ISO-8859-1");
            }
        } else {
            part1.setText(messageText.toString());
        }
        ((MailData)this.data).parts.addBodyPart((BodyPart)part1);
        if (((MailMeta)this.meta).isAttachContentFromField()) {
            this.addAttachedContent(((MailData)this.data).previousRowMeta.getString(r, ((MailData)this.data).indexOfAttachedFilename), ((MailData)this.data).previousRowMeta.getString(r, ((MailData)this.data).indexOfAttachedContent));
        } else if (((MailMeta)this.meta).isFilenameDynamic()) {
            this.setAttachedFilesList(r, this.getLogChannel());
        } else {
            this.setAttachedFilesList(null, this.getLogChannel());
        }
        this.addImagePart();
        if (((MailData)this.data).nrEmbeddedImages > 0 && ((MailData)this.data).nrattachedFiles == 0) {
            ((MailData)this.data).parts.setSubType("related");
        }
        msg.setContent((Multipart)((MailData)this.data).parts);
        try (Transport transport = null;){
            if (this.connection != null) {
                transport = this.connection.getTransport();
            } else {
                transport = session.getTransport(protocol);
                if (((MailMeta)this.meta).isUsingAuthentication()) {
                    if (port != -1) {
                        transport.connect(Const.NVL((String)server, (String)""), port, Const.NVL((String)authenticationUser, (String)""), Const.NVL((String)authenticationPassword, (String)""));
                    } else {
                        transport.connect(Const.NVL((String)server, (String)""), Const.NVL((String)authenticationUser, (String)""), Const.NVL((String)authenticationPassword, (String)""));
                    }
                } else {
                    transport.connect();
                }
            }
            transport.sendMessage((Message)msg, msg.getAllRecipients());
        }
        ByteArrayOutputStream emlMsg = new ByteArrayOutputStream();
        msg.writeTo((OutputStream)emlMsg);
        emlMsg.close();
        return emlMsg.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setAttachedFilesList(Object[] r, ILogChannel log) throws Exception {
        String realSourceFileFoldername = null;
        String realSourceWildcard = null;
        FileObject sourcefile = null;
        FileObject file = null;
        ZipOutputStream zipOutputStream = null;
        File masterZipfile = null;
        if (((MailMeta)this.meta).isZipFilenameDynamic()) {
            ((MailData)this.data).ZipFilename = ((MailData)this.data).previousRowMeta.getString(r, ((MailData)this.data).indexOfDynamicZipFilename);
        }
        try {
            if (((MailMeta)this.meta).isFilenameDynamic()) {
                if (((MailData)this.data).indexOfSourceFilename > -1) {
                    realSourceFileFoldername = ((MailData)this.data).previousRowMeta.getString(r, ((MailData)this.data).indexOfSourceFilename);
                }
                if (((MailData)this.data).indexOfSourceWildcard > -1) {
                    realSourceWildcard = ((MailData)this.data).previousRowMeta.getString(r, ((MailData)this.data).indexOfSourceWildcard);
                }
            } else {
                realSourceFileFoldername = ((MailData)this.data).realSourceFileFoldername;
                realSourceWildcard = ((MailData)this.data).realSourceWildcard;
            }
            if (!Utils.isEmpty((CharSequence)realSourceFileFoldername)) {
                sourcefile = HopVfs.getFileObject((String)realSourceFileFoldername, (IVariables)this.variables);
                if (sourcefile.exists()) {
                    long fileSize = 0L;
                    FileObject[] list = null;
                    list = sourcefile.getType() == FileType.FILE ? new FileObject[]{sourcefile} : sourcefile.findFiles((FileSelector)new TextFileSelector(sourcefile.toString(), realSourceWildcard));
                    if (list.length > 0) {
                        int c;
                        BufferedInputStream inputStream;
                        ZipEntry zipEntry;
                        int i;
                        boolean zipFiles = ((MailMeta)this.meta).isZipFiles();
                        if (zipFiles && ((MailData)this.data).zipFileLimit == 0L) {
                            masterZipfile = new File(System.getProperty("java.io.tmpdir") + Const.FILE_SEPARATOR + ((MailData)this.data).ZipFilename);
                            zipOutputStream = new ZipOutputStream(new FileOutputStream(masterZipfile));
                        }
                        for (i = 0; i < list.length; ++i) {
                            file = HopVfs.getFileObject((String)HopVfs.getFilename((FileObject)list[i]), (IVariables)this.variables);
                            if (zipFiles) {
                                if (((MailData)this.data).zipFileLimit == 0L) {
                                    zipEntry = new ZipEntry(file.getName().getBaseName());
                                    zipOutputStream.putNextEntry(zipEntry);
                                    inputStream = new BufferedInputStream(file.getContent().getInputStream());
                                    while ((c = inputStream.read()) >= 0) {
                                        zipOutputStream.write(c);
                                    }
                                    inputStream.close();
                                    zipOutputStream.closeEntry();
                                    continue;
                                }
                                fileSize += file.getContent().getSize();
                                continue;
                            }
                            this.addAttachedFilePart(file);
                        }
                        if (zipFiles) {
                            if (this.isDebug()) {
                                this.logDebug(BaseMessages.getString(PKG, (String)"Mail.Log.FileSize", (String[])new String[]{"" + fileSize}));
                            }
                            if (this.isDebug()) {
                                this.logDebug(BaseMessages.getString(PKG, (String)"Mail.Log.LimitSize", (String[])new String[]{"" + ((MailData)this.data).zipFileLimit}));
                            }
                            if (((MailData)this.data).zipFileLimit > 0L && fileSize > ((MailData)this.data).zipFileLimit) {
                                masterZipfile = new File(System.getProperty("java.io.tmpdir") + Const.FILE_SEPARATOR + ((MailData)this.data).ZipFilename);
                                zipOutputStream = new ZipOutputStream(new FileOutputStream(masterZipfile));
                                for (i = 0; i < list.length; ++i) {
                                    file = HopVfs.getFileObject((String)HopVfs.getFilename((FileObject)list[i]), (IVariables)this.variables);
                                    zipEntry = new ZipEntry(file.getName().getBaseName());
                                    zipOutputStream.putNextEntry(zipEntry);
                                    inputStream = new BufferedInputStream(file.getContent().getInputStream());
                                    while ((c = inputStream.read()) >= 0) {
                                        zipOutputStream.write(c);
                                    }
                                    inputStream.close();
                                    zipOutputStream.closeEntry();
                                }
                            }
                            if (((MailData)this.data).zipFileLimit > 0L && fileSize > ((MailData)this.data).zipFileLimit || ((MailData)this.data).zipFileLimit == 0L) {
                                file = HopVfs.getFileObject((String)masterZipfile.getAbsolutePath(), (IVariables)this.variables);
                                this.addAttachedFilePart(file);
                            }
                        }
                    }
                } else {
                    this.logError(BaseMessages.getString(PKG, (String)"Mail.Error.SourceFileFolderNotExists", (String[])new String[]{realSourceFileFoldername}));
                }
            }
        }
        catch (Exception e) {
            this.logError(e.getMessage());
        }
        finally {
            if (sourcefile != null) {
                try {
                    sourcefile.close();
                }
                catch (Exception e) {}
            }
            if (file != null) {
                try {
                    file.close();
                }
                catch (Exception e) {}
            }
            if (zipOutputStream != null) {
                try {
                    zipOutputStream.finish();
                    zipOutputStream.close();
                }
                catch (IOException e) {
                    this.logError("Unable to close attachement zip file archive : " + e.toString());
                }
            }
        }
    }

    private void addAttachedFilePart(FileObject file) throws Exception {
        MimeBodyPart files = new MimeBodyPart();
        URLDataSource fds = new URLDataSource(file.getURL());
        files.setDataHandler(new DataHandler((DataSource)fds));
        files.setFileName(file.getName().getBaseName());
        files.addHeader("Content-Transfer-Encoding", "base64");
        ((MailData)this.data).parts.addBodyPart((BodyPart)files);
        if (this.isDetailed()) {
            this.logDetailed(BaseMessages.getString(PKG, (String)"Mail.Log.AttachedFile", (String[])new String[]{fds.getName()}));
        }
    }

    private void addAttachedContent(String filename, String fileContent) throws Exception {
        MimeBodyPart mbp = new MimeBodyPart();
        mbp.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource(fileContent.getBytes(), "application/x-any")));
        mbp.setFileName(filename);
        ((MailData)this.data).parts.addBodyPart((BodyPart)mbp);
    }

    private void addImagePart() throws Exception {
        ((MailData)this.data).nrEmbeddedImages = 0;
        if (!Utils.isEmpty(((MailData)this.data).embeddedMimePart)) {
            for (MimeBodyPart part : ((MailData)this.data).embeddedMimePart) {
                ((MailData)this.data).parts.addBodyPart((BodyPart)part);
                ++((MailData)this.data).nrEmbeddedImages;
            }
        }
    }

    private boolean getFileWildcard(String selectedfile, String wildcard) {
        Pattern pattern = null;
        boolean getIt = true;
        if (!Utils.isEmpty((CharSequence)wildcard) && (pattern = Pattern.compile(wildcard)) != null) {
            Matcher matcher = pattern.matcher(selectedfile);
            getIt = matcher.matches();
        }
        return getIt;
    }

    public boolean init() {
        return super.init();
    }

    public void dispose() {
        if (((MailData)this.data).embeddedMimePart != null) {
            ((MailData)this.data).embeddedMimePart.clear();
        }
        ((MailData)this.data).parts = null;
        super.dispose();
    }

    private class TextFileSelector
    implements FileSelector {
        String fileWildcard = null;
        String sourceFolder = null;

        public TextFileSelector(String sourcefolderin, String filewildcard) {
            if (!Utils.isEmpty((CharSequence)sourcefolderin)) {
                this.sourceFolder = sourcefolderin;
            }
            if (!Utils.isEmpty((CharSequence)filewildcard)) {
                this.fileWildcard = filewildcard;
            }
        }

        public boolean includeFile(FileSelectInfo info) {
            boolean returncode = false;
            try {
                if (!info.getFile().toString().equals(this.sourceFolder)) {
                    String shortFilename = info.getFile().getName().getBaseName();
                    if ((info.getFile().getParent().equals(info.getBaseFolder()) || !info.getFile().getParent().equals(info.getBaseFolder()) && ((MailMeta)Mail.this.meta).isIncludeSubFolders()) && (info.getFile().getType() == FileType.FILE && this.fileWildcard == null || info.getFile().getType() == FileType.FILE && this.fileWildcard != null && Mail.this.getFileWildcard(shortFilename, this.fileWildcard))) {
                        returncode = true;
                    }
                }
            }
            catch (Exception e) {
                Mail.this.logError(BaseMessages.getString(PKG, (String)"Mail.Error.FindingFiles", (String[])new String[]{info.getFile().toString(), e.getMessage()}));
                returncode = false;
            }
            return returncode;
        }

        public boolean traverseDescendents(FileSelectInfo info) {
            return true;
        }
    }
}

