/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.mongodboutput;

import com.fasterxml.jackson.databind.JsonNode;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.MongoException;
import com.mongodb.util.JSON;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.mongo.MongoDbException;
import org.apache.hop.mongo.metadata.MongoDbConnection;
import org.apache.hop.mongo.wrapper.MongoClientWrapper;
import org.apache.hop.mongo.wrapper.collection.MongoCollectionWrapper;
import org.apache.hop.mongo.wrapper.cursor.MongoCursorWrapper;
import org.apache.hop.mongo.wrapper.field.MongoField;
import org.apache.hop.pipeline.transform.BaseTransformData;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transforms.mongodboutput.MongoDbOutputMeta;

public class MongoDbOutputData
extends BaseTransformData
implements ITransformData {
    private static final Class<?> PKG = MongoDbOutputMeta.class;
    public static final int MONGO_DEFAULT_PORT = 27017;
    public static final String LOCAL_DB = "local";
    public static final String REPL_SET_COLLECTION = "system.replset";
    public static final String REPL_SET_SETTINGS = "settings";
    public static final String REPL_SET_LAST_ERROR_MODES = "getLastErrorModes";
    public static final String CONST_MONGO_DB_OUTPUT_MESSAGES_ERROR_NO_FIELD_NAME_SPECIFIED_FOR_PATH = "MongoDbOutput.Messages.Error.NoFieldNameSpecifiedForPath";
    public static final String CONST_PUSH = "$push";
    public MongoDbConnection connection;
    protected IRowMeta outputRowMeta;
    protected MongoClientWrapper clientWrapper;
    protected MongoCollectionWrapper collection;
    protected List<MongoDbOutputMeta.MongoField> userFields;
    protected Map<String, List<MongoDbOutputMeta.MongoField>> setComplexArrays = new HashMap<String, List<MongoDbOutputMeta.MongoField>>();
    protected Map<String, List<MongoDbOutputMeta.MongoField>> pushComplexStructures = new HashMap<String, List<MongoDbOutputMeta.MongoField>>();
    protected Map<String, Object[]> primitiveLeafModifiers = new LinkedHashMap<String, Object[]>();
    protected boolean hasTopLevelJsonDocInsert = false;

    public static boolean scanForInsertTopLevelJSONDoc(List<MongoDbOutputMeta.MongoField> fieldDefs) throws HopException {
        int countNonMatchFields = 0;
        boolean hasTopLevelJSONDocInsert = false;
        for (MongoDbOutputMeta.MongoField f : fieldDefs) {
            if (f.inputJson && !f.updateMatchField && StringUtils.isEmpty((String)f.mongoDocPath) && !f.useIncomingFieldNameAsMongoFieldName) {
                hasTopLevelJSONDocInsert = true;
            }
            if (f.updateMatchField) continue;
            ++countNonMatchFields;
        }
        if (hasTopLevelJSONDocInsert && countNonMatchFields > 1) {
            throw new HopException("Path specifications contains a top-level document in JSON format to be inserted as is, but there are other insert paths defined. When a top-level JSON document is to be inserted it must be the only non-match field defined in the path specifications");
        }
        return hasTopLevelJSONDocInsert;
    }

    public void setMongoFields(List<MongoDbOutputMeta.MongoField> fields) {
        this.userFields = new ArrayList<MongoDbOutputMeta.MongoField>();
        for (MongoDbOutputMeta.MongoField f : fields) {
            this.userFields.add(f.copy());
        }
    }

    public List<MongoDbOutputMeta.MongoField> getMongoFields() {
        return this.userFields;
    }

    public void init(IVariables vars) throws HopException {
        if (this.userFields != null) {
            for (MongoDbOutputMeta.MongoField f : this.userFields) {
                f.init(vars);
            }
        }
    }

    public MongoClientWrapper getConnection() {
        return this.clientWrapper;
    }

    public void setConnection(MongoClientWrapper clientWrapper) {
        this.clientWrapper = clientWrapper;
    }

    public void createCollection(String db, String collectionName) throws Exception {
        if (this.clientWrapper == null) {
            throw new Exception(BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.Error.NoDatabaseSet", (String[])new String[0]));
        }
        this.clientWrapper.createCollection(db, collectionName);
    }

    public void setCollection(MongoCollectionWrapper col) {
        this.collection = col;
    }

    public MongoCollectionWrapper getCollection() {
        return this.collection;
    }

    public void setOutputRowMeta(IRowMeta outM) {
        this.outputRowMeta = outM;
    }

    public IRowMeta getOutputRowMeta() {
        return this.outputRowMeta;
    }

    public void applyIndexes(List<MongoDbOutputMeta.MongoIndex> indexes, ILogChannel log, boolean truncate) throws MongoException, MongoDbException {
        for (MongoDbOutputMeta.MongoIndex index : indexes) {
            String[] indexParts = index.pathToFields.split(",");
            BasicDBObject mongoIndex = new BasicDBObject();
            for (String indexKey : indexParts) {
                String name;
                String[] nameAndDirection = indexKey.split(":");
                int direction = 1;
                if (nameAndDirection.length == 2) {
                    direction = Integer.parseInt(nameAndDirection[1].trim());
                }
                if ((name = nameAndDirection[0]).contains("[")) {
                    name = name.substring(name.indexOf(91) + 1);
                }
                mongoIndex.put((Object)name, (Object)direction);
            }
            if (index.drop) {
                if (truncate) {
                    log.logBasic(BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.TruncateBeforeInsert", (Object[])new Object[]{index}));
                } else {
                    this.collection.dropIndex(mongoIndex);
                }
                log.logBasic(BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.DropIndex", (Object[])new Object[]{index}));
                continue;
            }
            BasicDBObject options = new BasicDBObject();
            options.put((Object)"background", (Object)true);
            options.put((Object)"unique", (Object)index.unique);
            options.put((Object)"sparse", (Object)index.sparse);
            this.collection.createIndex(mongoIndex, options);
            log.logBasic(BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.CreateIndex", (Object[])new Object[]{index}));
        }
    }

    protected DBObject getModifierUpdateObject(List<MongoDbOutputMeta.MongoField> fieldDefs, IRowMeta inputMeta, Object[] row, IVariables vars, MongoTopLevel topLevelStructure) throws HopException, MongoDbException {
        List<MongoDbOutputMeta.MongoField> fds;
        boolean haveUpdateFields = false;
        boolean hasNonNullUpdateValues = false;
        String mongoOperatorUpdateAllArray = "$[]";
        BasicDBObject updateObject = new BasicDBObject();
        this.setComplexArrays.clear();
        this.primitiveLeafModifiers.clear();
        this.pushComplexStructures.clear();
        boolean checkForMatch = false;
        for (MongoDbOutputMeta.MongoField field : fieldDefs) {
            if (field.updateMatchField || !field.modifierOperationApplyPolicy.equals("Insert") && !field.modifierOperationApplyPolicy.equals("Update")) continue;
            checkForMatch = true;
            break;
        }
        boolean isUpdate = false;
        if (checkForMatch) {
            DBObject query = MongoDbOutputData.getQueryObject(fieldDefs, inputMeta, row, vars, topLevelStructure);
            MongoCursorWrapper mongoCursorWrapper = this.getCollection().find(query).limit(1);
            if (mongoCursorWrapper.hasNext()) {
                isUpdate = true;
            }
        }
        for (MongoDbOutputMeta.MongoField mongoField : fieldDefs) {
            MongoDbOutputMeta.MongoField a;
            String arrayPath;
            boolean hasPath;
            Object path;
            String modifierUpdateOpp;
            if (mongoField.updateMatchField || StringUtils.isEmpty((String)(modifierUpdateOpp = mongoField.environUpdateModifierOperation)) || modifierUpdateOpp.equals("N/A") || checkForMatch && (isUpdate && mongoField.modifierOperationApplyPolicy.equals("Insert") || !isUpdate && mongoField.modifierOperationApplyPolicy.equals("Update"))) continue;
            haveUpdateFields = true;
            String incomingFieldName = mongoField.environUpdatedFieldName;
            int index = inputMeta.indexOfValue(incomingFieldName);
            IValueMeta vm = inputMeta.getValueMeta(index);
            if (vm.isNull(row[index]) && !mongoField.insertNull) continue;
            hasNonNullUpdateValues = true;
            Object object = path = mongoField.environUpdateMongoDocPath != null ? mongoField.environUpdateMongoDocPath : "";
            if (((String)path).endsWith("]") && modifierUpdateOpp.equals(CONST_PUSH) && !mongoField.useIncomingFieldNameAsMongoFieldName) {
                path = ((String)path).substring(0, ((String)path).indexOf(91));
            }
            boolean bl = hasPath = !StringUtils.isEmpty((String)path);
            path = (String)path + (String)(mongoField.useIncomingFieldNameAsMongoFieldName ? (hasPath ? "." + incomingFieldName : incomingFieldName) : "");
            if (modifierUpdateOpp.equals("$set") && ((String)path).contains("[") && !((String)path).contains(mongoOperatorUpdateAllArray)) {
                arrayPath = ((String)path).substring(0, ((String)path).indexOf(91));
                String arraySpec = ((String)path).substring(((String)path).indexOf(91));
                a = new MongoDbOutputMeta.MongoField();
                a.incomingFieldName = mongoField.incomingFieldName;
                a.environUpdatedFieldName = mongoField.environUpdatedFieldName;
                a.mongoDocPath = arraySpec;
                a.environUpdateMongoDocPath = arraySpec;
                a.useIncomingFieldNameAsMongoFieldName = false;
                a.inputJson = mongoField.inputJson;
                a.init(vars, false);
                List<MongoDbOutputMeta.MongoField> fds2 = this.setComplexArrays.get(arrayPath);
                if (fds2 == null) {
                    fds2 = new ArrayList<MongoDbOutputMeta.MongoField>();
                    this.setComplexArrays.put(arrayPath, fds2);
                }
                fds2.add(a);
                continue;
            }
            if (modifierUpdateOpp.equals(CONST_PUSH) && ((String)path).contains("[") && !((String)path).contains(mongoOperatorUpdateAllArray)) {
                arrayPath = ((String)path).substring(0, ((String)path).indexOf(91));
                String structureToPush = ((String)path).substring(((String)path).indexOf(93) + 1);
                if (structureToPush.charAt(0) == '.') {
                    structureToPush = structureToPush.substring(1);
                }
                a = new MongoDbOutputMeta.MongoField();
                a.incomingFieldName = mongoField.incomingFieldName;
                a.environUpdatedFieldName = mongoField.environUpdatedFieldName;
                a.mongoDocPath = structureToPush;
                a.environUpdateMongoDocPath = structureToPush;
                a.useIncomingFieldNameAsMongoFieldName = false;
                a.inputJson = mongoField.inputJson;
                a.init(vars, false);
                List<MongoDbOutputMeta.MongoField> fds2 = this.pushComplexStructures.get(arrayPath);
                if (fds2 == null) {
                    fds2 = new ArrayList<MongoDbOutputMeta.MongoField>();
                    this.pushComplexStructures.put(arrayPath, fds2);
                }
                fds2.add(a);
                continue;
            }
            Object[] params = new Object[]{modifierUpdateOpp, index, mongoField.inputJson, mongoField.insertNull};
            this.primitiveLeafModifiers.put((String)path, params);
        }
        for (String string : this.setComplexArrays.keySet()) {
            fds = this.setComplexArrays.get(string);
            DBObject valueToSet = MongoDbOutputData.hopRowToMongo(fds, inputMeta, row, MongoTopLevel.ARRAY, false);
            Object fieldsToUpdateWithValues = updateObject.get("$set") != null ? (DBObject)updateObject.get("$set") : new BasicDBObject();
            fieldsToUpdateWithValues.put(string, (Object)valueToSet);
            updateObject.put((Object)"$set", fieldsToUpdateWithValues);
        }
        for (String string : this.pushComplexStructures.keySet()) {
            fds = this.pushComplexStructures.get(string);
            MongoTopLevel topLevel = MongoTopLevel.RECORD;
            if (fds.get((int)0).mongoDocPath.charAt(0) == '[') {
                topLevel = MongoTopLevel.RECORD;
            }
            DBObject valueToSet = MongoDbOutputData.hopRowToMongo(fds, inputMeta, row, topLevel, false);
            Object fieldsToUpdateWithValues = null;
            fieldsToUpdateWithValues = updateObject.get(CONST_PUSH) != null ? (DBObject)updateObject.get(CONST_PUSH) : new BasicDBObject();
            fieldsToUpdateWithValues.put(string, (Object)valueToSet);
            updateObject.put((Object)CONST_PUSH, fieldsToUpdateWithValues);
        }
        for (Map.Entry entry : this.primitiveLeafModifiers.entrySet()) {
            String path = (String)entry.getKey();
            Object[] params = (Object[])entry.getValue();
            String modifierUpdateOpp = params[0].toString();
            int index = (Integer)params[1];
            boolean isJSON = (Boolean)params[2];
            boolean allowNull = (Boolean)params[3];
            IValueMeta vm = inputMeta.getValueMeta(index);
            Object fieldsToUpdateWithValues = null;
            fieldsToUpdateWithValues = updateObject.get(modifierUpdateOpp) != null ? (DBObject)updateObject.get(modifierUpdateOpp) : new BasicDBObject();
            MongoDbOutputData.setMongoValueFromHopValue((DBObject)fieldsToUpdateWithValues, path, vm, row[index], isJSON, allowNull);
            updateObject.put((Object)modifierUpdateOpp, fieldsToUpdateWithValues);
        }
        if (!haveUpdateFields) {
            throw new HopException(BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.Error.NoFieldsToUpdateSpecifiedForModifierOpp", (String[])new String[0]));
        }
        if (!hasNonNullUpdateValues) {
            return null;
        }
        return updateObject;
    }

    protected static DBObject getQueryObject(List<MongoDbOutputMeta.MongoField> fieldDefs, IRowMeta inputMeta, Object[] row, IVariables vars, MongoTopLevel topLevelStructure) throws HopException {
        BasicDBObject query = new BasicDBObject();
        boolean haveMatchFields = false;
        boolean hasNonNullMatchValues = false;
        for (MongoDbOutputMeta.MongoField field : fieldDefs) {
            boolean hasPath;
            if (!field.updateMatchField) continue;
            haveMatchFields = true;
            String incomingFieldName = field.environUpdatedFieldName;
            int index = inputMeta.indexOfValue(incomingFieldName);
            IValueMeta vm = inputMeta.getValueMeta(index);
            if (vm.isNull(row[index]) && !field.insertNull) continue;
            hasNonNullMatchValues = true;
            if (field.inputJson && StringUtils.isEmpty((String)field.mongoDocPath) && !field.useIncomingFieldNameAsMongoFieldName) {
                if (vm.isString()) {
                    String val = vm.getString(row[index]);
                    query = (BasicDBObject)JSON.parse((String)val);
                    break;
                }
                throw new HopException(BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.MatchFieldJSONButIncomingValueNotString", (String[])new String[0]));
            }
            Object path = field.environUpdateMongoDocPath != null ? field.environUpdateMongoDocPath : "";
            boolean bl = hasPath = !StringUtils.isEmpty((String)path);
            path = (String)path + (String)(field.useIncomingFieldNameAsMongoFieldName ? (hasPath ? "." + incomingFieldName : incomingFieldName) : "");
            if (((String)path).contains("[")) {
                path = ((String)path).replace("[", ".").replace("]", "");
            }
            MongoDbOutputData.setMongoValueFromHopValue((DBObject)query, path, vm, row[index], field.inputJson, field.insertNull);
        }
        if (!haveMatchFields) {
            throw new HopException(BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.Error.NoFieldsToUpdateSpecifiedForMatch", (String[])new String[0]));
        }
        if (!hasNonNullMatchValues) {
            return null;
        }
        return query;
    }

    protected static DBObject hopRowToMongo(List<MongoDbOutputMeta.MongoField> fieldDefs, IRowMeta inputMeta, Object[] row, MongoTopLevel topLevelStructure, boolean hasTopLevelJSONDocInsert) throws HopException {
        if (hasTopLevelJSONDocInsert) {
            for (MongoDbOutputMeta.MongoField f : fieldDefs) {
                if (!f.inputJson || !StringUtils.isEmpty((String)f.mongoDocPath) || f.useIncomingFieldNameAsMongoFieldName) continue;
                String incomingFieldName = f.environUpdatedFieldName;
                int index = inputMeta.indexOfValue(incomingFieldName);
                IValueMeta vm = inputMeta.getValueMeta(index);
                if (!vm.isNull(row[index])) {
                    String jsonDoc = vm.getString(row[index]);
                    return (DBObject)JSON.parse((String)jsonDoc);
                }
                return null;
            }
        }
        BasicDBObject root = null;
        if (topLevelStructure == MongoTopLevel.RECORD) {
            root = new BasicDBObject();
        } else if (topLevelStructure == MongoTopLevel.ARRAY) {
            root = new BasicDBList();
        }
        boolean haveNonNullFields = false;
        for (MongoDbOutputMeta.MongoField field : fieldDefs) {
            BasicDBObject current = root;
            field.reset();
            List<String> pathParts = field.tempPathList;
            String incomingFieldName = field.environUpdatedFieldName;
            int index = inputMeta.indexOfValue(incomingFieldName);
            IValueMeta vm = inputMeta.getValueMeta(index);
            Object lookup = MongoDbOutputData.getPathElementName(pathParts, (DBObject)current, field.useIncomingFieldNameAsMongoFieldName);
            do {
                if (lookup != null && lookup instanceof Integer) {
                    boolean res;
                    BasicDBList temp = (BasicDBList)current;
                    if (temp.get(lookup.toString()) == null) {
                        if (pathParts.isEmpty() && !field.useIncomingFieldNameAsMongoFieldName) {
                            res = MongoDbOutputData.setMongoValueFromHopValue((DBObject)temp, lookup, vm, row[index], field.inputJson, field.insertNull);
                            haveNonNullFields = haveNonNullFields || res;
                            continue;
                        }
                        BasicDBObject newRec = new BasicDBObject();
                        temp.put(lookup.toString(), (Object)newRec);
                        current = newRec;
                        if (!pathParts.isEmpty()) continue;
                        if (field.useIncomingFieldNameAsMongoFieldName) {
                            boolean res2 = MongoDbOutputData.setMongoValueFromHopValue((DBObject)current, incomingFieldName, vm, row[index], field.inputJson, field.insertNull);
                            haveNonNullFields = haveNonNullFields || res2;
                            continue;
                        }
                        throw new HopException(BaseMessages.getString(PKG, (String)CONST_MONGO_DB_OUTPUT_MESSAGES_ERROR_NO_FIELD_NAME_SPECIFIED_FOR_PATH, (String[])new String[0]));
                    }
                    current = (DBObject)temp.get(lookup.toString());
                    if (!Utils.isEmpty(pathParts) || !(current instanceof BasicDBObject)) continue;
                    if (field.useIncomingFieldNameAsMongoFieldName) {
                        res = MongoDbOutputData.setMongoValueFromHopValue((DBObject)current, incomingFieldName, vm, row[index], field.inputJson, field.insertNull);
                        haveNonNullFields = haveNonNullFields || res;
                        continue;
                    }
                    throw new HopException(BaseMessages.getString(PKG, (String)CONST_MONGO_DB_OUTPUT_MESSAGES_ERROR_NO_FIELD_NAME_SPECIFIED_FOR_PATH, (String[])new String[0]));
                }
                if (lookup == null && pathParts.isEmpty()) {
                    if (field.useIncomingFieldNameAsMongoFieldName) {
                        boolean res = MongoDbOutputData.setMongoValueFromHopValue((DBObject)current, incomingFieldName, vm, row[index], field.inputJson, field.insertNull);
                        haveNonNullFields = haveNonNullFields || res;
                        continue;
                    }
                    throw new HopException(BaseMessages.getString(PKG, (String)CONST_MONGO_DB_OUTPUT_MESSAGES_ERROR_NO_FIELD_NAME_SPECIFIED_FOR_PATH, (String[])new String[0]));
                }
                if (pathParts.isEmpty()) {
                    if (!field.useIncomingFieldNameAsMongoFieldName) {
                        boolean res = MongoDbOutputData.setMongoValueFromHopValue((DBObject)current, lookup.toString(), vm, row[index], field.inputJson, field.insertNull);
                        haveNonNullFields = haveNonNullFields || res;
                        continue;
                    }
                    current = (DBObject)current.get(lookup.toString());
                    boolean res = MongoDbOutputData.setMongoValueFromHopValue((DBObject)current, incomingFieldName, vm, row[index], field.inputJson, field.insertNull);
                    haveNonNullFields = haveNonNullFields || res;
                    continue;
                }
                current = (DBObject)current.get(lookup.toString());
            } while ((lookup = MongoDbOutputData.getPathElementName(pathParts, (DBObject)current, field.useIncomingFieldNameAsMongoFieldName)) != null);
        }
        if (!haveNonNullFields) {
            return null;
        }
        return root;
    }

    private static boolean setMongoValueFromHopValue(DBObject mongoObject, Object lookup, IValueMeta hopType, Object hopValue, boolean hopValueIsJSON, boolean allowNull) throws HopValueException {
        if (hopType.isNull(hopValue)) {
            if (allowNull) {
                mongoObject.put(lookup.toString(), null);
                return true;
            }
            return false;
        }
        switch (hopType.getType()) {
            case 2: {
                String val = hopType.getString(hopValue);
                if (hopValueIsJSON) {
                    Object mongoO = JSON.parse((String)val);
                    mongoObject.put(lookup.toString(), mongoO);
                } else {
                    mongoObject.put(lookup.toString(), (Object)val);
                }
                return true;
            }
            case 4: {
                Boolean val = hopType.getBoolean(hopValue);
                mongoObject.put(lookup.toString(), (Object)val);
                return true;
            }
            case 5: {
                Long val = hopType.getInteger(hopValue);
                mongoObject.put(lookup.toString(), (Object)val);
                return true;
            }
            case 3: {
                Date val = hopType.getDate(hopValue);
                mongoObject.put(lookup.toString(), (Object)val);
                return true;
            }
            case 1: {
                Double val = hopType.getNumber(hopValue);
                mongoObject.put(lookup.toString(), (Object)val);
                return true;
            }
            case 6: {
                String val = hopType.getString(hopValue);
                mongoObject.put(lookup.toString(), (Object)val);
                return true;
            }
            case 8: {
                byte[] val = hopType.getBinary(hopValue);
                mongoObject.put(lookup.toString(), (Object)val);
                return true;
            }
            case 11: {
                JsonNode node = hopType.getJson(hopValue);
                Object bson = MongoField.toBsonFromJsonNode(node);
                mongoObject.put(lookup.toString(), bson);
                return true;
            }
        }
        try {
            int uuidTypeId = ValueMetaFactory.getIdForValueMeta((String)"UUID");
            if (hopType.getType() == uuidTypeId) {
                UUID val = (UUID)hopType.convertData(hopType, hopValue);
                mongoObject.put(lookup.toString(), (Object)val);
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (hopType.isSerializableType()) {
            throw new HopValueException(BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.Error.CantStoreHopSerializableVals", (String[])new String[0]));
        }
        return false;
    }

    private static Object getPathElementName(List<String> pathParts, DBObject current, boolean incomingAsFieldName) throws HopException {
        if (Utils.isEmpty(pathParts)) {
            return null;
        }
        String part = pathParts.get(0);
        if (part.startsWith("[")) {
            String index = part.substring(1, part.indexOf(93)).trim();
            if (!(part = part.substring(part.indexOf(93) + 1).trim()).isEmpty()) {
                pathParts.set(0, part);
                if (current.get(index) == null) {
                    BasicDBList newArr = new BasicDBList();
                    current.put(index, (Object)newArr);
                }
            } else {
                pathParts.remove(0);
            }
            return Integer.valueOf(index);
        }
        if (part.endsWith("]")) {
            String fieldName = part.substring(0, part.indexOf(91));
            Object mongoField = current.get(fieldName);
            if (mongoField == null) {
                BasicDBList newField = new BasicDBList();
                current.put(fieldName, (Object)newField);
            } else if (!(mongoField instanceof BasicDBList)) {
                throw new HopException(BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.Error.FieldExistsButIsntAnArray", (String[])new String[]{part}));
            }
            part = part.substring(part.indexOf(91));
            pathParts.set(0, part);
            return fieldName;
        }
        Object mongoField = current.get(part);
        if (mongoField == null) {
            if (incomingAsFieldName || pathParts.size() > 1) {
                BasicDBObject newField = new BasicDBObject();
                current.put(part, (Object)newField);
            }
        } else if (!(mongoField instanceof BasicDBObject) && pathParts.size() > 1) {
            throw new HopException(BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.Error.FieldExistsButIsntARecord", (String[])new String[]{part}));
        }
        pathParts.remove(0);
        return part;
    }

    protected static MongoTopLevel checkTopLevelConsistency(List<MongoDbOutputMeta.MongoField> fieldDefs, IVariables vars) throws HopException {
        if (Utils.isEmpty(fieldDefs)) {
            throw new HopException(BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.Error.NoMongoPathsDefined", (String[])new String[0]));
        }
        int numRecords = 0;
        int numArrays = 0;
        for (MongoDbOutputMeta.MongoField field : fieldDefs) {
            String mongoPath = vars.resolve(field.mongoDocPath);
            if (StringUtils.isEmpty((String)mongoPath)) {
                ++numRecords;
                continue;
            }
            if (mongoPath.startsWith("[")) {
                ++numArrays;
                continue;
            }
            ++numRecords;
        }
        if (numRecords < fieldDefs.size() && numArrays < fieldDefs.size()) {
            return MongoTopLevel.INCONSISTENT;
        }
        if (numRecords > 0) {
            return MongoTopLevel.RECORD;
        }
        return MongoTopLevel.ARRAY;
    }

    public static enum MongoTopLevel {
        RECORD,
        ARRAY,
        INCONSISTENT;

    }
}

