/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.vfs.gs;

import com.google.api.gax.retrying.RetrySettings;
import com.google.auth.Credentials;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageOptions;
import java.util.Collection;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileSystem;
import org.apache.hop.vfs.gs.GoogleStorageFileObject;
import org.apache.hop.vfs.gs.GoogleStorageFileProvider;
import org.apache.hop.vfs.gs.GoogleStorageFileSystemConfigBuilder;
import org.apache.hop.vfs.gs.config.GoogleCloudConfig;
import org.apache.hop.vfs.gs.config.GoogleCloudConfigSingleton;
import org.threeten.bp.Duration;

public class GoogleStorageFileSystem
extends AbstractFileSystem {
    Storage storage = null;
    FileSystemOptions fileSystemOptions;

    protected GoogleStorageFileSystem(FileName rootName, FileObject parentLayer, FileSystemOptions fileSystemOptions) throws FileSystemException {
        super(rootName, parentLayer, fileSystemOptions);
        this.fileSystemOptions = fileSystemOptions;
    }

    protected FileObject createFile(AbstractFileName name) throws Exception {
        return new GoogleStorageFileObject(GoogleStorageFileSystemConfigBuilder.getInstance().getSchema(this.fileSystemOptions), name, this);
    }

    protected void addCapabilities(Collection<Capability> caps) {
        caps.addAll(GoogleStorageFileProvider.capabilities);
    }

    Storage setupStorage() {
        if (this.storage != null) {
            return this.storage;
        }
        GoogleCloudConfig config = GoogleCloudConfigSingleton.getConfig();
        RetrySettings retrySettings = StorageOptions.getDefaultRetrySettings().toBuilder().setMaxAttempts(Integer.parseInt(config.getMaxAttempts())).setInitialRetryDelay(Duration.ofSeconds((long)Integer.parseInt(config.getInitialRetryDelay()))).setRetryDelayMultiplier(Double.parseDouble(config.getRetryDelayMultiplier())).setMaxRetryDelay(Duration.ofSeconds((long)Integer.parseInt(config.getMaxRetryDelay()))).setTotalTimeout(Duration.ofMinutes((long)Integer.parseInt(config.getTotalTimeout()))).setInitialRpcTimeout(Duration.ofSeconds((long)Integer.parseInt(config.getInitialRpcTimeout()))).setRpcTimeoutMultiplier(Double.parseDouble(config.getRpcTimeoutMultiplier())).build();
        StorageOptions.Builder optionsBuilder = StorageOptions.newBuilder();
        optionsBuilder.setCredentials((Credentials)GoogleStorageFileSystemConfigBuilder.getInstance().getGoogleCredentials(this.fileSystemOptions));
        optionsBuilder.setRetrySettings(retrySettings);
        this.storage = (Storage)optionsBuilder.build().getService();
        return this.storage;
    }

    String getBucketName(FileName name) {
        String path = name.getPath();
        int idx = path.indexOf(47, 1);
        if (idx > -1) {
            return name.getPath().substring(1, idx);
        }
        return name.getPath().substring(1);
    }

    String getBucketPath(FileName name) {
        int idx = name.getPath().indexOf(47, 1);
        if (idx > -1) {
            return name.getPath().substring(idx + 1);
        }
        return "";
    }
}

