/*
 * Decompiled with CFR 0.152.
 */
package net.ucanaccess.converters;

import io.github.spannm.jackcess.DataType;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;

public final class TypesMap {
    private static final Map<String, String> ACCESS_TO_HSQL_TYPES_MAP = Arrays.stream(AccessType.values()).collect(Collectors.toMap(Enum::name, AccessType::getHsqlType, (o, n) -> o, LinkedHashMap::new));
    private static final Map<AccessType, DataType> ACCESS_TO_JACKCESS_TYPES_MAP = new EnumMap<AccessType, DataType>(AccessType.class);
    private static final Map<DataType, String> JACKCESS_TO_HSQLDB_TYPES_MAP = new EnumMap<DataType, String>(DataType.class);

    private TypesMap() {
    }

    public static Map<String, String> getAccess2HsqlTypesMap() {
        return Collections.unmodifiableMap(ACCESS_TO_HSQL_TYPES_MAP);
    }

    public static String map2hsqldb(DataType _type) {
        return JACKCESS_TO_HSQLDB_TYPES_MAP.getOrDefault(_type, _type.name());
    }

    public static DataType map2Jackcess(AccessType _type) {
        return ACCESS_TO_JACKCESS_TYPES_MAP.get((Object)_type);
    }

    static {
        ACCESS_TO_JACKCESS_TYPES_MAP.put(AccessType.AUTOINCREMENT, DataType.LONG);
        ACCESS_TO_JACKCESS_TYPES_MAP.put(AccessType.BYTE, DataType.BYTE);
        ACCESS_TO_JACKCESS_TYPES_MAP.put(AccessType.COUNTER, DataType.LONG);
        ACCESS_TO_JACKCESS_TYPES_MAP.put(AccessType.CURRENCY, DataType.MONEY);
        ACCESS_TO_JACKCESS_TYPES_MAP.put(AccessType.DATETIME, DataType.SHORT_DATE_TIME);
        ACCESS_TO_JACKCESS_TYPES_MAP.put(AccessType.DOUBLE, DataType.DOUBLE);
        ACCESS_TO_JACKCESS_TYPES_MAP.put(AccessType.GUID, DataType.GUID);
        ACCESS_TO_JACKCESS_TYPES_MAP.put(AccessType.HYPERLINK, DataType.MEMO);
        ACCESS_TO_JACKCESS_TYPES_MAP.put(AccessType.INTEGER, DataType.INT);
        ACCESS_TO_JACKCESS_TYPES_MAP.put(AccessType.LONG, DataType.LONG);
        ACCESS_TO_JACKCESS_TYPES_MAP.put(AccessType.MEMO, DataType.MEMO);
        ACCESS_TO_JACKCESS_TYPES_MAP.put(AccessType.NUMERIC, DataType.NUMERIC);
        ACCESS_TO_JACKCESS_TYPES_MAP.put(AccessType.OLE, DataType.OLE);
        ACCESS_TO_JACKCESS_TYPES_MAP.put(AccessType.SINGLE, DataType.FLOAT);
        ACCESS_TO_JACKCESS_TYPES_MAP.put(AccessType.TEXT, DataType.TEXT);
        ACCESS_TO_JACKCESS_TYPES_MAP.put(AccessType.YESNO, DataType.BOOLEAN);
        JACKCESS_TO_HSQLDB_TYPES_MAP.put(DataType.BIG_INT, "BIGINT");
        JACKCESS_TO_HSQLDB_TYPES_MAP.put(DataType.BINARY, "BLOB");
        JACKCESS_TO_HSQLDB_TYPES_MAP.put(DataType.BOOLEAN, "BOOLEAN");
        JACKCESS_TO_HSQLDB_TYPES_MAP.put(DataType.BYTE, "SMALLINT");
        JACKCESS_TO_HSQLDB_TYPES_MAP.put(DataType.COMPLEX_TYPE, "OBJECT");
        JACKCESS_TO_HSQLDB_TYPES_MAP.put(DataType.DOUBLE, "DOUBLE");
        JACKCESS_TO_HSQLDB_TYPES_MAP.put(DataType.FLOAT, "NUMERIC");
        JACKCESS_TO_HSQLDB_TYPES_MAP.put(DataType.GUID, "CHAR(38)");
        JACKCESS_TO_HSQLDB_TYPES_MAP.put(DataType.INT, "SMALLINT");
        JACKCESS_TO_HSQLDB_TYPES_MAP.put(DataType.LONG, "INTEGER");
        JACKCESS_TO_HSQLDB_TYPES_MAP.put(DataType.MEMO, "LONGVARCHAR");
        JACKCESS_TO_HSQLDB_TYPES_MAP.put(DataType.MONEY, "DECIMAL(100,4)");
        JACKCESS_TO_HSQLDB_TYPES_MAP.put(DataType.NUMERIC, "NUMERIC");
        JACKCESS_TO_HSQLDB_TYPES_MAP.put(DataType.OLE, "BLOB");
        JACKCESS_TO_HSQLDB_TYPES_MAP.put(DataType.SHORT_DATE_TIME, "TIMESTAMP");
        JACKCESS_TO_HSQLDB_TYPES_MAP.put(DataType.TEXT, "VARCHAR");
        JACKCESS_TO_HSQLDB_TYPES_MAP.put(DataType.UNKNOWN_0D, "BLOB");
        JACKCESS_TO_HSQLDB_TYPES_MAP.put(DataType.UNKNOWN_11, "BLOB");
        JACKCESS_TO_HSQLDB_TYPES_MAP.put(DataType.UNSUPPORTED_FIXEDLEN, "BLOB");
        JACKCESS_TO_HSQLDB_TYPES_MAP.put(DataType.UNSUPPORTED_VARLEN, "BLOB");
    }

    public static enum AccessType {
        BYTE("SMALLINT"),
        INTEGER("SMALLINT"),
        LONG("INTEGER"),
        TEXT("VARCHAR"),
        OLE("BLOB"),
        MEMO("LONGVARCHAR"),
        CURRENCY("DECIMAL(" + DataType.MONEY.getFixedSize() + ", 4)"),
        GUID("CHAR(38)"),
        COUNTER("INTEGER"),
        AUTOINCREMENT("INTEGER"),
        NUMERIC("DECIMAL"),
        YESNO("BOOLEAN"),
        DATETIME("TIMESTAMP"),
        SINGLE("FLOAT"),
        COMPLEX("OBJECT"),
        CHAR("VARCHAR"),
        HYPERLINK("LONGVARCHAR"),
        DOUBLE("DOUBLE");

        private final String hsqlType;

        private AccessType(String _hsqlType) {
            this.hsqlType = _hsqlType;
        }

        String getHsqlType() {
            return this.hsqlType;
        }
    }
}

