/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.kie.builder.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.drools.compiler.builder.InternalKnowledgeBuilder;
import org.drools.compiler.compiler.PackageRegistry;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.core.factmodel.ClassDefinition;
import org.drools.core.rule.JavaDialectRuntimeData;
import org.drools.core.rule.KieModuleMetaInfo;
import org.drools.core.rule.TypeDeclaration;
import org.drools.core.rule.TypeMetaInfo;
import org.drools.core.util.Drools;
import org.drools.core.util.IoUtils;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.definition.KiePackage;
import org.kie.api.definition.rule.Rule;
import org.kie.api.definition.type.FactType;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.memorycompiler.resources.ResourceStore;

public class KieMetaInfoBuilder {
    protected final InternalKieModule kModule;

    public KieMetaInfoBuilder(InternalKieModule kModule) {
        this.kModule = kModule;
    }

    public void writeKieModuleMetaInfo(ResourceStore trgMfs) {
        if (Drools.hasMvel()) {
            KieModuleMetaInfo info = this.generateKieModuleMetaInfo(trgMfs);
            trgMfs.write("META-INF/kmodule.info", info.marshallMetaInfos().getBytes(IoUtils.UTF8_CHARSET), true);
        }
    }

    public KieModuleMetaInfo getKieModuleMetaInfo() {
        return this.generateKieModuleMetaInfo(null);
    }

    public KieModuleMetaInfo generateKieModuleMetaInfo(ResourceStore trgMfs) {
        HashMap<String, TypeMetaInfo> typeInfos = new HashMap<String, TypeMetaInfo>();
        HashMap rulesPerPackage = new HashMap();
        KieModuleModel kieModuleModel = this.kModule.getKieModuleModel();
        for (String kieBaseName : kieModuleModel.getKieBaseModels().keySet()) {
            KnowledgeBuilder kBuilder = this.kModule.getKnowledgeBuilderForKieBase(kieBaseName);
            for (KiePackage kPkg : kBuilder.getKnowledgePackages()) {
                PackageRegistry pkgRegistry = ((InternalKnowledgeBuilder)kBuilder).getPackageRegistry(kPkg.getName());
                JavaDialectRuntimeData runtimeData = (JavaDialectRuntimeData)pkgRegistry.getDialectRuntimeRegistry().getDialectData("java");
                ArrayList<String> types = new ArrayList<String>();
                for (FactType factType : kPkg.getFactTypes()) {
                    byte[] bytes;
                    Class typeClass = ((ClassDefinition)factType).getDefinedClass();
                    TypeDeclaration typeDeclaration = pkgRegistry.getPackage().getTypeDeclaration(typeClass);
                    if (typeDeclaration != null) {
                        typeInfos.put(typeClass.getName(), new TypeMetaInfo(typeDeclaration));
                    }
                    String className = factType.getName();
                    String internalName = className.replace('.', '/') + ".class";
                    if (trgMfs != null && (bytes = runtimeData.getBytecode(internalName)) != null) {
                        trgMfs.write(internalName, bytes, true);
                    }
                    types.add(internalName);
                }
                HashSet<String> rules = (HashSet<String>)rulesPerPackage.get(kPkg.getName());
                if (rules == null) {
                    rules = new HashSet<String>();
                }
                for (Rule rule : kPkg.getRules()) {
                    rules.add(rule.getName());
                }
                if (rules.isEmpty()) continue;
                rulesPerPackage.put(kPkg.getName(), rules);
            }
        }
        return new KieModuleMetaInfo(typeInfos, rulesPerPackage);
    }
}

