/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigtable;

import com.google.bigtable.v2.Mutation;
import com.google.protobuf.ByteString;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.beam.sdk.io.gcp.bigtable.CellValueParser;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class BeamRowToBigtableMutation
extends PTransform<PCollection<Row>, PCollection<KV<ByteString, Iterable<Mutation>>>>
implements Serializable {
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> columnFamilyMapping;

    public BeamRowToBigtableMutation(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String>> familyColumnMapping) {
        this.columnFamilyMapping = familyColumnMapping.entrySet().stream().flatMap(kv -> ((Set)kv.getValue()).stream().map(column -> KV.of((Object)column, (Object)((String)kv.getKey())))).collect(Collectors.toMap(KV::getKey, KV::getValue));
    }

    public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized ByteString, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized Mutation>>> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> input) {
        return (PCollection)input.apply((PTransform)MapElements.via((SimpleFunction)new ToBigtableRowFn(this.columnFamilyMapping)));
    }

    public static class ToBigtableRowFn
    extends SimpleFunction<Row, KV<ByteString, Iterable<Mutation>>> {
        private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> columnFamilyMapping;
        private final @UnknownKeyFor @NonNull @Initialized CellValueParser cellValueParser = new CellValueParser();

        public ToBigtableRowFn(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> columnFamilyMapping) {
            this.columnFamilyMapping = columnFamilyMapping;
        }

        public @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized ByteString, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized Mutation>> apply(@UnknownKeyFor @NonNull @Initialized Row row) {
            List mutations = this.columnFamilyMapping.entrySet().stream().map(columnFamily -> this.mutation((String)columnFamily.getValue(), (String)columnFamily.getKey(), row)).collect(Collectors.toList());
            String key = row.getString("key");
            if (key != null) {
                return KV.of((Object)ByteString.copyFromUtf8((String)key), mutations);
            }
            throw new NullPointerException("Null key");
        }

        private @UnknownKeyFor @NonNull @Initialized Mutation mutation(@UnknownKeyFor @NonNull @Initialized String family, @UnknownKeyFor @NonNull @Initialized String column, @UnknownKeyFor @NonNull @Initialized Row row) {
            return Mutation.newBuilder().setSetCell(Mutation.SetCell.newBuilder().setValue(this.convertValueToByteString(row, column)).setColumnQualifier(ByteString.copyFromUtf8((String)column)).setFamilyName(family).build()).build();
        }

        private @UnknownKeyFor @NonNull @Initialized ByteString convertValueToByteString(@UnknownKeyFor @NonNull @Initialized Row row, @UnknownKeyFor @NonNull @Initialized String column) {
            Schema.Field field = row.getSchema().getField(column);
            Object value = row.getValue(column);
            if (value == null) {
                throw new NullPointerException("Null value at column " + column);
            }
            return this.cellValueParser.valueToByteString(value, field.getType());
        }
    }
}

