/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.message.AlterClientQuotasRequestData;
import org.apache.kafka.common.message.AlterClientQuotasResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.quota.ClientQuotaAlteration;
import org.apache.kafka.common.quota.ClientQuotaEntity;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AlterClientQuotasResponse;

public class AlterClientQuotasRequest
extends AbstractRequest {
    private final AlterClientQuotasRequestData data;

    public AlterClientQuotasRequest(AlterClientQuotasRequestData data, short version) {
        super(ApiKeys.ALTER_CLIENT_QUOTAS, version);
        this.data = data;
    }

    public List<ClientQuotaAlteration> entries() {
        ArrayList<ClientQuotaAlteration> entries = new ArrayList<ClientQuotaAlteration>(this.data.entries().size());
        for (AlterClientQuotasRequestData.EntryData entryData : this.data.entries()) {
            HashMap<String, String> entity = new HashMap<String, String>(entryData.entity().size());
            for (AlterClientQuotasRequestData.EntityData entityData : entryData.entity()) {
                entity.put(entityData.entityType(), entityData.entityName());
            }
            ArrayList<ClientQuotaAlteration.Op> ops = new ArrayList<ClientQuotaAlteration.Op>(entryData.ops().size());
            for (AlterClientQuotasRequestData.OpData opData : entryData.ops()) {
                Double value = opData.remove() ? null : Double.valueOf(opData.value());
                ops.add(new ClientQuotaAlteration.Op(opData.key(), value));
            }
            entries.add(new ClientQuotaAlteration(new ClientQuotaEntity(entity), ops));
        }
        return entries;
    }

    public boolean validateOnly() {
        return this.data.validateOnly();
    }

    @Override
    public AlterClientQuotasRequestData data() {
        return this.data;
    }

    @Override
    public AlterClientQuotasResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        Errors error = Errors.forException(e);
        ArrayList<AlterClientQuotasResponseData.EntryData> responseEntries = new ArrayList<AlterClientQuotasResponseData.EntryData>();
        for (AlterClientQuotasRequestData.EntryData entryData : this.data.entries()) {
            ArrayList<AlterClientQuotasResponseData.EntityData> responseEntities = new ArrayList<AlterClientQuotasResponseData.EntityData>();
            for (AlterClientQuotasRequestData.EntityData entityData : entryData.entity()) {
                responseEntities.add(new AlterClientQuotasResponseData.EntityData().setEntityType(entityData.entityType()).setEntityName(entityData.entityName()));
            }
            responseEntries.add(new AlterClientQuotasResponseData.EntryData().setEntity(responseEntities).setErrorCode(error.code()).setErrorMessage(error.message()));
        }
        AlterClientQuotasResponseData responseData = new AlterClientQuotasResponseData().setThrottleTimeMs(throttleTimeMs).setEntries(responseEntries);
        return new AlterClientQuotasResponse(responseData);
    }

    public static AlterClientQuotasRequest parse(ByteBuffer buffer, short version) {
        return new AlterClientQuotasRequest(new AlterClientQuotasRequestData(new ByteBufferAccessor(buffer), version), version);
    }

    public static class Builder
    extends AbstractRequest.Builder<AlterClientQuotasRequest> {
        private final AlterClientQuotasRequestData data;

        public Builder(Collection<ClientQuotaAlteration> entries, boolean validateOnly) {
            super(ApiKeys.ALTER_CLIENT_QUOTAS);
            ArrayList<AlterClientQuotasRequestData.EntryData> entryData = new ArrayList<AlterClientQuotasRequestData.EntryData>(entries.size());
            for (ClientQuotaAlteration entry : entries) {
                ArrayList<AlterClientQuotasRequestData.EntityData> entityData = new ArrayList<AlterClientQuotasRequestData.EntityData>(entry.entity().entries().size());
                for (Map.Entry<String, String> entityEntries : entry.entity().entries().entrySet()) {
                    entityData.add(new AlterClientQuotasRequestData.EntityData().setEntityType(entityEntries.getKey()).setEntityName(entityEntries.getValue()));
                }
                ArrayList<AlterClientQuotasRequestData.OpData> opData = new ArrayList<AlterClientQuotasRequestData.OpData>(entry.ops().size());
                for (ClientQuotaAlteration.Op op : entry.ops()) {
                    opData.add(new AlterClientQuotasRequestData.OpData().setKey(op.key()).setValue(op.value() == null ? 0.0 : op.value()).setRemove(op.value() == null));
                }
                entryData.add(new AlterClientQuotasRequestData.EntryData().setEntity(entityData).setOps(opData));
            }
            this.data = new AlterClientQuotasRequestData().setEntries(entryData).setValidateOnly(validateOnly);
        }

        @Override
        public AlterClientQuotasRequest build(short version) {
            return new AlterClientQuotasRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

