/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.kafka.common.Node;

public class TopicPartitionInfo {
    private final int partition;
    private final Node leader;
    private final List<Node> replicas;
    private final List<Node> isr;
    private final List<Node> elr;
    private final List<Node> lastKnownElr;

    public TopicPartitionInfo(int partition, Node leader, List<Node> replicas, List<Node> isr, List<Node> elr, List<Node> lastKnownElr) {
        this.partition = partition;
        this.leader = leader;
        this.replicas = Collections.unmodifiableList(replicas);
        this.isr = Collections.unmodifiableList(isr);
        this.elr = Collections.unmodifiableList(elr);
        this.lastKnownElr = Collections.unmodifiableList(lastKnownElr);
    }

    public TopicPartitionInfo(int partition, Node leader, List<Node> replicas, List<Node> isr) {
        this.partition = partition;
        this.leader = leader;
        this.replicas = Collections.unmodifiableList(replicas);
        this.isr = Collections.unmodifiableList(isr);
        this.elr = null;
        this.lastKnownElr = null;
    }

    public int partition() {
        return this.partition;
    }

    public Node leader() {
        return this.leader;
    }

    public List<Node> replicas() {
        return this.replicas;
    }

    public List<Node> isr() {
        return this.isr;
    }

    public List<Node> elr() {
        return this.elr;
    }

    public List<Node> lastKnownElr() {
        return this.lastKnownElr;
    }

    public String toString() {
        String elrString = this.elr != null ? this.elr.stream().map(Node::toString).collect(Collectors.joining(", ")) : "N/A";
        String lastKnownElrString = this.lastKnownElr != null ? this.lastKnownElr.stream().map(Node::toString).collect(Collectors.joining(", ")) : "N/A";
        return "(partition=" + this.partition + ", leader=" + this.leader + ", replicas=" + this.replicas.stream().map(Node::toString).collect(Collectors.joining(", ")) + ", isr=" + this.isr.stream().map(Node::toString).collect(Collectors.joining(", ")) + ", elr=" + elrString + ", lastKnownElr=" + lastKnownElrString + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TopicPartitionInfo that = (TopicPartitionInfo)o;
        return this.partition == that.partition && Objects.equals(this.leader, that.leader) && Objects.equals(this.replicas, that.replicas) && Objects.equals(this.isr, that.isr) && Objects.equals(this.elr, that.elr) && Objects.equals(this.lastKnownElr, that.lastKnownElr);
    }

    public int hashCode() {
        int result = this.partition;
        result = 31 * result + (this.leader != null ? this.leader.hashCode() : 0);
        result = 31 * result + (this.replicas != null ? this.replicas.hashCode() : 0);
        result = 31 * result + (this.isr != null ? this.isr.hashCode() : 0);
        result = 31 * result + (this.elr != null ? this.elr.hashCode() : 0);
        result = 31 * result + (this.lastKnownElr != null ? this.lastKnownElr.hashCode() : 0);
        return result;
    }
}

