/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow.util;

import com.google.api.client.util.Data;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.beam.runners.dataflow.util.CloudKnownType;
import org.apache.beam.runners.dataflow.util.CloudObject;
import org.apache.beam.sdk.util.StringUtils;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public final class Structs {
    private Structs() {
    }

    public static @UnknownKeyFor @NonNull @Initialized String getString(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> map, @UnknownKeyFor @NonNull @Initialized String name) {
        return Structs.getValue(map, name, String.class, "a string");
    }

    public static @UnknownKeyFor @NonNull @Initialized String getString(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> map, @UnknownKeyFor @NonNull @Initialized String name, @Nullable @UnknownKeyFor @Initialized String defaultValue) {
        return Structs.getValue(map, name, String.class, "a string", defaultValue);
    }

    public static @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] getBytes(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> map, @UnknownKeyFor @NonNull @Initialized String name) {
        byte @Nullable [] result = Structs.getBytes(map, name, null);
        if (result == null) {
            throw new ParameterNotFoundException(name, map);
        }
        return result;
    }

    public static @UnknownKeyFor @NonNull @Initialized byte @Nullable @UnknownKeyFor @Initialized [] getBytes(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> map, @UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized byte @Nullable @UnknownKeyFor @Initialized [] defaultValue) {
        @Nullable String jsonString = Structs.getString(map, name, null);
        if (jsonString == null) {
            return defaultValue;
        }
        return StringUtils.jsonStringToByteArray((String)jsonString);
    }

    public static @UnknownKeyFor @NonNull @Initialized Boolean getBoolean(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> map, @UnknownKeyFor @NonNull @Initialized String name) {
        return Structs.getValue(map, name, Boolean.class, "a boolean");
    }

    public static @Nullable @UnknownKeyFor @Initialized Boolean getBoolean(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> map, @UnknownKeyFor @NonNull @Initialized String name, @Nullable @UnknownKeyFor @Initialized Boolean defaultValue) {
        return Structs.getValue(map, name, Boolean.class, "a boolean", defaultValue);
    }

    public static @UnknownKeyFor @NonNull @Initialized Long getLong(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> map, @UnknownKeyFor @NonNull @Initialized String name) {
        return Structs.getValue(map, name, Long.class, "a long");
    }

    public static @Nullable @UnknownKeyFor @Initialized Long getLong(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> map, @UnknownKeyFor @NonNull @Initialized String name, @Nullable @UnknownKeyFor @Initialized Long defaultValue) {
        return Structs.getValue(map, name, Long.class, "a long", defaultValue);
    }

    public static @UnknownKeyFor @NonNull @Initialized Integer getInt(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> map, @UnknownKeyFor @NonNull @Initialized String name) {
        return Structs.getValue(map, name, Integer.class, "an int");
    }

    public static @Nullable @UnknownKeyFor @Initialized Integer getInt(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> map, @UnknownKeyFor @NonNull @Initialized String name, @Nullable @UnknownKeyFor @Initialized Integer defaultValue) {
        return Structs.getValue(map, name, Integer.class, "an int", defaultValue);
    }

    public static @Nullable @UnknownKeyFor @Initialized List<@UnknownKeyFor @NonNull @Initialized String> getStrings(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> map, @UnknownKeyFor @NonNull @Initialized String name, @Nullable @UnknownKeyFor @Initialized List<@UnknownKeyFor @NonNull @Initialized String> defaultValue) {
        @Nullable Object value = map.get(name);
        if (value == null) {
            if (map.containsKey(name)) {
                throw new IncorrectTypeException(name, map, "a string or a list");
            }
            return defaultValue;
        }
        if (Data.isNull((Object)value)) {
            return Collections.emptyList();
        }
        @Nullable String singletonString = Structs.decodeValue(value, String.class);
        if (singletonString != null) {
            return Collections.singletonList(singletonString);
        }
        if (!(value instanceof List)) {
            throw new IncorrectTypeException(name, map, "a string or a list");
        }
        List elements = (List)value;
        ArrayList<String> result = new ArrayList<String>(elements.size());
        for (Object o : elements) {
            @Nullable String s = Structs.decodeValue(o, String.class);
            if (s == null) {
                throw new IncorrectTypeException(name, map, "a list of strings");
            }
            result.add(s);
        }
        return result;
    }

    public static @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> getObject(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> map, @UnknownKeyFor @NonNull @Initialized String name) {
        @Nullable Map<String, Object> result = Structs.getObject(map, name, null);
        if (result == null) {
            throw new ParameterNotFoundException(name, map);
        }
        return result;
    }

    public static @Nullable @UnknownKeyFor @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> getObject(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> map, @UnknownKeyFor @NonNull @Initialized String name, @Nullable @UnknownKeyFor @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> defaultValue) {
        @Nullable Object value = map.get(name);
        if (value == null) {
            if (map.containsKey(name)) {
                throw new IncorrectTypeException(name, map, "an object");
            }
            return defaultValue;
        }
        return Structs.checkObject(value, map, name);
    }

    private static @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> checkObject(@UnknownKeyFor @NonNull @Initialized Object value, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> map, @UnknownKeyFor @NonNull @Initialized String name) {
        if (Data.isNull((Object)value)) {
            return Collections.emptyMap();
        }
        if (!(value instanceof Map)) {
            throw new IncorrectTypeException(name, map, "an object (not a map)");
        }
        Map mapValue = (Map)value;
        if (!mapValue.containsKey("@type")) {
            throw new IncorrectTypeException(name, map, "an object (no \"@type\" field)");
        }
        return mapValue;
    }

    public static @Nullable @UnknownKeyFor @Initialized List<@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object>> getListOfMaps(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> map, @UnknownKeyFor @NonNull @Initialized String name, @Nullable @UnknownKeyFor @Initialized List<@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object>> defaultValue) {
        @Nullable Object value = map.get(name);
        if (value == null) {
            if (map.containsKey(name)) {
                throw new IncorrectTypeException(name, map, "a list");
            }
            return defaultValue;
        }
        if (Data.isNull((Object)value)) {
            return Collections.emptyList();
        }
        if (!(value instanceof List)) {
            throw new IncorrectTypeException(name, map, "a list");
        }
        List elements = (List)value;
        for (Object elem : elements) {
            if (elem instanceof Map) continue;
            throw new IncorrectTypeException(name, map, "a list of Map objects");
        }
        List result = elements;
        return result;
    }

    public static @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> getDictionary(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> map, @UnknownKeyFor @NonNull @Initialized String name) {
        @Nullable Object value = map.get(name);
        if (value == null) {
            throw new ParameterNotFoundException(name, map);
        }
        if (Data.isNull((Object)value)) {
            return Collections.emptyMap();
        }
        if (!(value instanceof Map)) {
            throw new IncorrectTypeException(name, map, "a dictionary");
        }
        Map result = (Map)value;
        return result;
    }

    public static @Nullable @UnknownKeyFor @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> getDictionary(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> map, @UnknownKeyFor @NonNull @Initialized String name, @Nullable @UnknownKeyFor @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> defaultValue) {
        @Nullable Object value = map.get(name);
        if (value == null) {
            if (map.containsKey(name)) {
                throw new IncorrectTypeException(name, map, "a dictionary");
            }
            return defaultValue;
        }
        if (Data.isNull((Object)value)) {
            return Collections.emptyMap();
        }
        if (!(value instanceof Map)) {
            throw new IncorrectTypeException(name, map, "a dictionary");
        }
        Map result = (Map)value;
        return result;
    }

    public static void addString(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> map, @UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized String value) {
        Structs.addObject(map, name, (Map<String, Object>)((Object)CloudObject.forString(value)));
    }

    public static void addBoolean(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> map, @UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized boolean value) {
        Structs.addObject(map, name, (Map<String, Object>)((Object)CloudObject.forBoolean(value)));
    }

    public static void addLong(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> map, @UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized long value) {
        Structs.addObject(map, name, (Map<String, Object>)((Object)CloudObject.forInteger(value)));
    }

    public static void addObject(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> map, @UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> value) {
        map.put(name, value);
    }

    public static void addNull(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> map, @UnknownKeyFor @NonNull @Initialized String name) {
        map.put(name, Data.nullOf(Object.class));
    }

    public static void addLongs(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> map, @UnknownKeyFor @NonNull @Initialized String name, long ... longs) {
        ArrayList<CloudObject> elements = new ArrayList<CloudObject>(longs.length);
        long[] lArray = longs;
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            Long value = lArray[i];
            elements.add(CloudObject.forInteger(value));
        }
        map.put(name, elements);
    }

    public static void addList(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> map, @UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object>> elements) {
        map.put(name, elements);
    }

    public static void addStringList(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> map, @UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> elements) {
        ArrayList<CloudObject> objects = new ArrayList<CloudObject>(elements.size());
        for (String element : elements) {
            objects.add(CloudObject.forString(element));
        }
        Structs.addList(map, name, objects);
    }

    public static <T extends Map<String, Object>> void addList(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> map, @UnknownKeyFor @NonNull @Initialized String name, T @UnknownKeyFor @NonNull @Initialized [] elements) {
        map.put(name, Arrays.asList(elements));
    }

    public static void addDictionary(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> map, @UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> value) {
        map.put(name, value);
    }

    public static void addDouble(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> map, @UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized Double value) {
        Structs.addObject(map, name, (Map<String, Object>)((Object)CloudObject.forFloat(value)));
    }

    private static <T> T getValue(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> map, @UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized Class<T> clazz, @UnknownKeyFor @NonNull @Initialized String type) {
        @Nullable T result = Structs.getValue(map, name, clazz, type, null);
        if (result == null) {
            throw new ParameterNotFoundException(name, map);
        }
        return result;
    }

    private static <T> @Nullable T getValue(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> map, @UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized Class<T> clazz, @UnknownKeyFor @NonNull @Initialized String type, @Nullable T defaultValue) {
        @Nullable Object value = map.get(name);
        if (value == null) {
            if (map.containsKey(name)) {
                throw new IncorrectTypeException(name, map, type);
            }
            return defaultValue;
        }
        T result = Structs.decodeValue(value, clazz);
        if (result == null) {
            throw new IncorrectTypeException(name, map, type);
        }
        return result;
    }

    private static <T> @Nullable T decodeValue(@UnknownKeyFor @NonNull @Initialized Object value, @UnknownKeyFor @NonNull @Initialized Class<T> clazz) {
        try {
            if (value.getClass() == clazz) {
                return clazz.cast(value);
            }
            if (!(value instanceof Map)) {
                return null;
            }
            Map map = (Map)value;
            @Nullable String typeName = (String)map.get("@type");
            if (typeName == null) {
                return null;
            }
            @Nullable CloudKnownType knownType = CloudKnownType.forUri(typeName);
            if (knownType == null) {
                return null;
            }
            @Nullable V scalar = map.get("value");
            if (scalar == null) {
                return null;
            }
            return knownType.parse(scalar, clazz);
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    private static final class IncorrectTypeException
    extends RuntimeException {
        public IncorrectTypeException(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> map, @UnknownKeyFor @NonNull @Initialized String type) {
            super("required parameter " + name + " in " + map + " not " + type);
        }
    }

    private static final class ParameterNotFoundException
    extends RuntimeException {
        public ParameterNotFoundException(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> map) {
            super("didn't find required parameter " + name + " in " + map);
        }
    }
}

