/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.anon;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import org.apache.commons.io.input.ReaderInputStream;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.logging.LoggingObject;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.anon.AnonymousPipelineResults;
import org.apache.hop.pipeline.config.PipelineRunConfiguration;
import org.apache.hop.pipeline.engine.PipelineEngineFactory;
import org.apache.hop.pipeline.engines.local.LocalPipelineEngine;
import org.apache.hop.pipeline.engines.local.LocalPipelineRunConfiguration;
import org.apache.hop.pipeline.transform.ITransform;
import org.apache.hop.pipeline.transform.RowAdapter;

public class AnonymousPipelineRunner {
    /*
     * Enabled aggressive exception aggregation
     */
    public static AnonymousPipelineResults executePipeline(PipelineMeta pipelineMeta, IVariables variables, IHopMetadataProvider metadataProvider, String resultsTransformName) throws HopException {
        try {
            PipelineRunConfiguration runConfiguration = new PipelineRunConfiguration("anonymous", "Internal pipeline execution run configuration", null, List.of(), new LocalPipelineRunConfiguration(), null, false);
            runConfiguration.getEngineRunConfiguration().setEnginePluginId("Local");
            String xml = pipelineMeta.getXml(variables);
            try (StringReader stringReader = new StringReader(xml);){
                AnonymousPipelineResults anonymousPipelineResults;
                block14: {
                    ReaderInputStream inputStream = ((ReaderInputStream.Builder)((ReaderInputStream.Builder)ReaderInputStream.builder().setCharset("UTF-8")).setReader((Reader)stringReader)).get();
                    try {
                        PipelineMeta meta = new PipelineMeta((InputStream)inputStream, metadataProvider, variables);
                        meta.setMetadataProvider(metadataProvider);
                        LocalPipelineEngine pipeline = (LocalPipelineEngine)PipelineEngineFactory.createPipelineEngine(runConfiguration, meta);
                        pipeline.setParent((ILoggingObject)new LoggingObject((Object)"AnonymousPipelineRunner"));
                        pipeline.setMetadataProvider(metadataProvider);
                        final AnonymousPipelineResults results = new AnonymousPipelineResults();
                        pipeline.prepareExecution();
                        ITransform thread = pipeline.getRunThread(resultsTransformName, 0);
                        if (thread == null) {
                            throw new HopException("Unable to find transform '" + resultsTransformName + "' to get result rows from");
                        }
                        thread.addRowListener(new RowAdapter(){

                            @Override
                            public void rowWrittenEvent(IRowMeta rowMeta, Object[] row) {
                                results.setResultRowMeta(rowMeta);
                                results.getResultRows().add(row);
                            }
                        });
                        pipeline.startThreads();
                        pipeline.waitUntilFinished();
                        results.setPipeline(pipeline);
                        results.setResult(pipeline.getResult());
                        anonymousPipelineResults = results;
                        if (inputStream == null) break block14;
                    }
                    catch (Throwable throwable) {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    inputStream.close();
                }
                return anonymousPipelineResults;
            }
        }
        catch (Exception e) {
            throw new HopException("Error running anonymous local pipeline", (Throwable)e);
        }
    }
}

