/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.hop;

import java.util.List;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.HopEnvironment;
import org.apache.hop.core.HopVersionProvider;
import org.apache.hop.core.config.plugin.ConfigPluginType;
import org.apache.hop.core.config.plugin.IConfigOptions;
import org.apache.hop.core.exception.HopPluginException;
import org.apache.hop.core.logging.HopLogStore;
import org.apache.hop.core.plugins.IPlugin;
import org.apache.hop.core.plugins.JarCache;
import org.apache.hop.core.plugins.PluginRegistry;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.variables.Variables;
import org.apache.hop.hop.plugin.HopCommandPluginType;
import org.apache.hop.hop.plugin.IHopCommand;
import org.apache.hop.metadata.serializer.multi.MultiMetadataProvider;
import org.apache.hop.metadata.util.HopMetadataInstance;
import org.apache.hop.metadata.util.HopMetadataUtil;
import picocli.CommandLine;

@CommandLine.Command(name="hop", mixinStandardHelpOptions=true, versionProvider=HopVersionProvider.class, subcommands={CommandLine.HelpCommand.class})
public class Hop {
    @CommandLine.Option(names={"-s", "--system-properties"}, description={"A comma separated list of KEY=VALUE pairs"}, split=",")
    private String[] systemProperties = null;
    @CommandLine.Option(names={"--dev-debug"}, description={"Allow a Hop developer to debug remotely"})
    private boolean devDebug;
    @CommandLine.Option(names={"--dev-debug-wait"}, description={"Allow a Hop developer to debug remotely. The script will wait until a debugging session is set up."})
    private boolean devDebugWait;
    private CommandLine cmd;
    private IVariables variables;
    private MultiMetadataProvider metadataProvider;

    public static void main(String[] args) throws Exception {
        Hop hop = new Hop();
        hop.cmd = new CommandLine((Object)new Hop());
        hop.applySystemProperties();
        HopEnvironment.init();
        hop.variables = Variables.getADefaultVariableSpace();
        HopLogStore.init();
        JarCache.getInstance().clear();
        hop.metadataProvider = HopMetadataUtil.getStandardHopMetadataProvider((IVariables)hop.variables);
        HopMetadataInstance.setMetadataProvider((MultiMetadataProvider)hop.metadataProvider);
        PluginRegistry registry = PluginRegistry.getInstance();
        List plugins = registry.getPlugins(HopCommandPluginType.class);
        for (IPlugin plugin : plugins) {
            IHopCommand subCommand = (IHopCommand)registry.loadClass(plugin);
            CommandLine subCmd = new CommandLine((Object)subCommand);
            hop.cmd.addSubcommand(plugin.getIds()[0], (Object)subCmd);
            subCommand.initialize(subCmd, hop.variables, hop.metadataProvider);
        }
        CommandLine.ParseResult parseResult = hop.cmd.parseArgs(args);
        if (CommandLine.printHelpIfRequested((CommandLine.ParseResult)parseResult)) {
            System.exit(1);
        }
        int exitCode = hop.cmd.execute(args);
        System.exit(exitCode);
    }

    public void applySystemProperties() {
        if (this.systemProperties != null) {
            for (String parameter : this.systemProperties) {
                String value;
                String[] split = parameter.split("=", 2);
                String key = split.length > 0 ? split[0] : null;
                String string = value = split.length > 1 ? split[1] : null;
                if (!StringUtils.isNotEmpty((String)key) || !StringUtils.isNotEmpty((String)value)) continue;
                System.setProperty(key, value);
            }
        }
    }

    public static void addMixinPlugins(CommandLine cmd, String category) throws HopPluginException {
        List configPlugins = PluginRegistry.getInstance().getPlugins(ConfigPluginType.class);
        for (IPlugin configPlugin : configPlugins) {
            if (!category.equals(configPlugin.getCategory())) continue;
            IConfigOptions configOptions = (IConfigOptions)PluginRegistry.getInstance().loadClass(configPlugin, IConfigOptions.class);
            cmd.addMixin(configPlugin.getIds()[0], (Object)configOptions);
        }
    }

    @Generated
    public String[] getSystemProperties() {
        return this.systemProperties;
    }

    @Generated
    public boolean isDevDebug() {
        return this.devDebug;
    }

    @Generated
    public boolean isDevDebugWait() {
        return this.devDebugWait;
    }

    @Generated
    public CommandLine getCmd() {
        return this.cmd;
    }

    @Generated
    public IVariables getVariables() {
        return this.variables;
    }

    @Generated
    public MultiMetadataProvider getMetadataProvider() {
        return this.metadataProvider;
    }

    @Generated
    public void setSystemProperties(String[] systemProperties) {
        this.systemProperties = systemProperties;
    }

    @Generated
    public void setDevDebug(boolean devDebug) {
        this.devDebug = devDebug;
    }

    @Generated
    public void setDevDebugWait(boolean devDebugWait) {
        this.devDebugWait = devDebugWait;
    }

    @Generated
    public void setCmd(CommandLine cmd) {
        this.cmd = cmd;
    }

    @Generated
    public void setVariables(IVariables variables) {
        this.variables = variables;
    }

    @Generated
    public void setMetadataProvider(MultiMetadataProvider metadataProvider) {
        this.metadataProvider = metadataProvider;
    }
}

