/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity.implementation;

import com.azure.core.http.HttpPipeline;
import com.azure.identity.implementation.IdentityClient;
import com.azure.identity.implementation.IdentityClientOptions;
import com.azure.identity.implementation.IdentitySyncClient;
import java.time.Duration;
import java.util.function.Function;
import java.util.function.Supplier;

public final class IdentityClientBuilder {
    private IdentityClientOptions identityClientOptions = new IdentityClientOptions();
    private String tenantId;
    private String clientId;
    private String resourceId;
    private String clientSecret;
    private String clientAssertionPath;
    private String certificatePath;
    private byte[] certificate;
    private String certificatePassword;
    private boolean sharedTokenCacheCred;
    private Duration clientAssertionTimeout;
    private Supplier<String> clientAssertionSupplier;
    private Function<HttpPipeline, String> clientAssertionSupplierWithHttpPipeline;

    public IdentityClientBuilder tenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    public IdentityClientBuilder clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    public IdentityClientBuilder resourceId(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    public IdentityClientBuilder clientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    public IdentityClientBuilder certificatePath(String certificatePath) {
        this.certificatePath = certificatePath;
        return this;
    }

    public IdentityClientBuilder clientAssertionSupplier(Supplier<String> clientAssertionSupplier) {
        this.clientAssertionSupplier = clientAssertionSupplier;
        return this;
    }

    public IdentityClientBuilder clientAssertionSupplierWithHttpPipeline(Function<HttpPipeline, String> clientAssertionSupplier) {
        this.clientAssertionSupplierWithHttpPipeline = clientAssertionSupplier;
        return this;
    }

    public IdentityClientBuilder clientAssertionPath(String clientAssertionPath) {
        this.clientAssertionPath = clientAssertionPath;
        return this;
    }

    public IdentityClientBuilder certificate(byte[] certificate) {
        this.certificate = certificate;
        return this;
    }

    public IdentityClientBuilder certificatePassword(String certificatePassword) {
        this.certificatePassword = certificatePassword;
        return this;
    }

    public IdentityClientBuilder identityClientOptions(IdentityClientOptions identityClientOptions) {
        this.identityClientOptions = identityClientOptions;
        return this;
    }

    public IdentityClientBuilder sharedTokenCacheCredential(boolean isSharedTokenCacheCred) {
        this.sharedTokenCacheCred = isSharedTokenCacheCred;
        return this;
    }

    public IdentityClientBuilder clientAssertionTimeout(Duration clientAssertionTimeout) {
        this.clientAssertionTimeout = clientAssertionTimeout;
        return this;
    }

    public IdentityClient build() {
        return new IdentityClient(this.tenantId, this.clientId, this.clientSecret, this.certificatePath, this.clientAssertionPath, this.resourceId, this.clientAssertionSupplier, this.clientAssertionSupplierWithHttpPipeline, this.certificate, this.certificatePassword, this.sharedTokenCacheCred, this.clientAssertionTimeout, this.identityClientOptions);
    }

    public IdentitySyncClient buildSyncClient() {
        return new IdentitySyncClient(this.tenantId, this.clientId, this.clientSecret, this.certificatePath, this.clientAssertionPath, this.resourceId, this.clientAssertionSupplier, this.clientAssertionSupplierWithHttpPipeline, this.certificate, this.certificatePassword, this.sharedTokenCacheCred, this.clientAssertionTimeout, this.identityClientOptions);
    }
}

