/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.setvaluefield;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.setvaluefield.SetField;
import org.apache.hop.pipeline.transforms.setvaluefield.SetValueField;
import org.apache.hop.pipeline.transforms.setvaluefield.SetValueFieldData;

@Transform(id="SetValueField", image="setvaluefield.svg", name="i18n::SetValueField.Name", description="i18n::SetValueField.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Transform", keywords={"i18n::SetValueFieldMeta.keyword"}, documentationUrl="/pipeline/transforms/setvaluefield.html")
public class SetValueFieldMeta
extends BaseTransformMeta<SetValueField, SetValueFieldData> {
    private static final Class<?> PKG = SetValueFieldMeta.class;
    @HopMetadataProperty(key="field", groupKey="fields", injectionGroupDescription="SetValueField.Injection.SetFields")
    private List<SetField> fields = new ArrayList<SetField>();

    public SetValueFieldMeta() {
    }

    public SetValueFieldMeta(SetValueFieldMeta clone) {
        for (SetField field : clone.getFields()) {
            this.fields.add(new SetField(field));
        }
    }

    public List<SetField> getFields() {
        return this.fields;
    }

    public void setFields(List<SetField> fields) {
        this.fields = fields;
    }

    public Object clone() {
        return new SetValueFieldMeta(this);
    }

    public void setDefault() {
        this.fields = new ArrayList<SetField>();
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr = prev == null || prev.isEmpty() ? new CheckResult(3, BaseMessages.getString(PKG, (String)"SetValueFieldMeta.CheckResult.NoReceivingFieldsError", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"SetValueFieldMeta.CheckResult.TransformReceivingFieldsOK", (String[])new String[]{"" + prev.size()}), (ICheckResultSource)transformMeta);
        remarks.add((ICheckResult)cr);
        cr = input.length > 0 ? new CheckResult(1, BaseMessages.getString(PKG, (String)"SetValueFieldMeta.CheckResult.TransformRecevingInfoFromOtherTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(4, BaseMessages.getString(PKG, (String)"SetValueFieldMeta.CheckResult.NoInputReceivedError", (String[])new String[0]), (ICheckResultSource)transformMeta);
        remarks.add((ICheckResult)cr);
        if (Utils.isEmpty(this.fields)) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"SetValueFieldMeta.CheckResult.FieldsSelectionEmpty", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            int i = 1;
            for (SetField field : this.fields) {
                if (Utils.isEmpty((CharSequence)field.getReplaceByField())) {
                    cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"SetValueFieldMeta.CheckResult.ReplaceByValueMissing", (String[])new String[]{field.getFieldName(), "" + i}), (ICheckResultSource)transformMeta);
                    remarks.add((ICheckResult)cr);
                }
                ++i;
            }
        }
    }

    public boolean supportsErrorHandling() {
        return true;
    }
}

