/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.regexeval;

import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopPluginException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaBase;
import org.apache.hop.core.row.value.ValueMetaBoolean;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.regexeval.RegexEval;
import org.apache.hop.pipeline.transforms.regexeval.RegexEvalData;
import org.w3c.dom.Node;

@Transform(id="RegexEval", image="regexeval.svg", name="i18n::RegexEval.Name", description="i18n::RegexEval.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Scripting", keywords={"i18n::RegexEvalMeta.keyword"}, documentationUrl="/pipeline/transforms/regexeval.html")
public class RegexEvalMeta
extends BaseTransformMeta<RegexEval, RegexEvalData> {
    private static final Class<?> PKG = RegexEvalMeta.class;
    public static final String CONST_SPACES = "        ";
    private String script;
    private String matcher;
    private String resultfieldname;
    private boolean usevar;
    private boolean allowcapturegroups;
    private boolean replacefields;
    private boolean canoneq;
    private boolean caseinsensitive;
    private boolean comment;
    private boolean dotall;
    private boolean multiline;
    private boolean unicode;
    private boolean unix;
    private String[] fieldName;
    private int[] fieldType;
    private String[] fieldFormat;
    private String[] fieldGroup;
    private String[] fieldDecimal;
    private String[] fieldCurrency;
    private int[] fieldLength;
    private int[] fieldPrecision;
    private String[] fieldNullIf;
    private String[] fieldIfNull;
    private int[] fieldTrimType;

    public Object clone() {
        RegexEvalMeta retval = (RegexEvalMeta)((Object)super.clone());
        int nrFields = this.fieldName.length;
        retval.allocate(nrFields);
        System.arraycopy(this.fieldName, 0, retval.fieldName, 0, nrFields);
        System.arraycopy(this.fieldType, 0, retval.fieldType, 0, nrFields);
        System.arraycopy(this.fieldLength, 0, retval.fieldLength, 0, nrFields);
        System.arraycopy(this.fieldPrecision, 0, retval.fieldPrecision, 0, nrFields);
        System.arraycopy(this.fieldFormat, 0, retval.fieldFormat, 0, nrFields);
        System.arraycopy(this.fieldGroup, 0, retval.fieldGroup, 0, nrFields);
        System.arraycopy(this.fieldDecimal, 0, retval.fieldDecimal, 0, nrFields);
        System.arraycopy(this.fieldCurrency, 0, retval.fieldCurrency, 0, nrFields);
        System.arraycopy(this.fieldNullIf, 0, retval.fieldNullIf, 0, nrFields);
        System.arraycopy(this.fieldIfNull, 0, retval.fieldIfNull, 0, nrFields);
        System.arraycopy(this.fieldTrimType, 0, retval.fieldTrimType, 0, nrFields);
        return retval;
    }

    public void allocate(int nrFields) {
        this.fieldName = new String[nrFields];
        this.fieldType = new int[nrFields];
        this.fieldFormat = new String[nrFields];
        this.fieldGroup = new String[nrFields];
        this.fieldDecimal = new String[nrFields];
        this.fieldCurrency = new String[nrFields];
        this.fieldLength = new int[nrFields];
        this.fieldPrecision = new int[nrFields];
        this.fieldNullIf = new String[nrFields];
        this.fieldIfNull = new String[nrFields];
        this.fieldTrimType = new int[nrFields];
    }

    public String getScript() {
        return this.script;
    }

    public String getRegexOptions() {
        StringBuilder options = new StringBuilder();
        if (this.isCaseInsensitiveFlagSet()) {
            options.append("(?i)");
        }
        if (this.isCommentFlagSet()) {
            options.append("(?x)");
        }
        if (this.isDotAllFlagSet()) {
            options.append("(?s)");
        }
        if (this.isMultilineFlagSet()) {
            options.append("(?m)");
        }
        if (this.isUnicodeFlagSet()) {
            options.append("(?u)");
        }
        if (this.isUnixLineEndingsFlagSet()) {
            options.append("(?d)");
        }
        return options.toString();
    }

    public void setScript(String script) {
        this.script = script;
    }

    public String getMatcher() {
        return this.matcher;
    }

    public void setMatcher(String matcher) {
        this.matcher = matcher;
    }

    public String getResultFieldName() {
        return this.resultfieldname;
    }

    public void setResultFieldName(String resultfieldname) {
        this.resultfieldname = resultfieldname;
    }

    public boolean isUseVariableInterpolationFlagSet() {
        return this.usevar;
    }

    public void setUseVariableInterpolationFlag(boolean usevar) {
        this.usevar = usevar;
    }

    public boolean isAllowCaptureGroupsFlagSet() {
        return this.allowcapturegroups;
    }

    public void setAllowCaptureGroupsFlag(boolean allowcapturegroups) {
        this.allowcapturegroups = allowcapturegroups;
    }

    public boolean isReplacefields() {
        return this.replacefields;
    }

    public void setReplacefields(boolean replacefields) {
        this.replacefields = replacefields;
    }

    public boolean isCanonicalEqualityFlagSet() {
        return this.canoneq;
    }

    public void setCanonicalEqualityFlag(boolean canoneq) {
        this.canoneq = canoneq;
    }

    public boolean isCaseInsensitiveFlagSet() {
        return this.caseinsensitive;
    }

    public void setCaseInsensitiveFlag(boolean caseinsensitive) {
        this.caseinsensitive = caseinsensitive;
    }

    public boolean isCommentFlagSet() {
        return this.comment;
    }

    public void setCommentFlag(boolean comment) {
        this.comment = comment;
    }

    public boolean isDotAllFlagSet() {
        return this.dotall;
    }

    public void setDotAllFlag(boolean dotall) {
        this.dotall = dotall;
    }

    public boolean isMultilineFlagSet() {
        return this.multiline;
    }

    public void setMultilineFlag(boolean multiline) {
        this.multiline = multiline;
    }

    public boolean isUnicodeFlagSet() {
        return this.unicode;
    }

    public void setUnicodeFlag(boolean unicode) {
        this.unicode = unicode;
    }

    public boolean isUnixLineEndingsFlagSet() {
        return this.unix;
    }

    public void setUnixLineEndingsFlag(boolean unix) {
        this.unix = unix;
    }

    public String[] getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String[] value) {
        this.fieldName = value;
    }

    public int[] getFieldType() {
        return this.fieldType;
    }

    public void setFieldType(int[] fieldType) {
        this.fieldType = fieldType;
    }

    public String[] getFieldFormat() {
        return this.fieldFormat;
    }

    public void setFieldFormat(String[] fieldFormat) {
        this.fieldFormat = fieldFormat;
    }

    public String[] getFieldGroup() {
        return this.fieldGroup;
    }

    public void setFieldGroup(String[] fieldGroup) {
        this.fieldGroup = fieldGroup;
    }

    public String[] getFieldDecimal() {
        return this.fieldDecimal;
    }

    public void setFieldDecimal(String[] fieldDecimal) {
        this.fieldDecimal = fieldDecimal;
    }

    public String[] getFieldCurrency() {
        return this.fieldCurrency;
    }

    public void setFieldCurrency(String[] fieldCurrency) {
        this.fieldCurrency = fieldCurrency;
    }

    public int[] getFieldLength() {
        return this.fieldLength;
    }

    public void setFieldLength(int[] fieldLength) {
        this.fieldLength = fieldLength;
    }

    public int[] getFieldPrecision() {
        return this.fieldPrecision;
    }

    public void setFieldPrecision(int[] fieldPrecision) {
        this.fieldPrecision = fieldPrecision;
    }

    public String[] getFieldNullIf() {
        return this.fieldNullIf;
    }

    public void setFieldNullIf(String[] fieldNullIf) {
        this.fieldNullIf = fieldNullIf;
    }

    public String[] getFieldIfNull() {
        return this.fieldIfNull;
    }

    public void setFieldIfNull(String[] fieldIfNull) {
        this.fieldIfNull = fieldIfNull;
    }

    public int[] getFieldTrimType() {
        return this.fieldTrimType;
    }

    public void setFieldTrimType(int[] fieldTrimType) {
        this.fieldTrimType = fieldTrimType;
    }

    private void readData(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        try {
            this.script = XmlHandler.getTagValue((Node)transformNode, (String)"script");
            this.matcher = XmlHandler.getTagValue((Node)transformNode, (String)"matcher");
            this.resultfieldname = XmlHandler.getTagValue((Node)transformNode, (String)"resultfieldname");
            this.usevar = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"usevar"));
            this.allowcapturegroups = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"allowcapturegroups"));
            this.replacefields = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"replacefields"));
            this.canoneq = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"canoneq"));
            this.caseinsensitive = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"caseinsensitive"));
            this.comment = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"comment"));
            this.dotall = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"dotall"));
            this.multiline = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"multiline"));
            this.unicode = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"unicode"));
            this.unix = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"unix"));
            Node fields = XmlHandler.getSubNode((Node)transformNode, (String)"fields");
            int nrFields = XmlHandler.countNodes((Node)fields, (String)"field");
            this.allocate(nrFields);
            for (int i = 0; i < nrFields; ++i) {
                Node fnode = XmlHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.fieldName[i] = XmlHandler.getTagValue((Node)fnode, (String)"name");
                String stype = XmlHandler.getTagValue((Node)fnode, (String)"type");
                this.fieldFormat[i] = XmlHandler.getTagValue((Node)fnode, (String)"format");
                this.fieldGroup[i] = XmlHandler.getTagValue((Node)fnode, (String)"group");
                this.fieldDecimal[i] = XmlHandler.getTagValue((Node)fnode, (String)"decimal");
                this.fieldCurrency[i] = XmlHandler.getTagValue((Node)fnode, (String)"currency");
                String slen = XmlHandler.getTagValue((Node)fnode, (String)"length");
                String sprc = XmlHandler.getTagValue((Node)fnode, (String)"precision");
                this.fieldNullIf[i] = XmlHandler.getTagValue((Node)fnode, (String)"nullif");
                this.fieldIfNull[i] = XmlHandler.getTagValue((Node)fnode, (String)"ifnull");
                String trim = XmlHandler.getTagValue((Node)fnode, (String)"trimtype");
                this.fieldType[i] = ValueMetaFactory.getIdForValueMeta((String)stype);
                this.fieldLength[i] = Const.toInt((String)slen, (int)-1);
                this.fieldPrecision[i] = Const.toInt((String)sprc, (int)-1);
                this.fieldTrimType[i] = ValueMetaBase.getTrimTypeByCode((String)trim);
            }
        }
        catch (Exception e) {
            throw new HopXmlException(BaseMessages.getString(PKG, (String)"RegexEvalMeta.Exception.UnableToLoadTransformMetaFromXML", (String[])new String[0]), (Throwable)e);
        }
    }

    public void setDefault() {
        this.script = "";
        this.matcher = "";
        this.resultfieldname = "result";
        this.usevar = false;
        this.allowcapturegroups = false;
        this.replacefields = true;
        this.canoneq = false;
        this.caseinsensitive = false;
        this.comment = false;
        this.dotall = false;
        this.multiline = false;
        this.unicode = false;
        this.unix = false;
        this.allocate(0);
    }

    public void getFields(IRowMeta inputRowMeta, String name, IRowMeta[] infos, TransformMeta nextTransforms, IVariables variables, IHopMetadataProvider metadataProviders) throws HopTransformException {
        try {
            if (!Utils.isEmpty((CharSequence)this.resultfieldname)) {
                if (this.replacefields) {
                    int replaceIndex = inputRowMeta.indexOfValue(this.resultfieldname);
                    if (replaceIndex < 0) {
                        ValueMetaBoolean v = new ValueMetaBoolean(variables.resolve(this.resultfieldname));
                        v.setOrigin(name);
                        inputRowMeta.addValueMeta((IValueMeta)v);
                    } else {
                        IValueMeta valueMeta = inputRowMeta.getValueMeta(replaceIndex);
                        IValueMeta replaceMeta = ValueMetaFactory.cloneValueMeta((IValueMeta)valueMeta, (int)4);
                        replaceMeta.setOrigin(name);
                        inputRowMeta.setValueMeta(replaceIndex, replaceMeta);
                    }
                } else {
                    ValueMetaBoolean v = new ValueMetaBoolean(variables.resolve(this.resultfieldname));
                    v.setOrigin(name);
                    inputRowMeta.addValueMeta((IValueMeta)v);
                }
            }
            if (this.allowcapturegroups) {
                for (int i = 0; i < this.fieldName.length; ++i) {
                    if (Utils.isEmpty((CharSequence)this.fieldName[i])) continue;
                    if (this.replacefields) {
                        int replaceIndex = inputRowMeta.indexOfValue(this.fieldName[i]);
                        if (replaceIndex < 0) {
                            inputRowMeta.addValueMeta(this.constructValueMeta(null, this.fieldName[i], i, name));
                            continue;
                        }
                        IValueMeta valueMeta = inputRowMeta.getValueMeta(replaceIndex);
                        IValueMeta replaceMeta = this.constructValueMeta(valueMeta, this.fieldName[i], i, name);
                        inputRowMeta.setValueMeta(replaceIndex, replaceMeta);
                        continue;
                    }
                    inputRowMeta.addValueMeta(this.constructValueMeta(null, this.fieldName[i], i, name));
                }
            }
        }
        catch (Exception e) {
            throw new HopTransformException((Throwable)e);
        }
    }

    private IValueMeta constructValueMeta(IValueMeta sourceValueMeta, String fieldName, int i, String name) throws HopPluginException {
        int type = this.fieldType[i];
        if (type == 0) {
            type = 2;
        }
        IValueMeta v = sourceValueMeta == null ? ValueMetaFactory.createValueMeta((String)fieldName, (int)type) : ValueMetaFactory.cloneValueMeta((IValueMeta)sourceValueMeta, (int)type);
        v.setLength(this.fieldLength[i]);
        v.setPrecision(this.fieldPrecision[i]);
        v.setOrigin(name);
        v.setConversionMask(this.fieldFormat[i]);
        v.setDecimalSymbol(this.fieldDecimal[i]);
        v.setGroupingSymbol(this.fieldGroup[i]);
        v.setCurrencySymbol(this.fieldCurrency[i]);
        v.setTrimType(this.fieldTrimType[i]);
        return v;
    }

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        this.readData(transformNode, metadataProvider);
    }

    public String getXml() {
        StringBuilder retval = new StringBuilder();
        retval.append("    " + XmlHandler.addTagValue((String)"script", (String)this.script));
        retval.append("    " + XmlHandler.addTagValue((String)"matcher", (String)this.matcher));
        retval.append("    " + XmlHandler.addTagValue((String)"resultfieldname", (String)this.resultfieldname));
        retval.append("    " + XmlHandler.addTagValue((String)"usevar", (boolean)this.usevar));
        retval.append("    " + XmlHandler.addTagValue((String)"allowcapturegroups", (boolean)this.allowcapturegroups));
        retval.append("    " + XmlHandler.addTagValue((String)"replacefields", (boolean)this.replacefields));
        retval.append("    " + XmlHandler.addTagValue((String)"canoneq", (boolean)this.canoneq));
        retval.append("    " + XmlHandler.addTagValue((String)"caseinsensitive", (boolean)this.caseinsensitive));
        retval.append("    " + XmlHandler.addTagValue((String)"comment", (boolean)this.comment));
        retval.append("    " + XmlHandler.addTagValue((String)"dotall", (boolean)this.dotall));
        retval.append("    " + XmlHandler.addTagValue((String)"multiline", (boolean)this.multiline));
        retval.append("    " + XmlHandler.addTagValue((String)"unicode", (boolean)this.unicode));
        retval.append("    " + XmlHandler.addTagValue((String)"unix", (boolean)this.unix));
        retval.append("    <fields>").append(Const.CR);
        for (int i = 0; i < this.fieldName.length; ++i) {
            if (Utils.isEmpty((CharSequence)this.fieldName[i])) continue;
            retval.append("      <field>").append(Const.CR);
            retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"name", (String)this.fieldName[i]));
            retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"type", (String)ValueMetaFactory.getValueMetaName((int)this.fieldType[i])));
            retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"format", (String)this.fieldFormat[i]));
            retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"group", (String)this.fieldGroup[i]));
            retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"decimal", (String)this.fieldDecimal[i]));
            retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"length", (int)this.fieldLength[i]));
            retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"precision", (int)this.fieldPrecision[i]));
            retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"nullif", (String)this.fieldNullIf[i]));
            retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"ifnull", (String)this.fieldIfNull[i]));
            retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"trimtype", (String)ValueMetaBase.getTrimTypeCode((int)this.fieldTrimType[i])));
            retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"currency", (String)this.fieldCurrency[i]));
            retval.append("      </field>").append(Const.CR);
        }
        retval.append("    </fields>").append(Const.CR);
        return retval.toString();
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        if (prev != null && !prev.isEmpty()) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"RegexEvalMeta.CheckResult.ConnectedTransformOK", (String[])new String[]{String.valueOf(prev.size())}), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"RegexEvalMeta.CheckResult.NoInputReceived", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (!Utils.isEmpty((CharSequence)this.matcher)) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"RegexEvalMeta.CheckResult.MatcherOK", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"RegexEvalMeta.CheckResult.NoMatcher", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (!Utils.isEmpty((CharSequence)this.resultfieldname)) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"RegexEvalMeta.CheckResult.ResultFieldnameOK", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"RegexEvalMeta.CheckResult.NoResultFieldname", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public boolean supportsErrorHandling() {
        return true;
    }
}

