/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobgraph;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobgraph.JobVertexResourceRequirements;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.Preconditions;

public class JobResourceRequirements
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String JOB_RESOURCE_REQUIREMENTS_KEY = "$internal.job-resource-requirements";
    private static final JobResourceRequirements EMPTY = new JobResourceRequirements(Collections.emptyMap());
    private final Map<JobVertexID, JobVertexResourceRequirements> vertexResources;

    public static void writeToJobGraph(JobGraph jobGraph, JobResourceRequirements jobResourceRequirements) throws IOException {
        InstantiationUtil.writeObjectToConfig((Object)jobResourceRequirements, (Configuration)jobGraph.getJobConfiguration(), (String)JOB_RESOURCE_REQUIREMENTS_KEY);
    }

    public static Optional<JobResourceRequirements> readFromJobGraph(JobGraph jobGraph) throws IOException {
        try {
            return Optional.ofNullable(InstantiationUtil.readObjectFromConfig((Configuration)jobGraph.getJobConfiguration(), (String)JOB_RESOURCE_REQUIREMENTS_KEY, (ClassLoader)JobResourceRequirements.class.getClassLoader()));
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Unable to deserialize JobResourceRequirements due to missing classes. This might happen when the JobGraph was written from a different Flink version.", e);
        }
    }

    public static List<String> validate(JobResourceRequirements jobResourceRequirements, Map<JobVertexID, Integer> maxParallelismPerVertex) {
        ArrayList<String> errors = new ArrayList<String>();
        HashSet<JobVertexID> missingJobVertexIds = new HashSet<JobVertexID>(maxParallelismPerVertex.keySet());
        for (JobVertexID jobVertexId : jobResourceRequirements.getJobVertices()) {
            missingJobVertexIds.remove(jobVertexId);
            Optional<Integer> maybeMaxParallelism = Optional.ofNullable(maxParallelismPerVertex.get(jobVertexId));
            if (maybeMaxParallelism.isPresent()) {
                int upperBound;
                JobVertexResourceRequirements.Parallelism requestedParallelism = jobResourceRequirements.getParallelism(jobVertexId);
                int lowerBound = requestedParallelism.getLowerBound() == -1 ? 1 : requestedParallelism.getLowerBound();
                int n = upperBound = requestedParallelism.getUpperBound() == -1 ? maybeMaxParallelism.get().intValue() : requestedParallelism.getUpperBound();
                if (lowerBound < 1 || upperBound < 1) {
                    errors.add(String.format("Both, the requested lower bound [%d] and upper bound [%d] for job vertex [%s] must be greater than zero.", lowerBound, upperBound, jobVertexId));
                    continue;
                }
                if (lowerBound > upperBound) {
                    errors.add(String.format("The requested lower bound [%d] for job vertex [%s] is higher than the upper bound [%d].", lowerBound, jobVertexId, upperBound));
                }
                if (maybeMaxParallelism.get() >= upperBound) continue;
                errors.add(String.format("The newly requested parallelism %d for the job vertex %s exceeds its maximum parallelism %d.", upperBound, jobVertexId, maybeMaxParallelism.get()));
                continue;
            }
            errors.add(String.format("Job vertex [%s] was not found in the JobGraph.", jobVertexId));
        }
        for (JobVertexID jobVertexId : missingJobVertexIds) {
            errors.add(String.format("The request is incomplete, missing job vertex [%s] resource requirements.", jobVertexId));
        }
        return errors;
    }

    public static JobResourceRequirements empty() {
        return EMPTY;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public JobResourceRequirements(Map<JobVertexID, JobVertexResourceRequirements> vertexResources) {
        this.vertexResources = Collections.unmodifiableMap(new HashMap((Map)Preconditions.checkNotNull(vertexResources)));
    }

    public JobVertexResourceRequirements.Parallelism getParallelism(JobVertexID jobVertexId) {
        return Optional.ofNullable(this.vertexResources.get(jobVertexId)).map(JobVertexResourceRequirements::getParallelism).orElseThrow(() -> new IllegalStateException("No requirement set for vertex " + jobVertexId));
    }

    public Set<JobVertexID> getJobVertices() {
        return this.vertexResources.keySet();
    }

    public Map<JobVertexID, JobVertexResourceRequirements> getJobVertexParallelisms() {
        return this.vertexResources;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobResourceRequirements that = (JobResourceRequirements)o;
        return Objects.equals(this.vertexResources, that.vertexResources);
    }

    public int hashCode() {
        return Objects.hash(this.vertexResources);
    }

    public String toString() {
        return "JobResourceRequirements{vertexResources=" + this.vertexResources + '}';
    }

    public static final class Builder {
        private final Map<JobVertexID, JobVertexResourceRequirements> vertexResources = new HashMap<JobVertexID, JobVertexResourceRequirements>();

        public Builder setParallelismForJobVertex(JobVertexID jobVertexId, int lowerBound, int upperBound) {
            this.vertexResources.put(jobVertexId, new JobVertexResourceRequirements(new JobVertexResourceRequirements.Parallelism(lowerBound, upperBound)));
            return this;
        }

        public JobResourceRequirements build() {
            return new JobResourceRequirements(this.vertexResources);
        }
    }
}

